/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import net.satisfy.meadow.core.registry.TagRegistry;
import org.jetbrains.annotations.NotNull;

public enum WoolyCowVariant implements StringRepresentable
{
    HIGHLAND(0, "highland_cattle", ((Block)ObjectRegistry.LINEN_WOOL.get()).asItem(), (Item)ObjectRegistry.WOODEN_MILK_BUCKET.get()),
    UMBRA(1, "umbra_cow", ((Block)ObjectRegistry.CHAMBRAY_WOOL.get()).asItem(), (Item)ObjectRegistry.WOODEN_MILK_BUCKET.get()),
    WARPED(2, "warped_cow", ((Block)ObjectRegistry.WARPED_WOOL.get()).asItem(), (Item)ObjectRegistry.WOODEN_WARPED_MILK_BUCKET.get());

    private static final IntFunction<WoolyCowVariant> BY_ID;
    private final int id;
    private final String name;
    private final Item wool;
    private final Item bucket;
    private static final Map<WoolyCowVariant, TagKey<Biome>> SPAWNS;

    private WoolyCowVariant(int id, String name, Item wool, Item bucket) {
        this.id = id;
        this.name = name;
        this.wool = wool;
        this.bucket = bucket;
    }

    public Item getWool() {
        return this.wool;
    }

    public Item getBucket() {
        return this.bucket;
    }

    public int getId() {
        return this.id;
    }

    public static WoolyCowVariant byId(int i) {
        return BY_ID.apply(i);
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    public static WoolyCowVariant getRandomVariant(LevelAccessor levelAccessor, BlockPos blockPos, boolean spawnEgg) {
        Holder holder = levelAccessor.getBiome(blockPos);
        RandomSource random = levelAccessor.getRandom();
        List<WoolyCowVariant> possibleVars = WoolyCowVariant.getShearableCowVariantsInBiome((Holder<Biome>)holder);
        int size = possibleVars.size();
        if (size == 0 || spawnEgg) {
            if (spawnEgg) {
                return (WoolyCowVariant)((Object)Util.getRandom((Object[])WoolyCowVariant.values(), (RandomSource)random));
            }
            if (holder.is(BiomeTags.IS_NETHER)) {
                return WARPED;
            }
            ArrayList<WoolyCowVariant> list = new ArrayList<WoolyCowVariant>(List.of(WoolyCowVariant.values()));
            list.remove((Object)WARPED);
            return (WoolyCowVariant)((Object)Util.getRandom(list, (RandomSource)random));
        }
        return possibleVars.get(levelAccessor.getRandom().nextInt(size));
    }

    private static List<WoolyCowVariant> getShearableCowVariantsInBiome(Holder<Biome> biome) {
        return SPAWNS.keySet().stream().filter(ShearableCowVariant -> biome.is(SPAWNS.get(ShearableCowVariant))).collect(Collectors.toList());
    }

    static {
        BY_ID = ByIdMap.continuous(WoolyCowVariant::getId, (Object[])WoolyCowVariant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        SPAWNS = (Map)Util.make(new HashMap(), map -> {
            map.put(HIGHLAND, TagRegistry.IS_MEADOW);
            map.put(UMBRA, TagRegistry.SPAWNS_UMBRA_COW);
            map.put(WARPED, TagRegistry.SPAWNS_WARPED_COW);
        });
    }
}

