/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.satisfy.meadow.core.registry.RecipeRegistry;
import org.jetbrains.annotations.NotNull;

public class FeltingRecipe
implements Recipe<RecipeInput> {
    private final Ingredient ingredient;
    private final ItemStack result;

    public FeltingRecipe(Ingredient ingredient, ItemStack result) {
        this.ingredient = ingredient;
        this.result = result;
    }

    public boolean matches(RecipeInput input, Level level) {
        return this.ingredient.test(input.getItem(0));
    }

    @NotNull
    public ItemStack assemble(RecipeInput input, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result.copy();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeRegistry.FELTING_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipeRegistry.FELTING.get();
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public static class Serializer
    implements RecipeSerializer<FeltingRecipe> {
        public static final MapCodec<FeltingRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(FeltingRecipe::getIngredient), (App)ItemStack.CODEC.fieldOf("result").forGetter(FeltingRecipe::getResult)).apply((Applicative)i, FeltingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FeltingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, FeltingRecipe::getIngredient, (StreamCodec)ItemStack.STREAM_CODEC, FeltingRecipe::getResult, FeltingRecipe::new);

        @NotNull
        public MapCodec<FeltingRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, FeltingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

