/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.neoforge.core.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeSpecialEffectsBuilder;
import net.satisfy.meadow.neoforge.core.registry.MeadowBiomeModifiers;
import org.jetbrains.annotations.NotNull;

public record AddBiomeEffectsModifier(HolderSet<Biome> biomes, Optional<Integer> grassColor, Optional<Integer> foliageColor, Optional<Integer> waterColor, Optional<Integer> waterFogColor) implements BiomeModifier
{
    public static final MapCodec<AddBiomeEffectsModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(AddBiomeEffectsModifier::biomes), (App)Codec.INT.optionalFieldOf("grass_color").forGetter(AddBiomeEffectsModifier::grassColor), (App)Codec.INT.optionalFieldOf("foliage_color").forGetter(AddBiomeEffectsModifier::foliageColor), (App)Codec.INT.optionalFieldOf("water_color").forGetter(AddBiomeEffectsModifier::waterColor), (App)Codec.INT.optionalFieldOf("water_fog_color").forGetter(AddBiomeEffectsModifier::waterFogColor)).apply((Applicative)instance, AddBiomeEffectsModifier::new));

    public void modify(@NotNull Holder<Biome> biome, @NotNull BiomeModifier.Phase phase, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (!this.biomes.contains(biome)) {
            return;
        }
        if (phase != BiomeModifier.Phase.BEFORE_EVERYTHING && phase != BiomeModifier.Phase.MODIFY) {
            return;
        }
        BiomeSpecialEffectsBuilder effects = builder.getSpecialEffects();
        this.grassColor.ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)effects).grassColorOverride(arg_0));
        this.foliageColor.ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)effects).foliageColorOverride(arg_0));
        this.waterColor.ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)effects).waterColor(arg_0));
        this.waterFogColor.ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)effects).waterFogColor(arg_0));
    }

    @NotNull
    public MapCodec<? extends BiomeModifier> codec() {
        return MeadowBiomeModifiers.BIOME_EFFECTS.get();
    }
}

