/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.fluids.printer;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createdragonsplus.util.CodeReference;
import plus.dragons.createenchantmentindustry.common.fluids.printer.behaviour.PrintingBehaviour;
import plus.dragons.createenchantmentindustry.common.fluids.printer.behaviour.RecipePrintingBehaviour;

public class PrinterBehaviour
extends FilteringBehaviour {
    public static final BehaviourType<PrinterBehaviour> TYPE = new BehaviourType();
    public static final String TEMPLATE = "PrintingTemplate";
    private final SmartFluidTankBehaviour tank;
    private PrintingBehaviour printing = new RecipePrintingBehaviour(ItemStack.EMPTY);

    public PrinterBehaviour(SmartBlockEntity be, SmartFluidTankBehaviour tank, ValueBoxTransform slot) {
        super(be, slot);
        this.tank = tank;
    }

    public PrintingBehaviour getPrintingBehaviour() {
        return this.printing;
    }

    public boolean setFilter(ItemStack stack, @Nullable Player player) {
        Optional result = PrintingBehaviour.create(this.getWorld(), this.tank, stack).resultOrPartial(message -> {
            if (player != null) {
                player.displayClientMessage((Component)Component.translatable((String)message), true);
            }
        });
        if (result.isPresent() && super.setFilter(stack)) {
            this.printing = (PrintingBehaviour)result.get();
            return true;
        }
        return false;
    }

    public boolean setFilter(ItemStack stack) {
        return this.setFilter(stack, null);
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void write(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        nbt.put(TEMPLATE, this.getFilter().saveOptional(registries));
    }

    public void writeSafe(CompoundTag nbt, HolderLookup.Provider registries) {
        if (this.printing.isSafeNBT()) {
            nbt.put(TEMPLATE, this.getFilter().saveOptional(registries));
        }
    }

    public void read(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        FilterItemStack filter = FilterItemStack.of((HolderLookup.Provider)registries, (CompoundTag)nbt.getCompound(TEMPLATE));
        Optional printing = PrintingBehaviour.create(this.getWorld(), this.tank, filter.item()).result();
        if (printing.isPresent()) {
            this.filter = filter;
            this.printing = (PrintingBehaviour)printing.get();
        } else {
            this.filter = FilterItemStack.empty();
            this.printing = RecipePrintingBehaviour.EMPTY;
        }
    }

    public String getClipboardKey() {
        return "Printer";
    }

    public boolean writeToClipboard(HolderLookup.Provider registries, CompoundTag tag, Direction side) {
        ItemStack template = this.getFilter();
        tag.put(TEMPLATE, template.saveOptional(registries));
        return true;
    }

    public boolean readFromClipboard(HolderLookup.Provider registries, CompoundTag tag, Player player, Direction side, boolean simulate) {
        if (!tag.contains(TEMPLATE)) {
            return false;
        }
        ItemStack template = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound(TEMPLATE));
        return this.setFilter(template, player);
    }

    @CodeReference(value={FilteringBehaviour.class}, targets={"onShortInteract"}, source={"create"}, license={"mit"})
    public void onShortInteract(Player player, InteractionHand hand, Direction side, BlockHitResult hitResult) {
        Level level = this.getWorld();
        BlockPos pos = this.getPos();
        ItemStack itemInHand = player.getItemInHand(hand);
        ItemStack toApply = itemInHand.copy();
        if (!this.canShortInteract(toApply)) {
            return;
        }
        if (level.isClientSide()) {
            return;
        }
        if (this.getFilter().getItem() instanceof FilterItem && (!player.isCreative() || ItemHelper.extract((IItemHandler)new InvWrapper((Container)player.getInventory()), stack -> ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)this.getFilter(side)), (boolean)true).isEmpty())) {
            player.getInventory().placeItemBackInInventory(this.getFilter(side).copy());
        }
        if (toApply.getItem() instanceof FilterItem) {
            toApply.setCount(1);
        }
        if (!this.setFilter(toApply, player)) {
            AllSoundEvents.DENY.playOnServer(player.level(), (Vec3i)player.blockPosition(), 1.0f, 1.0f);
            return;
        }
        if (!player.isCreative() && toApply.getItem() instanceof FilterItem) {
            if (itemInHand.getCount() == 1) {
                player.setItemInHand(hand, ItemStack.EMPTY);
            } else {
                itemInHand.shrink(1);
            }
        }
        level.playSound(null, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 0.25f, 0.1f);
    }
}

