/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block.entity;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.beachparty.client.gui.handler.MiniFridgeGuiHandler;
import net.satisfy.beachparty.core.recipe.MiniFridgeRecipe;
import net.satisfy.beachparty.core.registry.EntityTypeRegistry;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.core.registry.RecipeTypeRegistry;
import net.satisfy.beachparty.core.world.ImplementedInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MiniFridgeBlockEntity
extends BlockEntity
implements ImplementedInventory,
BlockEntityTicker<MiniFridgeBlockEntity>,
MenuProvider {
    public static final int CAPACITY = 2;
    private static final int[] SLOTS_FOR_INPUT = new int[]{1};
    private static final int[] SLOTS_FOR_OUTPUT = new int[]{0};
    private static final int OUTPUT_SLOT = 0;
    private static final int INPUT_SLOT = 1;
    protected float experience;
    private NonNullList<ItemStack> inventory;
    private int fermentationTime = 0;
    private int totalFermentationTime;
    private final ContainerData propertyDelegate = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> MiniFridgeBlockEntity.this.fermentationTime;
                case 1 -> MiniFridgeBlockEntity.this.totalFermentationTime;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    MiniFridgeBlockEntity.this.fermentationTime = value;
                    break;
                }
                case 1: {
                    MiniFridgeBlockEntity.this.totalFermentationTime = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };

    public MiniFridgeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.MINI_FRIDGE_BLOCK_ENTITY.get(), pos, state);
        this.inventory = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.inventory = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)provider);
        this.fermentationTime = nbt.getInt("FermentationTime");
        this.totalFermentationTime = nbt.getInt("TotalFermentationTime");
        this.experience = nbt.getFloat("Experience");
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.inventory, (HolderLookup.Provider)provider);
        compoundTag.putInt("FermentationTime", this.fermentationTime);
        compoundTag.putInt("TotalFermentationTime", this.totalFermentationTime);
        compoundTag.putFloat("Experience", this.experience);
    }

    public void tick(Level world, BlockPos pos, BlockState state, MiniFridgeBlockEntity blockEntity) {
        if (world.isClientSide) {
            return;
        }
        boolean dirty = false;
        List recipes = world.getRecipeManager().getAllRecipesFor((RecipeType)RecipeTypeRegistry.MINI_FRIDGE_RECIPE_TYPE.get());
        Optional<MiniFridgeRecipe> recipeType = Optional.ofNullable(this.getRecipe(recipes, this.inventory));
        assert (this.level != null);
        RegistryAccess access = this.level.registryAccess();
        if (recipeType.isPresent() && this.canCraft(recipeType.get(), access)) {
            if (this.fermentationTime == 0) {
                this.totalFermentationTime = recipeType.get().getCraftingTime();
            }
            ++this.fermentationTime;
            if (this.fermentationTime >= this.totalFermentationTime) {
                this.fermentationTime = 0;
                this.craft(recipeType.get(), access);
                dirty = true;
            }
        } else {
            this.fermentationTime = 0;
        }
        if (dirty) {
            this.setChanged();
        }
    }

    private boolean canCraft(MiniFridgeRecipe recipe, RegistryAccess access) {
        if (recipe == null || recipe.getResultItem((HolderLookup.Provider)access).isEmpty()) {
            return false;
        }
        ItemStack inputStack = this.getItem(1);
        ItemStack outputStack = this.getItem(0);
        return !inputStack.isEmpty() && (outputStack.isEmpty() || outputStack == recipe.getResultItem((HolderLookup.Provider)access));
    }

    private void craft(MiniFridgeRecipe recipe, RegistryAccess access) {
        if (!this.canCraft(recipe, access)) {
            return;
        }
        ItemStack recipeOutput = recipe.getResultItem((HolderLookup.Provider)access);
        ItemStack outputSlotStack = this.getItem(0);
        if (outputSlotStack.isEmpty()) {
            this.setItem(0, recipeOutput.copy());
        }
        ItemStack inputStack = this.getItem(1);
        inputStack.shrink(1);
        this.setItem(1, inputStack.isEmpty() ? ItemStack.EMPTY : inputStack);
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    @Override
    public int @NotNull [] getSlotsForFace(Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_FOR_OUTPUT;
        }
        return SLOTS_FOR_INPUT;
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
        if (slot == 1) {
            this.totalFermentationTime = 50;
            this.fermentationTime = 0;
            this.setChanged();
        }
    }

    @Override
    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction dir) {
        return slot == 1;
    }

    @Override
    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction dir) {
        return slot == 0;
    }

    @Override
    public boolean stillValid(Player player) {
        assert (this.level != null);
        return this.level.getBlockEntity(this.worldPosition) == this && player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    @NotNull
    public Component getDisplayName() {
        return ((Block)ObjectRegistry.MINI_FRIDGE.get()).getName();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
        return new MiniFridgeGuiHandler(syncId, inv, (Container)this, this.propertyDelegate);
    }

    private MiniFridgeRecipe getRecipe(List<RecipeHolder<MiniFridgeRecipe>> recipes, NonNullList<ItemStack> inventory) {
        block0: for (RecipeHolder<MiniFridgeRecipe> recipeHolder : recipes) {
            MiniFridgeRecipe recipe = (MiniFridgeRecipe)recipeHolder.value();
            for (Ingredient ingredient : recipe.getIngredients()) {
                boolean ingredientFound = false;
                for (int slotIndex = 1; slotIndex < inventory.size(); ++slotIndex) {
                    ItemStack slotItem = (ItemStack)inventory.get(slotIndex);
                    if (!ingredient.test(slotItem)) continue;
                    ingredientFound = true;
                    break;
                }
                if (ingredientFound) continue;
                continue block0;
            }
            return recipe;
        }
        return null;
    }
}

