/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.api.datagen.builders.templates.page;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.datagen.builders.page_components.TemplateComponentBuilder;
import net.favouriteless.modopedia.api.multiblock.Multiblock;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;

public class MultiblockPageBuilder
extends TemplateComponentBuilder {
    public static final ResourceLocation ID = Modopedia.id("page/multiblock");
    private final String text;
    private Either<Integer, String> height;
    private Either<Integer, String> textOffset;
    private Either<Multiblock, String> multiblock;
    private Either<ResourceLocation, String> multiblockId;
    private Either<Float, String> offsetX;
    private Either<Float, String> offsetY;
    private Either<Float, String> scale;
    private Either<Float, String> viewAngle;
    private Either<Boolean, String> noOffsets;

    protected MultiblockPageBuilder(String text) {
        super(ID);
        this.text = text;
    }

    public static MultiblockPageBuilder of(String text) {
        return new MultiblockPageBuilder(text);
    }

    @Override
    public MultiblockPageBuilder x(int x) {
        return (MultiblockPageBuilder)super.x(x);
    }

    @Override
    public MultiblockPageBuilder x(String x) {
        return (MultiblockPageBuilder)super.x(x);
    }

    @Override
    public MultiblockPageBuilder y(int y) {
        return (MultiblockPageBuilder)super.y(y);
    }

    @Override
    public MultiblockPageBuilder y(String y) {
        return (MultiblockPageBuilder)super.y(y);
    }

    public MultiblockPageBuilder multiblock(Multiblock multiblock) {
        this.multiblock = Either.left((Object)multiblock);
        return this;
    }

    public MultiblockPageBuilder multiblock(String multiblock) {
        this.multiblock = Either.right((Object)multiblock);
        return this;
    }

    public MultiblockPageBuilder multiblockId(ResourceLocation multiblock) {
        this.multiblockId = Either.left((Object)multiblock);
        return this;
    }

    public MultiblockPageBuilder multiblockId(String multiblock) {
        this.multiblockId = Either.right((Object)multiblock);
        return this;
    }

    public MultiblockPageBuilder height(int height) {
        this.height = Either.left((Object)height);
        return this;
    }

    public MultiblockPageBuilder height(String height) {
        this.height = Either.right((Object)height);
        return this;
    }

    public MultiblockPageBuilder scale(float scale) {
        this.scale = Either.left((Object)Float.valueOf(scale));
        return this;
    }

    public MultiblockPageBuilder scale(String scale) {
        this.scale = Either.right((Object)scale);
        return this;
    }

    public MultiblockPageBuilder offsetX(float offsetX) {
        this.offsetX = Either.left((Object)Float.valueOf(offsetX));
        return this;
    }

    public MultiblockPageBuilder offsetX(String offsetX) {
        this.offsetX = Either.right((Object)offsetX);
        return this;
    }

    public MultiblockPageBuilder offsetY(float offsetY) {
        this.offsetY = Either.left((Object)Float.valueOf(offsetY));
        return this;
    }

    public MultiblockPageBuilder offsetY(String offsetY) {
        this.offsetY = Either.right((Object)offsetY);
        return this;
    }

    public MultiblockPageBuilder viewAngle(float viewAngle) {
        this.viewAngle = Either.left((Object)Float.valueOf(viewAngle));
        return this;
    }

    public MultiblockPageBuilder viewAngle(String viewAngle) {
        this.viewAngle = Either.right((Object)viewAngle);
        return this;
    }

    public MultiblockPageBuilder noOffsets(boolean noOffsets) {
        this.noOffsets = Either.left((Object)noOffsets);
        return this;
    }

    public MultiblockPageBuilder noOffsets(String noOffsets) {
        this.noOffsets = Either.right((Object)noOffsets);
        return this;
    }

    public MultiblockPageBuilder textOffset(int textOffset) {
        this.textOffset = Either.left((Object)textOffset);
        return this;
    }

    public MultiblockPageBuilder textOffset(String textOffset) {
        this.textOffset = Either.right((Object)textOffset);
        return this;
    }

    @Override
    protected void build(JsonObject json, RegistryOps<JsonElement> ops) {
        json.add("text", (JsonElement)new JsonPrimitive(this.text));
        if (this.textOffset != null) {
            json.add("text_offset", this.resolveNum(this.textOffset));
        }
        if (this.height != null) {
            json.add("height", this.resolveNum(this.height));
        }
        if (this.multiblock != null) {
            json.add("multiblock", this.resolve(this.multiblock, m -> (JsonElement)Multiblock.codec().encodeStart((DynamicOps)ops, m).getOrThrow()));
        }
        if (this.multiblockId != null) {
            json.add("multiblock_id", this.resolveResourceLocation(this.multiblockId));
        }
        if (this.offsetX != null) {
            json.add("offset_x", this.resolveNum(this.offsetX));
        }
        if (this.offsetY != null) {
            json.add("offset_y", this.resolveNum(this.offsetY));
        }
        if (this.scale != null) {
            json.add("scale", this.resolveNum(this.scale));
        }
        if (this.viewAngle != null) {
            json.add("view_angle", this.resolveNum(this.viewAngle));
        }
        if (this.noOffsets != null) {
            json.add("no_offsets", this.resolveBool(this.noOffsets));
        }
    }
}

