/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.api.datagen.providers;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.favouriteless.modopedia.api.datagen.BookContentBuilder;
import net.favouriteless.modopedia.api.datagen.BookContentOutput;
import net.favouriteless.modopedia.api.datagen.BookOutput;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;

public abstract class ContentSetProvider
implements DataProvider {
    private final String modId;
    private final CompletableFuture<HolderLookup.Provider> registries;
    private final PackOutput.PathProvider entryPathProvider;
    private final PackOutput.PathProvider categoryPathProvider;
    private final String book;
    private final String language;

    protected ContentSetProvider(String modId, String book, String language, CompletableFuture<HolderLookup.Provider> registries, PackOutput output) {
        this.entryPathProvider = output.createPathProvider(PackOutput.Target.RESOURCE_PACK, "modopedia/books/" + book + "/" + language + "/entries");
        this.categoryPathProvider = output.createPathProvider(PackOutput.Target.RESOURCE_PACK, "modopedia/books/" + book + "/" + language + "/categories");
        this.registries = registries;
        this.book = book;
        this.language = language;
        this.modId = modId;
    }

    public abstract void buildEntries(HolderLookup.Provider var1, BookContentOutput var2);

    public abstract void buildCategories(HolderLookup.Provider var1, BookContentOutput var2);

    public CompletableFuture<?> run(CachedOutput output) {
        return this.registries.thenCompose(registries -> this.run(output, (HolderLookup.Provider)registries));
    }

    private CompletableFuture<?> run(CachedOutput output, HolderLookup.Provider registries) {
        HashSet entries = Sets.newHashSet();
        HashSet categories = Sets.newHashSet();
        ArrayList futures = new ArrayList();
        RegistryOps ops = registries.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        HashMap<String, List<String>> links = new HashMap<String, List<String>>();
        this.buildEntries(registries, new Output(links, (id, builder) -> {
            if (!entries.add(id)) {
                throw new IllegalStateException("Duplicate entry in " + this.getName() + " " + id);
            }
            futures.add(DataProvider.saveStable((CachedOutput)output, (JsonElement)builder.build((RegistryOps<JsonElement>)ops), (Path)this.entryPathProvider.json(ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)id))));
        }));
        this.buildCategories(registries, new Output(links, (id, builder) -> {
            if (!categories.add(id)) {
                throw new IllegalStateException("Duplicate category in " + this.getName() + " " + id);
            }
            futures.add(DataProvider.saveStable((CachedOutput)output, (JsonElement)builder.build((RegistryOps<JsonElement>)ops), (Path)this.categoryPathProvider.json(ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)id))));
        }));
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public String getName() {
        return "Modopedia BookContent[" + this.modId + "]: " + this.book + "[" + this.language + "]";
    }

    private record Output(Map<String, List<String>> links, BookOutput out) implements BookContentOutput
    {
        @Override
        public List<String> getEntries(String to) {
            return this.links.containsKey(to) ? this.links.get(to) : List.of();
        }

        @Override
        public void addLink(String from, String to) {
            this.links.computeIfAbsent(to, s -> new ArrayList()).add(from);
        }

        @Override
        public void accept(String id, BookContentBuilder builder) {
            this.out.accept(id, builder);
        }
    }
}

