/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.book;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.favouriteless.modopedia.api.book.Entry;
import net.favouriteless.modopedia.api.book.Page;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class EntryImpl
implements Entry {
    public static final Supplier<ItemStack> DEFAULT_ICON = () -> ((Item)Items.GRASS_BLOCK).getDefaultInstance();
    private final String title;
    private final ItemStack iconStack;
    private final List<ResourceLocation> assignedItems;
    private final ResourceLocation advancement;
    private final List<Page> pages = new ArrayList<Page>();
    public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("title").forGetter(Entry::getTitle), (App)ItemStack.CODEC.optionalFieldOf("icon", (Object)DEFAULT_ICON.get()).forGetter(Entry::getIcon), (App)ResourceLocation.CODEC.listOf().optionalFieldOf("assigned_items").forGetter(e -> Optional.ofNullable(e.getAssignedItems())), (App)ResourceLocation.CODEC.optionalFieldOf("advancement").forGetter(c -> Optional.ofNullable(c.getAdvancement()))).apply((Applicative)instance, (title, icon, assignedItem, advancement) -> new EntryImpl((String)title, (ItemStack)icon, assignedItem.orElse(List.of()), advancement.orElse(null))));

    public EntryImpl(String title, ItemStack iconStack, List<ResourceLocation> assignedItems, ResourceLocation advancement) {
        this.title = title;
        this.iconStack = iconStack;
        this.assignedItems = assignedItems;
        this.advancement = advancement;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public ItemStack getIcon() {
        return this.iconStack;
    }

    @Override
    public List<Page> getPages() {
        return this.pages;
    }

    @Override
    public List<ResourceLocation> getAssignedItems() {
        return this.assignedItems;
    }

    @Override
    public ResourceLocation getAdvancement() {
        return this.advancement;
    }

    public Entry addPages(List<Page> pages) {
        this.pages.addAll(pages);
        return this;
    }
}

