/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.book.registries.common;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.book.BookType;
import net.favouriteless.modopedia.api.registries.common.BookTypeRegistry;
import net.minecraft.resources.ResourceLocation;

public class BookTypeRegistryImpl
implements BookTypeRegistry {
    public static final BookTypeRegistryImpl INSTANCE = new BookTypeRegistryImpl();
    private final BiMap<ResourceLocation, BookType.Type<?>> types = HashBiMap.create();
    private final Codec<BookType.Type<?>> typeCodec = ResourceLocation.CODEC.flatXmap(r -> {
        BookType.Type<?> c = this.getType((ResourceLocation)r);
        return c != null ? DataResult.success(c) : DataResult.error(() -> "Unknown type " + String.valueOf(r));
    }, c -> {
        ResourceLocation location = (ResourceLocation)this.types.inverse().get(c);
        return c != null ? DataResult.success((Object)location) : DataResult.error(() -> "Unknown type " + String.valueOf(location));
    });
    private final Codec<BookType> codec = this.typeCodec.dispatch("id", BookType::type, BookType.Type::codec);

    private BookTypeRegistryImpl() {
    }

    @Override
    public void register(BookType.Type<?> type) {
        if (this.types.containsKey((Object)type.id())) {
            Modopedia.LOG.error("Attempted to register duplicate book type: {}", (Object)type.id());
        } else {
            this.types.put((Object)type.id(), type);
        }
    }

    @Override
    public BookType.Type<?> getType(ResourceLocation id) {
        return (BookType.Type)this.types.get((Object)id);
    }

    @Override
    public Codec<BookType> codec() {
        return this.codec;
    }
}

