/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.book.text;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.function.UnaryOperator;
import net.favouriteless.modopedia.api.text.StyleStack;
import net.minecraft.network.chat.Style;

public class TextState
implements StyleStack {
    private Style baseStyle;
    private final Deque<PartialTextState> stack = new ArrayDeque<PartialTextState>();

    public TextState(Style baseStyle) {
        this.baseStyle = baseStyle;
        this.stack.push(new PartialTextState(baseStyle));
    }

    @Override
    public void modify(UnaryOperator<Style> op) {
        if (!this.stack.isEmpty()) {
            this.stack.peek().modify(op);
        }
    }

    @Override
    public void push(Style style) {
        this.stack.push(new PartialTextState(style.applyTo(this.peek())));
    }

    @Override
    public void push() {
        this.stack.push(new PartialTextState(this.peek()));
    }

    @Override
    public Style pop() {
        return this.stack.pop().getStyle();
    }

    @Override
    public Style peek() {
        return !this.stack.isEmpty() ? this.stack.peek().getStyle() : this.baseStyle;
    }

    @Override
    public Style getBaseStyle() {
        return this.baseStyle;
    }

    @Override
    public void setBaseStyle(Style style) {
        this.baseStyle = style;
        for (PartialTextState partial : this.stack) {
            partial.replace(style);
            style = partial.getStyle();
        }
    }

    private static class PartialTextState {
        private Style style;
        private List<UnaryOperator<Style>> modifications = new ArrayList<UnaryOperator<Style>>();

        private PartialTextState(Style style) {
            this.style = style;
        }

        public Style getStyle() {
            return this.style;
        }

        public void modify(UnaryOperator<Style> op) {
            if (this.modifications == null) {
                this.modifications = new LinkedList<UnaryOperator<Style>>();
            }
            this.modifications.add(op);
            this.style = (Style)op.apply(this.style);
        }

        public void replace(Style style) {
            if (this.modifications != null) {
                for (UnaryOperator<Style> op : this.modifications) {
                    style = (Style)op.apply(style);
                }
            }
            this.style = style;
        }
    }
}

