/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.book.text.formatters;

import net.favouriteless.modopedia.api.text.StyleStack;
import net.favouriteless.modopedia.api.text.TextFormatter;
import net.minecraft.ChatFormatting;

public class ColorFormatter
implements TextFormatter {
    @Override
    public boolean matches(String tag) {
        return tag.startsWith("c:");
    }

    @Override
    public void apply(StyleStack stack, String tag) {
        ChatFormatting formatting;
        String colour = tag.substring(2);
        if (colour.matches("#[a-fA-F0-9]{6}")) {
            stack.modify(style -> style.withColor(Integer.decode(colour).intValue()));
            return;
        }
        if (colour.matches("\\d{1,2}")) {
            ChatFormatting formatting2 = ChatFormatting.getById((int)Integer.parseUnsignedInt(colour));
            if (formatting2 != null) {
                stack.modify(style -> style.withColor(formatting2));
                return;
            }
        } else if (colour.matches("[a-zA-Z]+") && (formatting = ChatFormatting.getByName((String)colour.toUpperCase())) != null) {
            stack.modify(style -> style.withColor(formatting));
            return;
        }
        stack.pop();
        throw new IllegalArgumentException(colour + " is not a valid colour ID, name or hex value.");
    }
}

