/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.multiblock;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.multiblock.Multiblock;
import net.favouriteless.modopedia.api.registries.client.MultiblockRegistry;
import net.favouriteless.modopedia.client.multiblock.DenseMultiblock;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class MultiblockRegistryImpl
implements MultiblockRegistry {
    public static final MultiblockRegistryImpl INSTANCE = new MultiblockRegistryImpl();
    private final BiMap<ResourceLocation, MapCodec<? extends Multiblock>> codecs = HashBiMap.create();
    private final Map<ResourceLocation, Multiblock> multiblocks = new HashMap<ResourceLocation, Multiblock>();
    private final Codec<MapCodec<? extends Multiblock>> typeCodec = ResourceLocation.CODEC.flatXmap(r -> {
        MapCodec<? extends Multiblock> c = this.getType((ResourceLocation)r);
        return c != null ? DataResult.success(c) : DataResult.error(() -> "Unknown type " + String.valueOf(r));
    }, c -> {
        ResourceLocation location = (ResourceLocation)this.codecs.inverse().get(c);
        return c != null ? DataResult.success((Object)location) : DataResult.error(() -> "Unknown type " + String.valueOf(location));
    });
    private final Codec<Multiblock> codec = this.typeCodec.dispatch("type", Multiblock::typeCodec, Function.identity());

    private MultiblockRegistryImpl() {
        this.registerType(Modopedia.id("dense"), DenseMultiblock.CODEC);
    }

    @Override
    public void register(ResourceLocation id, Multiblock multiblock) {
        this.multiblocks.put(id, multiblock);
    }

    @Override
    @Nullable
    public Multiblock get(ResourceLocation id) {
        return this.multiblocks.get(id);
    }

    @Override
    public void registerType(ResourceLocation id, MapCodec<? extends Multiblock> codec) {
        if (this.codecs.containsKey((Object)id)) {
            Modopedia.LOG.error("Attempted to register duplicate Multiblock type: {}", (Object)id);
        } else {
            this.codecs.put((Object)id, codec);
        }
    }

    @Override
    @Nullable
    public MapCodec<? extends Multiblock> getType(ResourceLocation id) {
        return (MapCodec)this.codecs.get((Object)id);
    }

    @Override
    public Codec<Multiblock> codec() {
        return this.codec;
    }
}

