/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.page_components;

import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.Lookup;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.page_components.BookRenderContext;
import net.favouriteless.modopedia.api.book.page_components.PageComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class HeaderPageComponent
extends PageComponent {
    public static final ResourceLocation ID = Modopedia.id("header");
    protected Component header;
    protected boolean centered;
    protected int colour;

    @Override
    public void init(Book book, Lookup lookup, Level level) {
        super.init(book, lookup, level);
        Style style = Style.EMPTY.withBold(Boolean.valueOf(lookup.getOrDefault("bold", false).asBoolean())).withUnderlined(Boolean.valueOf(lookup.getOrDefault("underline", false).asBoolean()));
        this.header = Component.translatable((String)lookup.get("text").asString()).withStyle(style);
        this.centered = lookup.getOrDefault("centered", true).asBoolean();
        this.colour = Integer.parseInt(lookup.getOrDefault("colour", book.getHeaderColour()).asString(), 16);
    }

    @Override
    public void render(GuiGraphics graphics, BookRenderContext context, int mouseX, int mouseY, float partialTicks) {
        Font font = Minecraft.getInstance().font;
        graphics.drawString(font, this.header, this.centered ? context.getBook().getLineWidth() / 2 - font.width((FormattedText)this.header) / 2 : this.x, this.y, this.colour, false);
    }
}

