/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.page_components;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.favouriteless.modopedia.api.Lookup;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.TemplateProcessor;
import net.favouriteless.modopedia.api.book.page_components.BookRenderContext;
import net.favouriteless.modopedia.api.book.page_components.PageComponent;
import net.favouriteless.modopedia.api.book.page_components.PageWidgetHolder;
import net.favouriteless.modopedia.api.registries.client.TemplateRegistry;
import net.favouriteless.modopedia.book.PageComponentHolder;
import net.favouriteless.modopedia.book.variables.RemoteVariable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class TemplatePageComponent
extends PageComponent {
    private static final List<String> passthroughExempt = List.of("template", "processor", "x", "y");
    private final PageComponentHolder holder;

    public TemplatePageComponent(PageComponentHolder holder) {
        this.holder = holder;
    }

    @Override
    public void init(Book book, Lookup lookup, Level level) {
        super.init(book, lookup, level);
        for (String key : lookup.keys()) {
            if (passthroughExempt.contains(key)) continue;
            this.holder.set(key, RemoteVariable.of(key, lookup));
        }
        if (this.holder.has("processor")) {
            ResourceLocation processorId = this.holder.get("processor").as(ResourceLocation.class);
            TemplateProcessor processor = TemplateRegistry.get().getProcessor(processorId);
            if (processor == null) {
                throw new IllegalArgumentException(String.valueOf(processorId) + " is not a valid template processor");
            }
            processor.init(book, this.holder, level);
        }
        this.holder.initComponents(book, lookup.get("entry").asString(), level);
    }

    @Override
    public void render(GuiGraphics graphics, BookRenderContext context, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)this.x, (float)this.y, 0.0f);
        for (PageComponent component : this.holder.getComponents()) {
            component.render(graphics, context, mouseX - this.x, mouseY - this.y, partialTick);
        }
        poseStack.popPose();
    }

    @Override
    public void initWidgets(PageWidgetHolder holder, BookRenderContext context) {
        for (PageComponent component : this.holder.getComponents()) {
            component.initWidgets(holder, context);
        }
    }

    @Override
    public void tick(BookRenderContext context) {
        for (PageComponent component : this.holder.getComponents()) {
            component.tick(context);
        }
    }

    @Override
    public boolean mouseClicked(BookRenderContext context, double mouseX, double mouseY, int button) {
        for (PageComponent component : this.holder.getComponents()) {
            if (!component.mouseClicked(context, mouseX - (double)this.x, mouseY - (double)this.y, button)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(BookRenderContext context, double mouseX, double mouseY, int button) {
        for (PageComponent component : this.holder.getComponents()) {
            if (!component.mouseReleased(context, mouseX - (double)this.x, mouseY - (double)this.y, button)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(BookRenderContext context, double mouseX, double mouseY, int button, double dragX, double dragY) {
        for (PageComponent component : this.holder.getComponents()) {
            if (!component.mouseDragged(context, mouseX - (double)this.x, mouseY - (double)this.y, button, dragX, dragY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(BookRenderContext context, double mouseX, double mouseY, double scrollX, double scrollY) {
        for (PageComponent component : this.holder.getComponents()) {
            if (!component.mouseScrolled(context, mouseX - (double)this.x, mouseY - (double)this.y, scrollX, scrollY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(BookRenderContext context, int keyCode, int scanCode, int modifiers) {
        for (PageComponent component : this.holder.getComponents()) {
            if (!component.keyPressed(context, keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean keyReleased(BookRenderContext context, int keyCode, int scanCode, int modifiers) {
        for (PageComponent component : this.holder.getComponents()) {
            if (!component.keyReleased(context, keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean charTyped(BookRenderContext context, char codePoint, int modifiers) {
        for (PageComponent component : this.holder.getComponents()) {
            if (!component.charTyped(context, codePoint, modifiers)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        for (PageComponent component : this.holder.getComponents()) {
            if (!component.isMouseOver(mouseX - (double)this.x, mouseY - (double)this.y)) continue;
            return true;
        }
        return false;
    }
}

