/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.screens.books;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.BookContent;
import net.favouriteless.modopedia.api.book.BookTexture;
import net.favouriteless.modopedia.api.book.BookType;
import net.favouriteless.modopedia.api.book.Category;
import net.favouriteless.modopedia.api.book.Entry;
import net.favouriteless.modopedia.client.screens.books.BookScreen;
import net.favouriteless.modopedia.client.screens.books.CategoryScreen;
import net.favouriteless.modopedia.client.screens.books.EntryScreen;
import net.favouriteless.modopedia.client.screens.books.MultiPageBookScreen;
import net.favouriteless.modopedia.client.screens.books.book_screen_pages.BlankScreenPage;
import net.favouriteless.modopedia.client.screens.books.book_screen_pages.ScreenPage;
import net.favouriteless.modopedia.client.screens.books.book_screen_pages.TitledScreenPage;
import net.favouriteless.modopedia.client.screens.widgets.BookItemTextButton;
import net.favouriteless.modopedia.common.book_types.LockedViewProvider;
import net.favouriteless.modopedia.common.book_types.LockedViewType;
import net.favouriteless.modopedia.util.client.AdvancementHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public abstract class ButtonListScreen<T extends BookType & LockedViewProvider>
extends MultiPageBookScreen<T> {
    private final Component listTitle;
    private final Supplier<List<Factory>> factories;

    public ButtonListScreen(Book book, T type, String language, BookContent.LocalisedBookContent content, Component title, BookScreen<?> lastScreen, Component listTitle, Supplier<List<Factory>> factories) {
        super(book, type, language, content, lastScreen, title);
        this.listTitle = listTitle;
        this.factories = factories;
    }

    protected abstract ScreenPage initFirstPage();

    @Override
    protected void initPages(Consumer<ScreenPage> pageConsumer) {
        pageConsumer.accept(this.initFirstPage());
        if (this.content == null) {
            return;
        }
        List<Factory> factories = this.factories.get();
        if (factories.isEmpty()) {
            return;
        }
        int spacing = BookItemTextButton.SIZE + 1;
        BookTexture.Rectangle rectangle = this.texture.pages().get(this.getPageCount() % this.texture.pages().size());
        ScreenPage page = new TitledScreenPage(this, this.listTitle, rectangle);
        int n = rectangle.v();
        Objects.requireNonNull(this.minecraft.font);
        int y = n + 9 + 3;
        BookTexture.Rectangle sep = this.texture.widgets().get("separator");
        if (sep != null) {
            y += sep.height();
        }
        for (Factory factory : factories) {
            BookItemTextButton button;
            int onPage = (rectangle.height() - (y - rectangle.v())) / spacing;
            int count = page.getWidgets().size();
            if (count >= onPage) {
                pageConsumer.accept(page);
                page = new BlankScreenPage(this);
                rectangle = this.texture.pages().get(this.getPageCount() % this.texture.pages().size());
                y = rectangle.v();
                count = 0;
            }
            if ((button = factory.create(this, this.leftPos + rectangle.u(), this.topPos + y + spacing * count, rectangle.width())) != null) {
                page.addWidget((AbstractWidget)button);
                continue;
            }
            Modopedia.LOG.warn("Tried to add a null button to a page. This is most likely due to a missing/incorrect category or entry.");
        }
        pageConsumer.accept(page);
    }

    protected static BookItemTextButton createCategoryButton(ButtonListScreen<?> screen, String id, int x, int y, int width) {
        boolean hasAdvancement;
        Category cat = screen.content.getCategory(id);
        if (cat == null) {
            return null;
        }
        boolean bl = hasAdvancement = cat.getAdvancement() == null || AdvancementHelper.hasAdvancement(cat.getAdvancement());
        if (!hasAdvancement && ((LockedViewProvider)((Object)screen.type)).lockedViewType() == LockedViewType.HIDDEN) {
            return null;
        }
        return new BookItemTextButton(x, y, width, cat.getIcon(), (Component)Component.literal((String)cat.getTitle()).withStyle(screen.getStyle()), screen.book.getFlipSound(), !hasAdvancement, b -> Minecraft.getInstance().setScreen(new CategoryScreen<BookType>(screen.book, screen.type, screen.language, screen.content, cat, screen)));
    }

    protected static BookItemTextButton createEntryButton(ButtonListScreen<?> screen, String id, int x, int y, int width) {
        boolean hasAdvancement;
        Entry entry = screen.content.getEntry(id);
        if (entry == null) {
            return null;
        }
        boolean bl = hasAdvancement = entry.getAdvancement() == null || AdvancementHelper.hasAdvancement(entry.getAdvancement());
        if (!hasAdvancement && ((LockedViewProvider)((Object)screen.type)).lockedViewType() == LockedViewType.HIDDEN) {
            return null;
        }
        return new BookItemTextButton(x, y, width, entry.getIcon(), (Component)Component.literal((String)entry.getTitle()).withStyle(screen.getStyle()), screen.book.getFlipSound(), !hasAdvancement, b -> Minecraft.getInstance().setScreen(new EntryScreen<BookType>(screen.book, screen.type, screen.language, screen.content, entry, screen)));
    }

    @FunctionalInterface
    public static interface Factory {
        @Nullable
        public BookItemTextButton create(ButtonListScreen<?> var1, int var2, int var3, int var4);
    }
}

