/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.screens.books.book_screen_pages;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.favouriteless.modopedia.api.book.BookTexture;
import net.favouriteless.modopedia.book.text.TextChunk;
import net.favouriteless.modopedia.client.screens.books.BookScreen;
import net.favouriteless.modopedia.client.screens.books.book_screen_pages.FormattedTextPage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextColor;

public class TitledTextPage
extends FormattedTextPage {
    protected final Component title;
    protected final BookTexture.Rectangle page;

    public TitledTextPage(BookScreen<?> parent, Component title, List<TextChunk> text, int textY, BookTexture.Rectangle page) {
        super(parent, text, 0, textY);
        this.title = title;
        this.page = page;
    }

    @Override
    public void render(GuiGraphics graphics, PoseStack poseStack, BookTexture.Rectangle dimensions, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, poseStack, dimensions, mouseX, mouseY, partialTick);
        Font font = Minecraft.getInstance().font;
        TextColor color = this.title.getStyle().getColor();
        int x = this.page.width() / 2 - font.width((FormattedText)this.title) / 2;
        graphics.drawString(font, this.title, x, 0, color != null ? color.getValue() : 0, false);
        BookTexture texture = this.parent.getBookTexture();
        BookTexture.Rectangle separator = texture.widgets().get("separator");
        if (separator == null) {
            return;
        }
        x = this.page.width() / 2 - separator.width() / 2;
        graphics.blit(texture.location(), x, 10, (float)separator.u(), (float)separator.v(), separator.width(), separator.height(), texture.texWidth(), texture.texHeight());
    }
}

