/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.screens.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;

public class BookItemTextButton
extends Button {
    public static final int SIZE;
    private final Holder<SoundEvent> sound;
    private final ItemStack stack;
    private final boolean isLocked;

    public BookItemTextButton(int x, int y, int width, ItemStack stack, Component message, Holder<SoundEvent> sound, boolean isLocked, Button.OnPress onPress) {
        super(x, y, width, SIZE, message, onPress, DEFAULT_NARRATION);
        this.stack = stack;
        this.sound = sound;
        this.isLocked = isLocked;
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = graphics.pose();
        float scale = (float)this.height * 0.9f / 16.0f;
        int x = this.getX();
        int y = this.getY();
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.isLocked ? 0.2f : 1.0f));
        if (!this.isLocked && this.isHovered()) {
            graphics.fill(x, y, x + this.width, y + this.height, 0x33000000);
        }
        poseStack.pushPose();
        poseStack.scale(scale, scale, 1.0f);
        poseStack.translate((float)x / scale, (float)y / scale + (float)this.height * 0.05f, 0.0f);
        graphics.renderItem(this.stack, 0, 0);
        poseStack.popPose();
        graphics.drawString(Minecraft.getInstance().font, this.getMessage(), x + this.height, y + 1, 0, false);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    public void onClick(double mouseX, double mouseY) {
        if (!this.isLocked) {
            super.onClick(mouseX, mouseY);
        }
    }

    public void playDownSound(SoundManager handler) {
        if (!this.isLocked) {
            handler.play((SoundInstance)SimpleSoundInstance.forUI(this.sound, (float)1.0f));
        }
    }

    static {
        Objects.requireNonNull(Minecraft.getInstance().font);
        SIZE = 9 + 2;
    }
}

