/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.template_processors;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.Lookup;
import net.favouriteless.modopedia.api.Variable;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.BookTexture;
import net.favouriteless.modopedia.api.book.TemplateProcessor;
import net.favouriteless.modopedia.api.registries.client.BookTextureRegistry;
import net.favouriteless.modopedia.client.page_components.item_displays.CyclingItemDisplay;
import net.favouriteless.modopedia.client.page_components.item_displays.SimpleItemDisplay;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.Level;

public class CookingRecipeProcessor
implements TemplateProcessor {
    public static final ResourceLocation ID = Modopedia.id("cooking_recipe");
    public static final Map<Class<? extends AbstractCookingRecipe>, String> TYPE_KEYS = new HashMap<Class<? extends AbstractCookingRecipe>, String>();

    @Override
    public void init(Book book, Lookup.MutableLookup lookup, Level level) {
        this.initComponents(book, lookup);
        this.initRecipe(lookup, level);
    }

    protected void initRecipe(Lookup.MutableLookup lookup, Level level) {
        ResourceLocation id = lookup.get("recipe").as(ResourceLocation.class);
        Optional optional = level.getRecipeManager().byKey(id);
        if (optional.isEmpty()) {
            throw new IllegalArgumentException(String.valueOf(id) + " is not a valid recipe.");
        }
        Recipe recipe = ((RecipeHolder)optional.get()).value();
        if (!TYPE_KEYS.containsKey(recipe.getClass())) {
            throw new IllegalStateException("CookingRecipe template must use a valid cooking recipe");
        }
        lookup.set("p_tooltip", Variable.of(List.of(TYPE_KEYS.get(recipe.getClass()))));
        lookup.set("p_inputs", Variable.of(new CyclingItemDisplay(Arrays.asList(((Ingredient)recipe.getIngredients().getFirst()).getItems()))));
        lookup.set("p_output", Variable.of(new SimpleItemDisplay(recipe.getResultItem((HolderLookup.Provider)level.registryAccess()))));
    }

    protected void initComponents(Book book, Lookup.MutableLookup lookup) {
        BookTexture tex = BookTextureRegistry.get().getTexture(book.getTexture());
        if (tex == null) {
            throw new IllegalStateException("CookingRecipe templates require the book to have a valid BookTexture");
        }
        BookTexture.Rectangle page = tex.pages().get(lookup.get("page_num").asInt() % tex.pages().size());
        BookTexture.Rectangle frame = tex.widgets().get("small_frame");
        BookTexture.Rectangle arrow = tex.widgets().get("crafting_arrow");
        BookTexture.Rectangle flame = tex.widgets().get("crafting_flame");
        if (flame == null || arrow == null || frame == null) {
            throw new IllegalStateException("Cooking recipe templates require the BookTexture to have crafting_flame, crafting_arrow and small_frame widgets");
        }
        int spacing = (frame.width() - 16) / 2;
        int arrowX = 16 + spacing + 4;
        int arrowY = 8 - arrow.height() / 2;
        int flameX = arrowX + arrow.width() / 2 - flame.width() / 2;
        int flameY = arrowY + arrow.height() + 2;
        int outputX = arrowX + arrow.width() + 4 + spacing;
        int offset = (page.width() - (outputX + 16)) / 2;
        lookup.set("p_input_x", Variable.of(offset));
        lookup.set("p_arrow_x", Variable.of(arrowX + offset));
        lookup.set("p_arrow_y", Variable.of(arrowY));
        lookup.set("p_arrow_width", Variable.of(arrow.width()));
        lookup.set("p_arrow_height", Variable.of(arrow.height()));
        lookup.set("p_flame_x", Variable.of(flameX + offset));
        lookup.set("p_flame_y", Variable.of(flameY));
        lookup.set("p_output_x", Variable.of(outputX + offset));
    }

    static {
        TYPE_KEYS.put(BlastingRecipe.class, Modopedia.translation("template", "blasting_recipe"));
        TYPE_KEYS.put(SmeltingRecipe.class, Modopedia.translation("template", "smelting_recipe"));
        TYPE_KEYS.put(SmokingRecipe.class, Modopedia.translation("template", "smoking_recipe"));
    }
}

