/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.neoforge.datagen;

import java.util.concurrent.CompletableFuture;
import net.favouriteless.modopedia.api.datagen.example.MExampleBookProvider;
import net.favouriteless.modopedia.api.datagen.example.MExampleBookTextureProvider;
import net.favouriteless.modopedia.api.datagen.example.MExampleContentSetProvider;
import net.favouriteless.modopedia.api.datagen.example.MExampleTemplateProvider;
import net.favouriteless.modopedia.neoforge.datagen.providers.MBookTextureProvider;
import net.favouriteless.modopedia.neoforge.datagen.providers.MItemModelProvider;
import net.favouriteless.modopedia.neoforge.datagen.providers.MLanguageProvider;
import net.favouriteless.modopedia.neoforge.datagen.providers.MTemplateProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="modopedia", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        gen.addProvider(true, (DataProvider)new MItemModelProvider(output, fileHelper));
        gen.addProvider(true, (DataProvider)new MLanguageProvider(output));
        gen.addProvider(true, (DataProvider)new MBookTextureProvider(provider, output));
        gen.addProvider(true, (DataProvider)new MTemplateProvider(provider, output));
        gen.addProvider(false, (DataProvider)new MExampleBookTextureProvider(provider, output));
        gen.addProvider(false, (DataProvider)new MExampleBookProvider(provider, output));
        gen.addProvider(false, (DataProvider)new MExampleTemplateProvider(provider, output));
        gen.addProvider(false, (DataProvider)new MExampleContentSetProvider("example", "en_us", provider, output));
    }
}

