/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.turtleboi.bytebuddies.block.ModBlockEntities;
import net.turtleboi.bytebuddies.block.entity.DockingStationBlockEntity;
import net.turtleboi.bytebuddies.item.ModItems;
import net.turtleboi.bytebuddies.screen.custom.menu.DockingStationMenu;
import org.jetbrains.annotations.Nullable;

public class DockingStationBlock
extends BaseEntityBlock {
    public static final MapCodec<DockingStationBlock> CODEC = DockingStationBlock.simpleCodec(DockingStationBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;

    public DockingStationBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.FALSE));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new DockingStationBlockEntity(blockPos, blockState);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)OPEN, (Comparable)Boolean.FALSE);
    }

    protected RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    protected void onRemove(BlockState blockState, Level level, BlockPos blockPos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (blockState.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(blockPos)) instanceof DockingStationBlockEntity) {
            DockingStationBlockEntity dockingStation = (DockingStationBlockEntity)blockEntity;
            dockingStation.drops();
        }
        super.onRemove(blockState, level, blockPos, newState, movedByPiston);
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult hitResult) {
        if (itemStack.is((Item)ModItems.WRENCH.get())) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        if (!level.isClientSide()) {
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof DockingStationBlockEntity) {
                DockingStationBlockEntity dockingStation = (DockingStationBlockEntity)blockEntity;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    List<Integer> ids = dockingStation.findByteBuddyEntityIds((ServerLevel)level);
                    serverPlayer.openMenu((MenuProvider)new SimpleMenuProvider((containerId, inventory, interactingPlayer) -> new DockingStationMenu(containerId, inventory, dockingStation), (Component)Component.literal((String)"Docking Station")), buf -> {
                        buf.writeBlockPos(blockPos);
                        buf.writeVarInt(ids.size());
                        Iterator iterator = ids.iterator();
                        while (iterator.hasNext()) {
                            int id = (Integer)iterator.next();
                            buf.writeVarInt(id);
                        }
                    });
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            } else {
                throw new IllegalStateException("Our container provider is missing");
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public static Direction getHorizontalFacing(BlockState blockState) {
        if (blockState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            return (Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        }
        if (blockState.hasProperty((Property)BlockStateProperties.FACING)) {
            Direction direction = (Direction)blockState.getValue((Property)BlockStateProperties.FACING);
            return direction.getAxis().isHorizontal() ? direction : Direction.NORTH;
        }
        return Direction.NORTH;
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, OPEN});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide()) {
            return null;
        }
        return DockingStationBlock.createTickerHelper(blockEntityType, ModBlockEntities.DOCKING_STATION_BE.get(), (blockLevel, blockPos, blockState, blockEntity) -> blockEntity.tick(blockLevel, blockPos, blockState));
    }
}

