/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.block.entity;

import java.lang.reflect.Field;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.turtleboi.bytebuddies.block.ModBlockEntities;
import net.turtleboi.bytebuddies.init.ModTags;
import net.turtleboi.bytebuddies.item.custom.BatteryItem;
import net.turtleboi.bytebuddies.util.InventoryUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SolarPanelBlockEntity
extends BlockEntity
implements IEnergyStorage,
MenuProvider {
    private final EnergyStorage energyStorage = new EnergyStorage(48000, 640, 640);
    private final ItemStackHandler batterySlot = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack itemStack) {
            if (itemStack.isEmpty()) {
                return false;
            }
            return InventoryUtil.isBattery(itemStack);
        }

        protected int getStackLimit(int slot, @NotNull ItemStack itemStack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            SolarPanelBlockEntity.this.setChanged();
            if (!SolarPanelBlockEntity.this.level.isClientSide()) {
                SolarPanelBlockEntity.this.level.sendBlockUpdated(SolarPanelBlockEntity.this.getBlockPos(), SolarPanelBlockEntity.this.getBlockState(), SolarPanelBlockEntity.this.getBlockState(), 3);
            }
        }
    };
    private int tickCount = 0;
    private boolean generating = false;

    public SolarPanelBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.SOLAR_PANEL_BE.get(), pos, blockState);
    }

    public Component getDisplayName() {
        return null;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return null;
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState) {
        if (level != null) {
            if (level.dimensionType().hasSkyLight()) {
                BlockPos abovePos = blockPos.above();
                int skyBrightness = level.getBrightness(LightLayer.SKY, abovePos);
                if (skyBrightness > 0 && level.isDay()) {
                    int energyGenerated = 8;
                    if (level.isRainingAt(abovePos)) {
                        energyGenerated /= 2;
                    }
                    this.generateEnergy(energyGenerated);
                    this.setGenerating(true);
                } else {
                    this.setGenerating(false);
                }
            }
            ++this.tickCount;
            if (this.tickCount % 20 == 0) {
                this.pushEnergyToNeighbors();
                this.giveBatteryEnergy();
            }
        }
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.batterySlot.getSlots());
        for (int i = 0; i < this.batterySlot.getSlots(); ++i) {
            inventory.setItem(i, this.batterySlot.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public ItemStackHandler getBatterySlot() {
        return this.batterySlot;
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    private void setEnergyUnsafe(int value) {
        try {
            Field storedEnergy = EnergyStorage.class.getDeclaredField("energy");
            storedEnergy.setAccessible(true);
            storedEnergy.setInt(this.energyStorage, Mth.clamp((int)value, (int)0, (int)this.energyStorage.getMaxEnergyStored()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void saveAdditional(CompoundTag nbtData, HolderLookup.Provider registries) {
        super.saveAdditional(nbtData, registries);
        nbtData.put("BatterySlot", (Tag)this.batterySlot.serializeNBT(registries));
        nbtData.putInt("Energy", this.energyStorage.getEnergyStored());
    }

    protected void loadAdditional(CompoundTag nbtData, HolderLookup.Provider registries) {
        super.loadAdditional(nbtData, registries);
        if (nbtData.contains("BatterySlot")) {
            this.batterySlot.deserializeNBT(registries, nbtData.getCompound("BatterySlot"));
        }
        this.setChanged();
        if (nbtData.contains("Energy")) {
            this.setEnergyUnsafe(nbtData.getInt("Energy"));
        }
    }

    public int receiveEnergy(int toReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(toReceive, simulate);
    }

    public int extractEnergy(int toExtract, boolean simulate) {
        return this.energyStorage.extractEnergy(toExtract, simulate);
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.energyStorage.canExtract();
    }

    public boolean canReceive() {
        return this.energyStorage.canReceive();
    }

    public boolean isGenerating() {
        return this.generating;
    }

    public void setGenerating(boolean generating) {
        this.generating = generating;
    }

    public int isGeneratingBinary() {
        if (this.generating) {
            return 1;
        }
        return 0;
    }

    public int generateEnergy(int energyGenerated) {
        int maxEnergy;
        int energyStored = this.energyStorage.getEnergyStored();
        if (energyStored < (maxEnergy = this.energyStorage.getMaxEnergyStored())) {
            int potentialEnergy = maxEnergy - energyStored;
            int energyActuallyGenerated = Math.min(potentialEnergy, Math.max(0, energyGenerated));
            int receivedEnergy = this.energyStorage.receiveEnergy(energyActuallyGenerated, false);
            if (receivedEnergy > 0) {
                this.setChanged();
            }
            return receivedEnergy;
        }
        return 0;
    }

    public int giveBatteryEnergy() {
        Item item;
        int energyMoved = 0;
        if (this.level == null || this.level.isClientSide) {
            return 0;
        }
        IEnergyStorage energySource = this.getEnergyStorage();
        ItemStack batteryInSlot = this.getBatterySlot().getStackInSlot(0);
        if (energySource != null && energySource.getEnergyStored() > 0 && !batteryInSlot.isEmpty() && (item = batteryInSlot.getItem()) instanceof BatteryItem) {
            int energyDrained;
            int acceptedEnergy;
            int canExtract;
            BatteryItem batteryItem = (BatteryItem)item;
            int missingEnergy = batteryItem.getCapacity() - batteryItem.getEnergy(batteryInSlot);
            int requestedEnergy = Math.min(missingEnergy, batteryItem.getIoRate());
            if (missingEnergy > 0 && requestedEnergy > 0 && (canExtract = energySource.extractEnergy(requestedEnergy, true)) > 0 && (acceptedEnergy = batteryItem.receive(batteryInSlot, canExtract, false)) > 0 && (energyDrained = energySource.extractEnergy(acceptedEnergy, false)) > 0) {
                energyMoved = energyDrained;
                this.setChanged();
            }
        }
        return energyMoved;
    }

    private void pushEnergyToNeighbors() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        if (this.energyStorage.getEnergyStored() <= 0) {
            return;
        }
        for (Direction direction : Direction.values()) {
            int accepted;
            int canExtract;
            IEnergyStorage neighbor;
            BlockPos neighborPos = this.worldPosition.relative(direction);
            if (this.level.getBlockState(neighborPos).is(ModTags.Blocks.GENERATORS) || (neighbor = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, neighborPos, (Object)direction.getOpposite())) == null || !neighbor.canReceive() || (canExtract = this.energyStorage.extractEnergy(640, true)) <= 0 || (accepted = neighbor.receiveEnergy(canExtract, false)) <= 0) continue;
            this.energyStorage.extractEnergy(accepted, false);
            this.setChanged();
            if (this.energyStorage.getEnergyStored() <= 0) break;
        }
    }
}

