/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.client.renderer.util;

import com.mojang.blaze3d.vertex.VertexConsumer;
import org.jetbrains.annotations.NotNull;

public final class TintingVertexConsumer
implements VertexConsumer {
    private final VertexConsumer delegate;
    private final float mulR;
    private final float mulG;
    private final float mulB;
    private final float mulA;

    TintingVertexConsumer(VertexConsumer delegate, float mulR, float mulG, float mulB, float mulA) {
        this.delegate = delegate;
        this.mulR = mulR;
        this.mulG = mulG;
        this.mulB = mulB;
        this.mulA = mulA;
    }

    private static int mul255(int colorValue, float multiplier) {
        int outputColor = Math.round((float)colorValue * multiplier);
        if (outputColor < 0) {
            outputColor = 0;
        }
        if (outputColor > 255) {
            outputColor = 255;
        }
        return outputColor;
    }

    @NotNull
    public VertexConsumer addVertex(float x, float y, float z) {
        return this.delegate.addVertex(x, y, z);
    }

    @NotNull
    public VertexConsumer setColor(int r, int g, int b, int a) {
        return this.delegate.setColor(TintingVertexConsumer.mul255(r, this.mulR), TintingVertexConsumer.mul255(g, this.mulG), TintingVertexConsumer.mul255(b, this.mulB), TintingVertexConsumer.mul255(a, this.mulA));
    }

    @NotNull
    public VertexConsumer setUv(float u, float v) {
        return this.delegate.setUv(u, v);
    }

    @NotNull
    public VertexConsumer setOverlay(int overlay) {
        return this.delegate.setOverlay(overlay);
    }

    @NotNull
    public VertexConsumer setUv1(int u, int v) {
        return this.delegate.setUv1(u, v);
    }

    @NotNull
    public VertexConsumer setUv2(int u, int v) {
        return this.delegate.setUv2(u, v);
    }

    @NotNull
    public VertexConsumer setLight(int light) {
        return this.delegate.setLight(light);
    }

    @NotNull
    public VertexConsumer setNormal(float nx, float ny, float nz) {
        return this.delegate.setNormal(nx, ny, nz);
    }
}

