/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.datagen;

import java.util.Optional;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.loaders.SeparateTransformsModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredItem;
import net.turtleboi.bytebuddies.item.ModItems;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "bytebuddies", existingFileHelper);
    }

    private static ResourceLocation minecraftLocation(String path) {
        return ResourceLocation.withDefaultNamespace((String)path);
    }

    private static ResourceLocation modLocation(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)path);
    }

    protected void registerModels() {
        this.basicItem((Item)ModItems.RAW_BAUXITE.get());
        this.basicItem((Item)ModItems.ALUMINUM_INGOT.get());
        this.basicItem((Item)ModItems.ALUMINUM_NUGGET.get());
        this.basicItem((Item)ModItems.CARBON_ALLOY.get());
        this.basicItem((Item)ModItems.STEEL_INGOT.get());
        this.basicItem((Item)ModItems.STEEL_NUGGET.get());
        this.basicItem((Item)ModItems.CHARGED_STEEL_INGOT.get());
        this.basicItem((Item)ModItems.CHARGED_STEEL_NUGGET.get());
        this.basicItem((Item)ModItems.BLUESTONE_DUST.get());
        this.basicItem((Item)ModItems.COPPER_PLATING.get());
        this.basicItem((Item)ModItems.IRON_PLATING.get());
        this.basicItem((Item)ModItems.GOLD_PLATING.get());
        this.basicItem((Item)ModItems.ALUMINUM_PLATING.get());
        this.basicItem((Item)ModItems.STEEL_PLATING.get());
        this.basicItem((Item)ModItems.CHARGED_STEEL_PLATING.get());
        this.basicItem((Item)ModItems.SIMPLE_BATTERY.get());
        this.basicItem((Item)ModItems.ADVANCED_BATTERY.get());
        this.basicItem((Item)ModItems.BIOCELL_BATTERY.get());
        this.basicItem((Item)ModItems.REINFORCED_BATTERY.get());
        this.basicItem((Item)ModItems.SUPER_CHARGED_BATTERY.get());
        this.basicItem((Item)ModItems.CARBON_PASTE.get());
        this.basicItem((Item)ModItems.CHIP.get());
        this.basicItem((Item)ModItems.SUPER_CHIP.get());
        this.handheldItem((Item)ModItems.WRENCH.get());
        this.basicItem((Item)ModItems.CLIPBOARD.get());
        this.basicItem((Item)ModItems.PROPELLER_UNIT.get());
        this.basicItem((Item)ModItems.AQUATIC_MOTOR.get());
        this.basicItem((Item)ModItems.SOLAR_ARRAY.get());
        this.basicItem((Item)ModItems.GYROSCOPIC_STABILIZER.get());
        this.basicItem((Item)ModItems.ARC_WELDER.get());
        this.basicItem((Item)ModItems.GEOTHERMAL_REGULATOR.get());
        this.basicItem((Item)ModItems.DYNAMO_COIL.get());
        this.basicItem((Item)ModItems.MAGNETIC_CRESCENT.get());
        this.basicItem((Item)ModItems.BASIC_STORAGE_CELL.get());
        this.basicItem((Item)ModItems.ADVANCED_STORAGE_CELL.get());
        this.basicItem((Item)ModItems.ENDERLINK_STORAGE_CELL.get());
        this.basicItem((Item)ModItems.REINFORCED_IRON_PLATING.get());
        this.basicItem((Item)ModItems.REINFORCED_STEEL_PLATING.get());
        this.basicItem((Item)ModItems.REINFORCED_NETHERITE_PLATING.get());
        this.basicItem((Item)ModItems.REINFORCED_CHARGED_STEEL_PLATING.get());
        ModItems.FLOPPY_DISKS.values().forEach(this::layeredFloppyModel);
        this.generateTerrabladeModels();
    }

    private ItemModelBuilder layeredFloppyModel(DeferredItem<Item> itemObject) {
        String path = itemObject.getId().getPath();
        Optional<FloppyParts> optionalParts = ModItemModelProvider.parse(path);
        if (optionalParts.isEmpty()) {
            System.out.println("[Datagen] Skip " + path + " \u2014 cannot parse floppy key.");
            return null;
        }
        FloppyParts parts = optionalParts.get();
        ResourceLocation floppyBaseTex = ModItemModelProvider.materialTexture("bytebuddies", parts.color);
        ResourceLocation floppyTierTex = ModItemModelProvider.overlayTexture("bytebuddies", parts.tier);
        ItemModelBuilder itemModelBuilder = (ItemModelBuilder)this.withExistingParent(path, this.mcLoc("item/generated"));
        int layer = 0;
        itemModelBuilder = (ItemModelBuilder)itemModelBuilder.texture("layer" + layer++, floppyBaseTex);
        itemModelBuilder = (ItemModelBuilder)itemModelBuilder.texture("layer" + layer, floppyTierTex);
        return itemModelBuilder;
    }

    public static Optional<FloppyParts> parse(String registryPath) {
        if (!registryPath.endsWith("_floppy")) {
            return Optional.empty();
        }
        String stem = registryPath.substring(0, registryPath.length() - "_floppy".length());
        int ix = stem.lastIndexOf(95);
        if (ix < 0) {
            return Optional.empty();
        }
        String tier = stem.substring(0, ix);
        String color = stem.substring(ix + 1);
        return Optional.of(new FloppyParts(tier, color));
    }

    public static ResourceLocation materialTexture(String modId, String color) {
        return ResourceLocation.fromNamespaceAndPath((String)modId, (String)("item/floppy/" + color + "_floppy_base"));
    }

    public static ResourceLocation overlayTexture(String modId, String tier) {
        return ResourceLocation.fromNamespaceAndPath((String)modId, (String)("item/floppy/" + tier + "_floppy_tier"));
    }

    private void generateTerrabladeModels() {
        int i;
        ItemModelBuilder gui = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("terrablade_item")).parent((ModelFile)new ModelFile.UncheckedModelFile(ModItemModelProvider.minecraftLocation("item/generated")))).guiLight(BlockModel.GuiLight.FRONT)).texture("layer0", "bytebuddies:item/terrablade_item");
        ItemModelBuilder heldBase = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("terrablade_held")).parent((ModelFile)new ModelFile.UncheckedModelFile(ModItemModelProvider.minecraftLocation("item/handheld")))).texture("layer0", "bytebuddies:item/terrablade_sword");
        heldBase.transforms().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 25.0f).translation(3.5f, 7.0f, 1.13f).scale(1.5f, 1.5f, 1.0f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, -25.0f).translation(3.5f, 7.0f, 1.13f).scale(1.5f, 1.5f, 1.0f).end().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 45.0f).translation(0.0f, 14.0f, 1.5f).scale(2.0f, 2.0f, 1.0f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, -45.0f).translation(0.0f, 14.0f, 1.5f).scale(2.0f, 2.0f, 1.0f).end();
        for (i = 1; i <= 14; ++i) {
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("terrablade_held_charge_" + i)).parent((ModelFile)new ModelFile.UncheckedModelFile(ModItemModelProvider.modLocation("item/terrablade_held")))).texture("layer0", "bytebuddies:item/terrablade_sword")).texture("layer1", "bytebuddies:item/terrablade/terracharge_" + i);
        }
        for (i = 1; i <= 14; ++i) {
            ItemModelBuilder step = (ItemModelBuilder)((ItemModelBuilder)this.getBuilder("terrablade_step_" + i)).guiLight(BlockModel.GuiLight.FRONT);
            ((SeparateTransformsModelBuilder)step.customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)this.getParentModel(ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)("item/_inline/step_" + i + "/base")), ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)("item/terrablade_held_charge_" + i)))).perspective(ItemDisplayContext.GUI, (ModelBuilder)this.getItemModel(ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)("item/_inline/step_" + i + "/gui")), ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"item/terrablade_item"))).perspective(ItemDisplayContext.GROUND, (ModelBuilder)this.getItemModel(ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)("item/_inline/step_" + i + "/ground")), ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"item/terrablade_item"))).perspective(ItemDisplayContext.FIXED, (ModelBuilder)this.getItemModel(ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)("item/_inline/step_" + i + "/fixed")), ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"item/terrablade_item"))).end();
        }
        ItemModelBuilder top = (ItemModelBuilder)((ItemModelBuilder)this.getBuilder("terrablade")).guiLight(BlockModel.GuiLight.FRONT);
        ((SeparateTransformsModelBuilder)top.customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)this.getParentModel(ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"item/_inline/top/base"), ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"item/terrablade_held"))).perspective(ItemDisplayContext.GUI, (ModelBuilder)this.getItemModel(ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"item/_inline/top/gui"), ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"item/terrablade_item"))).perspective(ItemDisplayContext.GROUND, (ModelBuilder)this.getItemModel(ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"item/_inline/top/ground"), ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"item/terrablade_item"))).perspective(ItemDisplayContext.FIXED, (ModelBuilder)this.getItemModel(ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"item/_inline/top/fixed"), ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"item/terrablade_item"))).end();
        for (int i2 = 1; i2 <= 14; ++i2) {
            float threshold = (float)i2 / 14.0f;
            top.override().predicate(ModItemModelProvider.modLocation("charge"), ModItemModelProvider.clampPredicate(threshold)).model((ModelFile)new ModelFile.UncheckedModelFile(ModItemModelProvider.modLocation("item/terrablade_step_" + i2)));
        }
    }

    private ItemModelBuilder getItemModel(ResourceLocation itemModel, ResourceLocation itemTexture) {
        ItemModelBuilder itemModelBuilder = new ItemModelBuilder(itemModel, this.existingFileHelper);
        itemModelBuilder.parent((ModelFile)new ModelFile.UncheckedModelFile(ResourceLocation.withDefaultNamespace((String)"item/generated")));
        itemModelBuilder.texture("layer0", itemTexture);
        return itemModelBuilder;
    }

    private ItemModelBuilder getParentModel(ResourceLocation inlineModel, ResourceLocation parentModel) {
        ItemModelBuilder itemModelBuilder = new ItemModelBuilder(inlineModel, this.existingFileHelper);
        itemModelBuilder.parent((ModelFile)new ModelFile.UncheckedModelFile(parentModel));
        return itemModelBuilder;
    }

    private static float clampPredicate(float value) {
        float x = value >= 1.0f ? 0.999f : value;
        return (float)Math.round(x * 1000.0f) / 1000.0f;
    }

    public record FloppyParts(String tier, String color) {
    }
}

