/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.datagen;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.registries.DeferredItem;
import net.turtleboi.bytebuddies.block.ModBlocks;
import net.turtleboi.bytebuddies.effects.ModEffects;
import net.turtleboi.bytebuddies.entity.ModEntities;
import net.turtleboi.bytebuddies.item.ModItems;

public class ModLanguageProvider
extends LanguageProvider {
    public ModLanguageProvider(PackOutput output) {
        super(output, "bytebuddies", "en_us");
    }

    protected void addTranslations() {
        this.add("creativetab.bytebuddies.bytebuddies_tab", "ByteBuddies");
        this.addEntityType(ModEntities.BYTEBUDDY, "ByteBuddy");
        this.addSimpleNameEffect((MobEffect)ModEffects.SUPERCHARGED.value());
        this.addSimpleNameEffect((MobEffect)ModEffects.STUNNED.value());
        this.addSimpleNameBlock((Supplier<? extends Block>)ModBlocks.BAUXITE_ORE);
        this.addSimpleNameBlock((Supplier<? extends Block>)ModBlocks.DEEPSLATE_BAUXITE_ORE);
        this.addSimpleNameBlock((Supplier<? extends Block>)ModBlocks.ALUMINUM_BLOCK);
        this.addSimpleNameBlock((Supplier<? extends Block>)ModBlocks.STEEL_BLOCK);
        this.addSimpleNameBlock((Supplier<? extends Block>)ModBlocks.CHARGED_STEEL_BLOCK);
        this.addSimpleNameBlock((Supplier<? extends Block>)ModBlocks.BLUESTONE_ORE);
        this.addSimpleNameBlock((Supplier<? extends Block>)ModBlocks.DEEPSLATE_BLUESTONE_ORE);
        this.addSimpleNameBlock((Supplier<? extends Block>)ModBlocks.BLUESTONE_BLOCK);
        this.addSimpleNameBlock((Supplier<? extends Block>)ModBlocks.DOCKING_STATION);
        this.addSimpleNameBlock((Supplier<? extends Block>)ModBlocks.GENERATOR);
        this.addSimpleNameBlock((Supplier<? extends Block>)ModBlocks.SOLAR_PANEL);
        this.addItem((Supplier)ModItems.BUSTER_SWORD, "Steel Breaker");
        this.addItem((Supplier)ModItems.TERRABLADE, "World Splitter");
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.RAW_BAUXITE);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.ALUMINUM_INGOT);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.ALUMINUM_NUGGET);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.CARBON_ALLOY);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.STEEL_INGOT);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.STEEL_NUGGET);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.CHARGED_STEEL_INGOT);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.CHARGED_STEEL_NUGGET);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.BLUESTONE_DUST);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.COPPER_PLATING);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.IRON_PLATING);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.GOLD_PLATING);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.ALUMINUM_PLATING);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.STEEL_PLATING);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.CHARGED_STEEL_PLATING);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.CARBON_PASTE);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.SIMPLE_BATTERY);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.ADVANCED_BATTERY);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.BIOCELL_BATTERY);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.REINFORCED_BATTERY);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.SUPER_CHARGED_BATTERY);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.CHIP);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.SUPER_CHIP);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.WRENCH);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.CLIPBOARD);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.PROPELLER_UNIT);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.AQUATIC_MOTOR);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.SOLAR_ARRAY);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.GYROSCOPIC_STABILIZER);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.ARC_WELDER);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.GEOTHERMAL_REGULATOR);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.DYNAMO_COIL);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.MAGNETIC_CRESCENT);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.BASIC_STORAGE_CELL);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.ADVANCED_STORAGE_CELL);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.ENDERLINK_STORAGE_CELL);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.REINFORCED_IRON_PLATING);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.REINFORCED_STEEL_PLATING);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.REINFORCED_NETHERITE_PLATING);
        this.addSimpleItemName((Supplier<? extends Item>)ModItems.REINFORCED_CHARGED_STEEL_PLATING);
        this.add((Item)ModItems.BYTEBUDDY_SPAWN_EGG.get(), "ByteBuddy");
        ModItems.FLOPPY_DISKS.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            DeferredItem item = (DeferredItem)entry.getValue();
            String path = item.getId().getPath();
            String display = ModLanguageProvider.floppyDisplayName(path).orElseGet(() -> ModLanguageProvider.toName(path));
            this.add("item.bytebuddies." + path, display);
        });
        this.add("tooltip.bytebuddies.floppy.tier_line", "Tier: %s");
        this.add("tooltip.bytebuddies.floppy_tier.copper", "Copper");
        this.add("tooltip.bytebuddies.floppy_tier.iron", "Iron");
        this.add("tooltip.bytebuddies.floppy_tier.gold", "Gold");
        this.add("tooltip.bytebuddies.floppy.desc.black", "Reduces tool wear and increases bot's durability (Health)");
        this.add("tooltip.bytebuddies.floppy.desc.blue", "Expands sensing and action radius around the bot\u2019s station or active job.");
        this.add("tooltip.bytebuddies.floppy.desc.cyan", "On a successful action, there\u2019s a chance to spawn a short-lived hologram that performs parallel tasks");
        this.add("tooltip.bytebuddies.floppy.desc.green", "Reduces battery drain and consumable use where applicable.");
        this.add("tooltip.bytebuddies.floppy.desc.pink", "Supportive aura that buffs nearby allies and tasks.");
        this.add("tooltip.bytebuddies.floppy.desc.purple", "Improves yield from actions the bot performs.");
        this.add("tooltip.bytebuddies.floppy.desc.red", "Overclock for more power and speed at a higher energy cost.");
        this.add("tooltip.bytebuddies.floppy.desc.yellow", "When a task succeeds, roll for a byproduct tied to that task\u2019s context");
    }

    private void addSimpleItemName(Supplier<? extends Item> supplier) {
        Item item = supplier.get();
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
        this.add(item, ModLanguageProvider.toName(itemId.getPath()));
    }

    private void addSimpleNameBlock(Supplier<? extends Block> supplier) {
        Block block = supplier.get();
        ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)block);
        this.add(block, ModLanguageProvider.toName(blockId.getPath()));
    }

    private void addSimpleNameEffect(MobEffect effect) {
        ResourceLocation id = ((ResourceKey)BuiltInRegistries.MOB_EFFECT.getResourceKey((Object)effect).orElseThrow(() -> new IllegalStateException("MobEffect not registered: " + String.valueOf(effect)))).location();
        this.add(effect, ModLanguageProvider.toName(id.getPath()));
    }

    private static String toName(String registryPath) {
        StringBuilder stringBuilder = new StringBuilder(registryPath.length() + 8);
        for (String part : registryPath.split("_")) {
            if (part.isEmpty()) continue;
            stringBuilder.append(Character.toUpperCase(part.charAt(0)));
            if (part.length() > 1) {
                stringBuilder.append(part.substring(1));
            }
            stringBuilder.append(' ');
        }
        return stringBuilder.toString().trim();
    }

    private static Optional<String> floppyDisplayName(String registryPath) {
        if (!registryPath.endsWith("_floppy")) {
            return Optional.empty();
        }
        String stem = registryPath.substring(0, registryPath.length() - "_floppy".length());
        int ix = stem.indexOf(95);
        if (ix <= 0 || ix >= stem.length() - 1) {
            return Optional.empty();
        }
        String color = stem.substring(ix + 1);
        return Optional.of(ModLanguageProvider.capitalize(color) + " Floppy Disk");
    }

    private static String capitalize(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        return Character.toUpperCase(string.charAt(0)) + (string.length() > 1 ? string.substring(1) : "");
    }
}

