/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.entity.ai;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;

public final class AccessInventoryGoal
extends Goal {
    private final ByteBuddyEntity byteBuddy;

    public AccessInventoryGoal(ByteBuddyEntity byteBuddy) {
        this.byteBuddy = byteBuddy;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        return !this.byteBuddy.level().isClientSide && this.byteBuddy.isInteracting();
    }

    public boolean canContinueToUse() {
        return !this.byteBuddy.level().isClientSide && this.byteBuddy.isInteracting();
    }

    public boolean isInterruptable() {
        return false;
    }

    public void start() {
        this.byteBuddy.getNavigation().stop();
        this.byteBuddy.setAggressive(false);
        this.byteBuddy.setWorking(false);
        this.byteBuddy.setSlamming(false);
        this.byteBuddy.setSlicing(false);
    }

    public void tick() {
        Player player = this.byteBuddy.getCurrentViewer();
        if (player != null && player.isAlive()) {
            this.byteBuddy.getNavigation().stop();
            this.byteBuddy.getLookControl().setLookAt((Entity)player, 30.0f, 30.0f);
            this.byteBuddy.setDeltaMovement(0.0, this.byteBuddy.getDeltaMovement().y * 0.0, 0.0);
            this.byteBuddy.setJumping(false);
        }
    }
}

