/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.entity.ai;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import net.turtleboi.bytebuddies.util.InventoryUtil;
import org.jetbrains.annotations.Nullable;

public class BuddyPickUpItemGoal
extends Goal {
    private static final boolean DEBUG = false;
    private static final int DEBUG_RATE_TICKS = 10;
    private final ByteBuddyEntity byteBuddy;
    private final double speed;
    private final double scanRange;
    private final double grabDistance;
    @Nullable
    private Vec3 approachTarget = null;
    private final int repathCooldownTicks;
    private ItemEntity target;
    private long lastPathTick;
    private int debugTickCounter;

    public BuddyPickUpItemGoal(ByteBuddyEntity byteBuddy, double speed, double scanRange, double grabDistance, int repathCooldownTicks) {
        this.byteBuddy = byteBuddy;
        this.speed = speed;
        this.scanRange = scanRange;
        this.grabDistance = grabDistance;
        this.repathCooldownTicks = Math.max(2, repathCooldownTicks);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.byteBuddy.level().isClientSide) {
            this.debugOnce("canUse=false (client side)");
            return false;
        }
        if (!this.byteBuddy.canAct()) {
            this.debugOnce("canUse=false (cannot act: sleeping or gated)");
            return false;
        }
        this.target = this.findVisibleItem();
        if (this.target == null || !this.target.isAlive()) {
            this.debugOnce("canUse=false (no visible item that fits)");
            return false;
        }
        ItemStack stack = this.target.getItem();
        if (stack.isEmpty()) {
            this.debugOnce("canUse=false (target stack empty)");
            return false;
        }
        boolean fits = this.byteBuddy.canFitInInventory(stack);
        this.debugOnce("canUse target=" + BuddyPickUpItemGoal.debugItem(this.target) + " fits=" + fits);
        return fits;
    }

    public boolean canContinueToUse() {
        boolean cont;
        if (this.byteBuddy.level().isClientSide) {
            this.debugOnce("continue=false (client side)");
            return false;
        }
        if (!this.byteBuddy.canAct()) {
            this.debugOnce("continue=false (cannot act)");
            return false;
        }
        if (this.target == null || !this.target.isAlive()) {
            this.debugOnce("continue=false (target null/dead)");
            return false;
        }
        if (!this.byteBuddy.canFitInInventory(this.target.getItem())) {
            this.debugOnce("continue=false (no longer fits)");
            return false;
        }
        double maxChase = this.scanRange + 2.0;
        double distSq = this.byteBuddy.distanceToSqr((Entity)this.target);
        boolean closeEnough = distSq <= maxChase * maxChase;
        boolean pathing = this.byteBuddy.getNavigation().isInProgress();
        boolean bl = cont = closeEnough || pathing || this.isInPickupRange(this.target, this.grabDistance);
        if (!cont) {
            this.debugOnce("continue=false (too far and not pathing) dist=" + String.format("%.2f", Math.sqrt(distSq)));
        }
        return cont;
    }

    public void start() {
        this.lastPathTick = 0L;
        Vec3 vec3 = this.approachTarget = this.target != null ? this.findPickupApproach(this.target) : null;
        if (this.approachTarget != null) {
            this.debugOnce("start: path\u2192approach " + BuddyPickUpItemGoal.debugPos(this.approachTarget.x, this.approachTarget.y, this.approachTarget.z));
            this.byteBuddy.getNavigation().moveTo(this.approachTarget.x, this.approachTarget.y, this.approachTarget.z, this.speed);
        } else if (this.target != null) {
            this.debugOnce("start: fallback path\u2192entity " + BuddyPickUpItemGoal.debugPos(this.target.getX(), this.target.getY(), this.target.getZ()));
            this.byteBuddy.getNavigation().moveTo((Entity)this.target, this.speed);
        }
    }

    public void stop() {
        this.debugOnce("stop");
        this.target = null;
        this.byteBuddy.getNavigation().stop();
    }

    public boolean isInterruptable() {
        return false;
    }

    public void tick() {
        long now;
        if (this.target == null || !this.target.isAlive()) {
            return;
        }
        this.byteBuddy.getLookControl().setLookAt((Entity)this.target, 15.0f, 15.0f);
        boolean facing = this.isFacing((Entity)this.target, 0.9);
        if (this.isInPickupRange(this.target, this.grabDistance)) {
            this.debugEvery("tick: AABB overlap \u2192 pickup");
            if (this.isInPickupRange(this.target, this.grabDistance) && facing) {
                this.tryPickup(this.target);
                return;
            }
        }
        if ((now = (long)this.byteBuddy.tickCount) - this.lastPathTick >= (long)this.repathCooldownTicks) {
            Vec3 newApproach = this.findPickupApproach(this.target);
            if (newApproach != null) {
                if (this.approachTarget == null || newApproach.distanceToSqr(this.approachTarget) > 0.25) {
                    this.approachTarget = newApproach;
                    this.debugEvery("tick: repath\u2192approach " + BuddyPickUpItemGoal.debugPos(newApproach.x, newApproach.y, newApproach.z));
                    this.byteBuddy.getNavigation().moveTo(newApproach.x, newApproach.y, newApproach.z, this.speed);
                } else if (!this.byteBuddy.getNavigation().isInProgress()) {
                    this.debugEvery("tick: path done but no overlap \u2192 reassert approach");
                    this.byteBuddy.getNavigation().moveTo(this.approachTarget.x, this.approachTarget.y, this.approachTarget.z, this.speed);
                }
            } else {
                this.debugEvery("tick: no standable approach \u2192 path\u2192item XYZ");
                this.byteBuddy.getNavigation().moveTo(this.target.getX(), this.target.getY(), this.target.getZ(), this.speed);
            }
            this.lastPathTick = now;
        }
        if (!this.isInPickupRange(this.target, this.grabDistance) && !this.byteBuddy.getNavigation().isInProgress()) {
            this.debugEvery("tick: nav done, no overlap \u2192 micro-walk");
            this.byteBuddy.getMoveControl().setWantedPosition(this.target.getX(), this.target.getY(), this.target.getZ(), Math.max(0.6, this.speed));
        }
    }

    private ItemEntity findVisibleItem() {
        double range = this.scanRange;
        AABB box = new AABB(this.byteBuddy.getX() - range, this.byteBuddy.getY() - range, this.byteBuddy.getZ() - range, this.byteBuddy.getX() + range, this.byteBuddy.getY() + range, this.byteBuddy.getZ() + range);
        List items = this.byteBuddy.level().getEntitiesOfClass(ItemEntity.class, box, itemEntity -> itemEntity.isAlive() && !itemEntity.getItem().isEmpty());
        ItemEntity best = null;
        double bestScore = Double.POSITIVE_INFINITY;
        for (ItemEntity itemEntity2 : items) {
            if (!this.byteBuddy.canFitInInventory(itemEntity2.getItem())) {
                this.debugEvery("scan skip " + BuddyPickUpItemGoal.debugItem(itemEntity2) + " fits=false");
                continue;
            }
            boolean fov = this.inFov((Entity)itemEntity2);
            boolean los = this.hasEyesOn((Entity)itemEntity2);
            double dist = this.byteBuddy.distanceToSqr((Entity)itemEntity2);
            double d = fov && los ? 0.0 : 1.0;
            double penalty = d;
            double score = dist + penalty;
            if (!(score < bestScore)) continue;
            bestScore = score;
            best = itemEntity2;
        }
        if (best != null) {
            this.debugOnce("scan best " + BuddyPickUpItemGoal.debugItem(best) + " dist=" + String.format("%.2f", Math.sqrt(bestScore)));
        }
        return best;
    }

    private boolean hasEyesOn(Entity entity) {
        Vec3 origin = this.byteBuddy.getEyePosition();
        Vec3 eyeDest = entity.getEyePosition();
        BlockHitResult hit = this.byteBuddy.level().clip(new ClipContext(origin, eyeDest, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)this.byteBuddy));
        boolean miss = hit.getType() == HitResult.Type.MISS;
        this.debugEvery("LOS " + BuddyPickUpItemGoal.debugItemPos(entity) + " \u2192 " + String.valueOf(hit.getType()));
        return miss;
    }

    private boolean isFacing(Entity entity, double dotThreshold) {
        Vec3 dir;
        Vec3 look = this.byteBuddy.getViewVector(1.0f).normalize();
        return look.dot(dir = entity.getEyePosition().subtract(this.byteBuddy.getEyePosition()).normalize()) >= dotThreshold;
    }

    private boolean inFov(Entity entity) {
        Vec3 dir;
        Vec3 look = this.byteBuddy.getViewVector(1.0f).normalize();
        double dot = look.dot(dir = entity.getEyePosition().subtract(this.byteBuddy.getEyePosition()).normalize());
        boolean validSight = dot > 0.2;
        this.debugEvery("FOV " + BuddyPickUpItemGoal.debugItemPos(entity) + " dot=" + String.format("%.3f", dot) + " validSight=" + validSight);
        return validSight;
    }

    private boolean isInPickupRange(ItemEntity itemEntity, double grabRadius) {
        boolean aabbTouch = this.byteBuddy.getBoundingBox().inflate(grabRadius / 2.0, (double)this.byteBuddy.getBbWidth(), grabRadius / 2.0).intersects(itemEntity.getBoundingBox());
        this.debugEvery("range " + BuddyPickUpItemGoal.debugItem(itemEntity) + " aabb=" + aabbTouch + " \u2192 " + aabbTouch);
        return aabbTouch;
    }

    @Nullable
    private Vec3 findPickupApproach(ItemEntity item) {
        int[][] OFFS = new int[][]{{0, 0}, {1, 0}, {-1, 0}, {0, 1}, {0, -1}, {1, 1}, {1, -1}, {-1, 1}, {-1, -1}};
        Level level = this.byteBuddy.level();
        BlockPos itemPos = BlockPos.containing((double)item.getX(), (double)item.getY(), (double)item.getZ());
        Vec3 best = null;
        double bestDist = Double.POSITIVE_INFINITY;
        for (int[] o : OFFS) {
            Vec3 center;
            double d;
            BlockPos p = itemPos.offset(o[0], 0, o[1]);
            if (!ByteBuddyEntity.isStandableForMove(this.byteBuddy, level, p) || !((d = (center = new Vec3((double)p.getX() + 0.5, (double)p.getY(), (double)p.getZ() + 0.5)).distanceToSqr(item.position())) < bestDist)) continue;
            bestDist = d;
            best = center;
        }
        return best;
    }

    private void tryPickup(ItemEntity itemEntity) {
        Level level = this.byteBuddy.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!itemEntity.isAlive()) {
            this.debugOnce("pickup aborted (target not alive)");
            return;
        }
        ItemStack stack = itemEntity.getItem();
        int before = stack.getCount();
        ItemStack leftover = InventoryUtil.mergeInto(this.byteBuddy.getMainInv(), stack);
        int taken = before - leftover.getCount();
        this.debugOnce("pickup " + BuddyPickUpItemGoal.debugItem(itemEntity) + " before=" + before + " taken=" + taken + " leftover=" + leftover.getCount());
        if (taken <= 0) {
            return;
        }
        serverLevel.getChunkSource().broadcastAndSend((Entity)this.byteBuddy, (Packet)new ClientboundTakeItemEntityPacket(itemEntity.getId(), this.byteBuddy.getId(), taken));
        serverLevel.playSound(null, this.byteBuddy.getX(), this.byteBuddy.getY(), this.byteBuddy.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, 1.0f + (this.byteBuddy.getRandom().nextFloat() - this.byteBuddy.getRandom().nextFloat()) * 0.4f);
        if (leftover.isEmpty()) {
            itemEntity.discard();
        } else {
            itemEntity.setItem(leftover);
        }
        this.byteBuddy.swing(InteractionHand.MAIN_HAND, true);
    }

    private void debugEvery(String message) {
    }

    private void debugOnce(String message) {
    }

    private static String debugItem(ItemEntity itemEntity) {
        ItemStack s = itemEntity.getItem();
        return "Item{" + s.getDisplayName().getString() + " x" + s.getCount() + " @" + String.format("%.1f,%.1f,%.1f", itemEntity.getX(), itemEntity.getY(), itemEntity.getZ()) + "}";
    }

    private static String debugPos(double x, double y, double z) {
        return String.format("(%.2f, %.2f, %.2f)", x, y, z);
    }

    private static String debugItemPos(Entity entity) {
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            return BuddyPickUpItemGoal.debugItem(itemEntity);
        }
        return "Entity@" + String.format("(%.2f, %.2f, %.2f)", entity.getX(), entity.getY(), entity.getZ());
    }
}

