/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.entity.ai.combat;

import java.util.EnumSet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import net.turtleboi.bytebuddies.item.ModItems;
import net.turtleboi.bytebuddies.util.BotDebug;
import net.turtleboi.bytebuddies.util.GoalUtil;
import net.turtleboi.bytebuddies.util.ToolUtil;

public class BuddyMeleeAttackGoal
extends Goal {
    private final ByteBuddyEntity byteBuddy;
    private final double speed;
    private final boolean rememberTarget;
    private LivingEntity target;
    private int energyPerHit = 0;
    private static final ToolUtil.ToolType requiredTool = ToolUtil.ToolType.SWORD;
    private static final double safeDistance = 64.0;
    private static final float swellProgress = 0.55f;
    private boolean fleeingFromCreeper = false;
    private final double HIT_REACH;
    private static final double WINDUP_PAD = 0.5;
    private static final double KITE_TARGET = 2.5;
    private static final double KITE_ENTER = 3.0;
    private static final double KITE_EXIT = 3.0;
    private static final int REPATH_COOLDOWN = 2;
    private boolean requireKiteRadius = false;
    private int lastHurtTime = 0;
    private static final int HURT_COOLDOWN_TICKS = 12;
    private static final int MISS_COOLDOWN_TICKS = 10;
    private long hitTick = 0L;
    private long animEndTick = 0L;
    private boolean hitFired = false;
    private long nextAttackTick = 0L;
    private Phase phase = Phase.KITE;
    private long lastPathRecalcTick = 0L;

    public BuddyMeleeAttackGoal(ByteBuddyEntity byteBuddy, double speed, double hitReach, boolean rememberTarget) {
        this.byteBuddy = byteBuddy;
        this.speed = speed;
        this.HIT_REACH = hitReach;
        this.rememberTarget = rememberTarget;
        this.energyPerHit = (int)(4.0 * byteBuddy.getAttributeValue(Attributes.ATTACK_DAMAGE));
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        this.target = this.byteBuddy.getTarget();
        boolean result = this.target == null || !this.target.isAlive() ? false : (!GoalUtil.ensureUse(this.byteBuddy, requiredTool, this.energyPerHit, 1) ? false : this.byteBuddy.getDock().isEmpty());
        return result;
    }

    public boolean canContinueToUse() {
        boolean result;
        if (this.target == null || !this.target.isAlive()) {
            result = false;
        } else if (this.rememberTarget) {
            boolean farOrNavigating = this.byteBuddy.distanceToSqr((Entity)this.target) > 3.0 || this.byteBuddy.getNavigation().isInProgress();
            boolean notKiting = this.phase != Phase.KITE || this.currentServerTime() < this.nextAttackTick;
            result = farOrNavigating || notKiting;
        } else {
            result = this.canUse();
        }
        return result;
    }

    public void start() {
        this.byteBuddy.setAggressive(true);
        this.clearAnim();
        this.phase = Phase.KITE;
        this.nextAttackTick = 0L;
        this.requireKiteRadius = false;
    }

    public void stop() {
        this.byteBuddy.setAggressive(false);
        this.target = null;
        this.byteBuddy.getNavigation().stop();
        this.clearAnim();
        this.phase = Phase.KITE;
        this.requireKiteRadius = false;
    }

    public boolean isInterruptable() {
        return false;
    }

    public void tick() {
        long currentTick;
        ServerLevel levelServer;
        Level level = this.byteBuddy.level();
        ServerLevel serverLevel = level instanceof ServerLevel ? (levelServer = (ServerLevel)level) : null;
        long l = currentTick = serverLevel != null ? serverLevel.getGameTime() : 0L;
        if (this.target != null && this.target.isAlive()) {
            LivingEntity latest = this.byteBuddy.getTarget();
            if (latest != null) {
                this.target = latest;
            }
            this.tickAnim(currentTick);
            this.byteBuddy.getLookControl().setLookAt((Entity)this.target, 90.0f, 90.0f);
            boolean creeperHandled = this.handleCreeper(currentTick);
            if (!creeperHandled) {
                this.lowHealthFlee(this.byteBuddy, currentTick);
                double distanceSquared = this.byteBuddy.distanceToSqr((Entity)this.target);
                if (this.phase == Phase.KITE) {
                    boolean cooldownReady;
                    boolean bl = cooldownReady = currentTick >= this.nextAttackTick;
                    if (this.requireKiteRadius && distanceSquared < 9.0) {
                        this.kiteTowardRadius(2.5, Math.max(1.0, this.speed * 1.66), currentTick);
                    } else {
                        this.requireKiteRadius = false;
                        if (!cooldownReady || distanceSquared < 9.0) {
                            this.kiteTowardRadius(2.5, Math.max(1.0, this.speed * 1.66), currentTick);
                        } else {
                            this.phase = Phase.APPROACH;
                        }
                    }
                } else if (this.phase == Phase.APPROACH) {
                    if (currentTick < this.nextAttackTick) {
                        this.phase = Phase.KITE;
                        this.requireKiteRadius = true;
                    } else {
                        this.throttledMoveToTarget(currentTick, this.speed);
                        if (this.inWindupRangeAabb()) {
                            if (this.byteBuddy.getEnergyStorage().getEnergyStored() >= this.energyPerHit) {
                                this.startWindup(currentTick);
                                this.phase = Phase.WINDUP;
                            } else {
                                this.strafeAround(this.target, Math.max(1.0, this.speed), currentTick);
                            }
                        }
                    }
                } else if (this.phase == Phase.WINDUP && (this.animEndTick <= 0L || currentTick >= this.animEndTick)) {
                    this.phase = Phase.KITE;
                }
            }
        }
    }

    private void throttledMoveToTarget(long currentTick, double runSpeed) {
        if (currentTick - this.lastPathRecalcTick >= 2L) {
            this.byteBuddy.getNavigation().moveTo((Entity)this.target, runSpeed);
            this.lastPathRecalcTick = currentTick;
        }
    }

    private boolean handleCreeper(long currentTick) {
        boolean result;
        LivingEntity livingEntity = this.target;
        if (!(livingEntity instanceof Creeper)) {
            this.fleeingFromCreeper = false;
            result = false;
        } else {
            boolean dangerousNow;
            Creeper creeper = (Creeper)livingEntity;
            double distanceSquared = this.byteBuddy.distanceToSqr((Entity)this.target);
            float swelling = creeper.getSwelling(0.0f);
            boolean bl = dangerousNow = creeper.isIgnited() || swelling >= 0.55f;
            if (!this.fleeingFromCreeper) {
                if (dangerousNow && distanceSquared < 64.0) {
                    this.fleeingFromCreeper = true;
                    this.byteBuddy.getNavigation().stop();
                }
            } else {
                boolean calmed;
                boolean bl2 = calmed = !creeper.isIgnited() && swelling <= 0.35f;
                if (calmed && distanceSquared >= 64.0) {
                    this.fleeingFromCreeper = false;
                }
            }
            if (this.fleeingFromCreeper) {
                this.fleeFrom(this.target, Math.max(1.0, this.speed * 1.66));
                this.ensureKiteUntil(currentTick + 10L);
                result = true;
            } else {
                result = false;
            }
        }
        return result;
    }

    private void lowHealthFlee(ByteBuddyEntity byteBuddy, long currentTick) {
        if ((double)byteBuddy.getHealth() < (double)byteBuddy.getMaxHealth() * 0.4 && this.justGotHit()) {
            this.nextAttackTick = Math.max(this.nextAttackTick, currentTick + 12L);
            this.requireKiteRadius = true;
        }
    }

    private void ensureKiteUntil(long absoluteTick) {
        this.nextAttackTick = Math.max(this.nextAttackTick, absoluteTick);
        this.phase = Phase.KITE;
    }

    private void kiteTowardRadius(double targetRadius, double runSpeed, long currentTick) {
        if (this.target != null) {
            boolean alreadyOutside;
            double distance = Math.sqrt(this.byteBuddy.distanceToSqr((Entity)this.target));
            boolean bl = alreadyOutside = distance >= 2.5;
            if (alreadyOutside) {
                this.strafeAround(this.target, runSpeed, currentTick);
            } else {
                double delta = Mth.clamp((double)(targetRadius - distance), (double)2.0, (double)12.0);
                Vec3 away = this.byteBuddy.position().subtract(this.target.position());
                if (away.lengthSqr() < 1.0E-4) {
                    away = new Vec3(1.0, 0.0, 0.0);
                }
                away = away.normalize().scale(delta);
                Vec3 destination = this.byteBuddy.position().add(away.x, 0.0, away.z);
                Vec3 random = DefaultRandomPos.getPosAway((PathfinderMob)this.byteBuddy, (int)14, (int)6, (Vec3)this.target.position());
                if (random != null) {
                    destination = random;
                }
                if (currentTick - this.lastPathRecalcTick >= 2L) {
                    this.byteBuddy.getNavigation().moveTo(destination.x, destination.y, destination.z, runSpeed);
                    this.lastPathRecalcTick = currentTick;
                }
            }
        }
    }

    private void strafeAround(LivingEntity pivot, double runSpeed, long currentTick) {
        Vec3 toMe = this.byteBuddy.position().subtract(pivot.position());
        if (toMe.lengthSqr() < 1.0E-4) {
            toMe = new Vec3(1.0, 0.0, 0.0);
        }
        Vec3 perpendicular = new Vec3(-toMe.z, 0.0, toMe.x).normalize().scale(2.5);
        Vec3 destination = this.byteBuddy.position().add(perpendicular);
        if (currentTick - this.lastPathRecalcTick >= 2L) {
            this.byteBuddy.getNavigation().moveTo(destination.x, destination.y, destination.z, Math.max(1.0, runSpeed));
            this.lastPathRecalcTick = currentTick;
        }
    }

    private void fleeFrom(LivingEntity threat, double runSpeed) {
        Vec3 away = this.byteBuddy.position().subtract(threat.position());
        if (away.lengthSqr() < 1.0E-4) {
            away = new Vec3(1.0, 0.0, 0.0);
        }
        away = away.normalize().scale(8.0);
        Vec3 destination = this.byteBuddy.position().add(away.x, 0.0, away.z);
        Vec3 random = DefaultRandomPos.getPosAway((PathfinderMob)this.byteBuddy, (int)12, (int)6, (Vec3)threat.position());
        if (random != null) {
            destination = random;
        }
        this.byteBuddy.getNavigation().moveTo(destination.x, destination.y, destination.z, runSpeed);
    }

    private boolean justGotHit() {
        int hurtTime = this.byteBuddy.hurtTime;
        boolean edge = hurtTime > 0 && this.lastHurtTime <= 0;
        this.lastHurtTime = hurtTime;
        boolean result = edge;
        return result;
    }

    private double toolReachBonus() {
        if (this.byteBuddy.getHeldTool().is((Item)ModItems.BUSTER_SWORD.get()) || this.byteBuddy.getHeldTool().is((Item)ModItems.TERRABLADE.get())) {
            return 1.0;
        }
        return 0.0;
    }

    private boolean inMeleeRangeAabb() {
        if (this.target == null) {
            return false;
        }
        double reach = this.HIT_REACH + this.toolReachBonus();
        return this.byteBuddy.getBoundingBox().inflate(reach / 2.0, (double)this.byteBuddy.getBbWidth(), reach / 2.0).intersects(this.target.getBoundingBox());
    }

    private boolean inWindupRangeAabb() {
        if (this.target == null) {
            return false;
        }
        double reach = this.HIT_REACH + this.toolReachBonus() + 0.5;
        return this.byteBuddy.getBoundingBox().inflate(reach / 2.0, (double)this.byteBuddy.getBbWidth(), reach / 2.0).intersects(this.target.getBoundingBox());
    }

    private long currentServerTime() {
        long l;
        Level level = this.byteBuddy.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            l = serverLevel.getGameTime();
        } else {
            l = 0L;
        }
        return l;
    }

    private void startWindup(long currentTick) {
        this.hitFired = false;
        int totalTicks = GoalUtil.toTicks(1.6);
        int startTicks = GoalUtil.toTicks(0.7);
        this.hitTick = currentTick + (long)Math.max(0, startTicks);
        this.animEndTick = currentTick + (long)Math.max(1, totalTicks);
        this.byteBuddy.setSlicing(true);
        double attackSpeed = Math.max(0.1, this.byteBuddy.getAttributeValue(Attributes.ATTACK_SPEED));
        int cooldownTicks = Mth.clamp((int)Mth.ceil((double)(20.0 / attackSpeed)), (int)4, (int)40);
        this.nextAttackTick = currentTick + (long)cooldownTicks;
    }

    private void clearAnim() {
        this.hitFired = false;
        this.hitTick = 0L;
        this.animEndTick = 0L;
        this.byteBuddy.setSlicing(false);
    }

    private void tickAnim(long currentTick) {
        if (this.animEndTick > 0L) {
            if (!this.hitFired && currentTick >= this.hitTick) {
                this.hitFired = true;
                LivingEntity latest = this.byteBuddy.getTarget();
                if (latest != null) {
                    this.target = latest;
                }
                if (this.target != null && this.target.isAlive()) {
                    if (this.inMeleeRangeAabb() && this.byteBuddy.consumeEnergy(this.energyPerHit)) {
                        this.byteBuddy.swing(InteractionHand.MAIN_HAND, true);
                        this.byteBuddy.doHurtTarget((Entity)this.target);
                        ToolUtil.applyToolWear(this.byteBuddy, requiredTool, 1.0f);
                        this.byteBuddy.onTaskSuccess(ByteBuddyEntity.TaskType.COMBAT, this.byteBuddy.getOnPos());
                        this.phase = Phase.KITE;
                        this.requireKiteRadius = true;
                    } else {
                        BotDebug.log(this.byteBuddy, "COMBAT: miss/energy fail at hit frame");
                        this.phase = Phase.KITE;
                        this.requireKiteRadius = true;
                        this.nextAttackTick = Math.max(this.nextAttackTick, currentTick + 10L);
                    }
                } else {
                    this.phase = Phase.KITE;
                    this.requireKiteRadius = true;
                }
            }
            if (currentTick >= this.animEndTick) {
                this.clearAnim();
            }
        }
    }

    private static enum Phase {
        KITE,
        APPROACH,
        WINDUP;

    }
}

