/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.entity.ai.farmer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.turtleboi.bytebuddies.api.SeedItemProvider;
import net.turtleboi.bytebuddies.block.entity.DockingStationBlockEntity;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import net.turtleboi.bytebuddies.item.custom.FloppyDiskItem;
import net.turtleboi.bytebuddies.util.BotDebug;
import net.turtleboi.bytebuddies.util.GoalUtil;
import net.turtleboi.bytebuddies.util.InventoryUtil;
import net.turtleboi.bytebuddies.util.ToolUtil;

public class HarvestGoal
extends Goal {
    private final ByteBuddyEntity byteBuddy;
    @Nullable
    private BlockPos targetPos;
    @Nullable
    private BlockPos approachPos;
    private List<Approach> approachPlans = Collections.emptyList();
    private int anchorIndex = 0;
    @Nullable
    private Vec3 targetAnchor = null;
    private boolean edgeAnchored = false;
    private long nextActionTick = 0L;
    private static final int baseActionCooldown = 20;
    private BotDebug.GoalPhase currentPhase = BotDebug.GoalPhase.IDLE;
    private BotDebug.FailReason lastFail = BotDebug.FailReason.NONE;
    private long phaseStartedTick = 0L;
    private long phaseProgressTick = 0L;
    private int repathRetries = 0;
    private int anchorRotateRetries = 0;
    private int targetReselectRetries = 0;
    private static final int seekingTimout = 20;
    private static final int movingTimeout = 160;
    private static final int actingTimeout = 60;
    private double lastMoveDistSq = Double.POSITIVE_INFINITY;
    private double lastAnchorDistSq = Double.POSITIVE_INFINITY;
    private static final double reachDistanceMin = 0.95;
    private static final double verticalTolerance = 1.25;
    private static final double finalApproachDist = 1.25;
    private static final double microDistMin = 0.08;
    private static final double microDistMax = 0.18;
    @Nullable
    private BlockPos claimedHarvestPos = null;
    @Nullable
    private BlockPos firePos = null;
    @Nullable
    private BlockState firePreState = null;
    private static final int claimTimeOut = 120;
    private long nextClaimRenewHarvest = 0L;
    private long animationStart = 0L;
    private long animationEnd = 0L;
    private boolean actionStarted = false;
    private static final int harvestEnergyCost = 25;
    private boolean canPlantAfterHarvest = true;

    public HarvestGoal(ByteBuddyEntity byteBuddy) {
        this.byteBuddy = byteBuddy;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        byteBuddy.setPathfindingMalus(PathType.WATER, 8.0f);
        byteBuddy.setPathfindingMalus(PathType.WATER_BORDER, 4.0f);
    }

    public boolean canUse() {
        ServerLevel serverLevel;
        Level level = this.byteBuddy.level();
        if (level instanceof ServerLevel && this.byteBuddy.harvestOnHold(serverLevel = (ServerLevel)level)) {
            return false;
        }
        if (this.currentPhase == BotDebug.GoalPhase.ACTING) {
            level = this.byteBuddy.level();
            if (level instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                return serverLevel.getGameTime() <= this.animationEnd;
            }
            return true;
        }
        if (this.targetPos != null) {
            return true;
        }
        if (this.byteBuddy.getBuddyRole() != ByteBuddyEntity.BuddyRole.FARMER) {
            this.failTask(BotDebug.FailReason.WRONG_ROLE, "role=" + String.valueOf((Object)this.byteBuddy.getBuddyRole()));
            return false;
        }
        if (this.byteBuddy.getDock().isEmpty()) {
            this.failTask(BotDebug.FailReason.NO_DOCK, "no station bound");
            return false;
        }
        if (!GoalUtil.ensureUse(this.byteBuddy, ToolUtil.ToolType.EMPTY_HAND, 25, 1)) {
            return false;
        }
        Optional<HarvestPlan> targetLock = this.findHarvestPlan();
        if (targetLock.isEmpty()) {
            return false;
        }
        this.targetPos = targetLock.get().crop();
        this.approachPos = targetLock.get().targetPos();
        this.targetAnchor = GoalUtil.getEdgeAnchor(this.targetPos, this.approachPos);
        this.edgeAnchored = false;
        this.resetProgress();
        this.enterPhase(BotDebug.GoalPhase.MOVING, "to edge " + this.approachPos.toShortString());
        return true;
    }

    public boolean canContinueToUse() {
        if (this.currentPhase == BotDebug.GoalPhase.ACTING) {
            Level level = this.byteBuddy.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                return serverLevel.getGameTime() <= this.animationEnd;
            }
            return true;
        }
        if (this.targetPos == null) {
            return false;
        }
        return GoalUtil.ensureUse(this.byteBuddy, ToolUtil.ToolType.EMPTY_HAND, 25, 1);
    }

    public void stop() {
        this.clearTimedAnimation();
        this.releaseHarvestClaim();
        this.targetPos = null;
        this.approachPos = null;
        this.targetAnchor = null;
        this.edgeAnchored = false;
        this.approachPlans = Collections.emptyList();
        this.anchorIndex = 0;
        super.stop();
    }

    public boolean isInterruptable() {
        return false;
    }

    public void tick() {
        Level level = this.byteBuddy.level();
        if (level instanceof ServerLevel) {
            boolean withinReach;
            CropBlock crop;
            Block block;
            ServerLevel serverLevel = (ServerLevel)level;
            this.tickTimedAnimation();
            if (this.targetPos == null || this.approachPos == null) {
                return;
            }
            Vec3 targetCenter = this.targetPos.getCenter();
            if (this.currentPhase == BotDebug.GoalPhase.ACTING) {
                this.byteBuddy.getLookControl().setLookAt(targetCenter.x, this.targetPos.getBottomCenter().y, targetCenter.z, 15.0f, 15.0f);
                return;
            }
            GoalUtil.renewClaimIfNeeded(this.byteBuddy, serverLevel, ByteBuddyEntity.TaskType.HARVEST, this.claimedHarvestPos, this.targetPos, serverLevel.getGameTime(), 5, 120, () -> this.nextClaimRenewHarvest, ticks -> {
                this.nextClaimRenewHarvest = ticks;
            });
            BlockState targetState = this.byteBuddy.level().getBlockState(this.targetPos);
            if (!(this.currentPhase == BotDebug.GoalPhase.ACTING || (block = targetState.getBlock()) instanceof CropBlock && (crop = (CropBlock)block).isMaxAge(targetState))) {
                this.clearTarget();
                this.enterPhase(BotDebug.GoalPhase.IDLE, "target invalid, rescan");
                return;
            }
            this.navigatePhases(serverLevel);
            if (this.targetAnchor != null) {
                double distToTarget = this.byteBuddy.position().distanceTo(this.targetAnchor);
                if (distToTarget > 1.25) {
                    PathNavigation pathNavigation = this.byteBuddy.getNavigation();
                    if (pathNavigation instanceof GroundPathNavigation) {
                        boolean needsNewPath;
                        GroundPathNavigation pathNavigation2 = (GroundPathNavigation)pathNavigation;
                        Path currentPath = pathNavigation2.getPath();
                        boolean bl = needsNewPath = currentPath == null || currentPath.isDone() || this.approachPos == null || !currentPath.getTarget().equals((Object)this.approachPos);
                        if (needsNewPath) {
                            Path path;
                            GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
                            Path path2 = path = this.approachPos != null ? pathNavigation2.createPath(this.approachPos, 0) : null;
                            if (path != null) {
                                pathNavigation2.moveTo(path, (double)this.byteBuddy.actionSpeedMultiplier());
                                GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
                            } else {
                                this.byteBuddy.getNavigation().moveTo(this.targetAnchor.x, this.targetAnchor.y, this.targetAnchor.z, (double)this.byteBuddy.actionSpeedMultiplier());
                            }
                        }
                    } else {
                        this.byteBuddy.getNavigation().moveTo(this.targetAnchor.x, this.targetAnchor.y, this.targetAnchor.z, (double)this.byteBuddy.actionSpeedMultiplier());
                    }
                    return;
                }
                if (!this.edgeAnchored) {
                    GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
                    if (distToTarget <= 0.08) {
                        GoalUtil.lockToAnchor(this.byteBuddy, this.targetAnchor);
                        this.edgeAnchored = true;
                        this.markProgress();
                        BotDebug.log(this.byteBuddy, "HARVEST: locked anchor");
                    } else {
                        this.byteBuddy.getNavigation().stop();
                        this.byteBuddy.getMoveControl().setWantedPosition(this.targetAnchor.x, this.targetAnchor.y, this.targetAnchor.z, (double)this.byteBuddy.actionSpeedMultiplier());
                        if (distToTarget + 0.001 < this.lastAnchorDistSq) {
                            this.lastAnchorDistSq = distToTarget;
                            this.markProgress();
                        }
                        BotDebug.log(this.byteBuddy, String.format("final-targetPos dH=%.3f to edge %s", distToTarget, this.approachPos.toShortString()));
                    }
                } else {
                    double distSq = Math.sqrt(GoalUtil.hDistSq(this.byteBuddy.position(), this.targetAnchor));
                    if (distSq > 0.18) {
                        this.edgeAnchored = false;
                    }
                }
            } else if (this.approachPos != null && (block = this.byteBuddy.getNavigation()) instanceof GroundPathNavigation) {
                GroundPathNavigation pathNavigation = (GroundPathNavigation)block;
                GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
                Path path = pathNavigation.createPath(this.approachPos, 0);
                pathNavigation.moveTo(path, (double)this.byteBuddy.actionSpeedMultiplier());
                GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
                return;
            }
            Vec3 buddyPos = this.byteBuddy.position();
            boolean bl = withinReach = GoalUtil.hDistSq(buddyPos, targetCenter) <= 0.9025 && Math.abs(buddyPos.y - targetCenter.y) <= 1.25;
            if (withinReach) {
                if (this.animationEnd > 0L || this.currentPhase == BotDebug.GoalPhase.ACTING) {
                    this.byteBuddy.getLookControl().setLookAt(targetCenter.x, this.targetPos.getBottomCenter().y, targetCenter.z, 15.0f, 15.0f);
                } else {
                    if (!GoalUtil.actionReady(serverLevel, this.nextActionTick)) {
                        return;
                    }
                    if (!this.verifyClaimOrAbort(serverLevel, ByteBuddyEntity.TaskType.HARVEST, this.claimedHarvestPos, this.targetPos)) {
                        return;
                    }
                    this.firePos = this.targetPos;
                    this.firePreState = targetState;
                    this.startTimedAnimation(GoalUtil.toTicks(2.6), GoalUtil.toTicks(1.8), this.targetPos, this.firePreState);
                    BotDebug.log(this.byteBuddy, "HARVEST schedule: now=" + serverLevel.getGameTime() + " start=" + (serverLevel.getGameTime() + (long)GoalUtil.toTicks(1.8)) + " end=" + (serverLevel.getGameTime() + (long)GoalUtil.toTicks(2.6)) + " firePos=" + String.valueOf(this.firePos) + " preState=" + this.firePreState.getBlock().getName().getString());
                    return;
                }
            }
            if (this.targetAnchor != null && !this.edgeAnchored) {
                this.byteBuddy.getMoveControl().setWantedPosition(this.targetAnchor.x, this.targetAnchor.y, this.targetAnchor.z, (double)this.byteBuddy.actionSpeedMultiplier());
            }
        }
    }

    private void navigatePhases(ServerLevel serverLevel) {
        switch (this.currentPhase) {
            case MOVING: {
                this.handleMoving(serverLevel);
                break;
            }
            case ACTING: {
                this.handleActing();
                break;
            }
            case SEEKING: {
                this.handleSeeking();
                break;
            }
        }
    }

    private void handleMoving(ServerLevel serverLevel) {
        if (this.isWithinFinalApproach()) {
            this.renewPathAheadIfNeeded(serverLevel, 5);
            this.markProgress();
            return;
        }
        this.updateApproachProgress();
        this.renewPathAheadIfNeeded(serverLevel, 5);
        if (this.stalledFor(16)) {
            if (this.tryRecoverFromStall(serverLevel)) {
                this.markProgress();
            } else {
                GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
                this.clearTarget();
                this.enterPhase(BotDebug.GoalPhase.IDLE, "MOVING stalled, rescan");
            }
            return;
        }
        if (this.timedOut(160)) {
            GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
            this.clearTarget();
            this.enterPhase(BotDebug.GoalPhase.IDLE, "MOVING timeout, rescan");
        }
    }

    private boolean isWithinFinalApproach() {
        if (this.edgeAnchored) {
            return true;
        }
        if (this.targetAnchor == null) {
            return false;
        }
        return Math.sqrt(GoalUtil.hDistSq(this.byteBuddy.position(), this.targetAnchor)) <= 1.25;
    }

    private void updateApproachProgress() {
        if (this.approachPos != null) {
            Vec3 progressToTarget = this.targetAnchor != null ? this.targetAnchor : this.approachPos.getCenter();
            double distSq = GoalUtil.hDistSq(this.byteBuddy.position(), progressToTarget);
            if (distSq + 0.001 < this.lastMoveDistSq) {
                this.lastMoveDistSq = distSq;
                this.markProgress();
            }
        }
    }

    private void renewPathAheadIfNeeded(ServerLevel serverLevel, int lookahead) {
        PathNavigation pathNavigation = this.byteBuddy.getNavigation();
        if (!(pathNavigation instanceof GroundPathNavigation)) {
            return;
        }
        GroundPathNavigation pathNavigation2 = (GroundPathNavigation)pathNavigation;
        Path path = pathNavigation2.getPath();
        if (path == null) {
            return;
        }
        if (serverLevel.getGameTime() % 5L != 0L) {
            return;
        }
        this.byteBuddy.renewPathAhead(serverLevel, path, lookahead);
    }

    private boolean tryRecoverFromStall(ServerLevel serverLevel) {
        GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
        if (this.repath()) {
            GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
            BotDebug.log(this.byteBuddy, "MOVING: repath");
            return true;
        }
        if (this.rotateAnchor()) {
            GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
            BotDebug.log(this.byteBuddy, "MOVING: rotate targetPos side");
            return true;
        }
        return false;
    }

    private void handleActing() {
        if (this.animationEnd > 0L) {
            this.markProgress();
            return;
        }
        if (this.timedOut(60)) {
            BotDebug.log(this.byteBuddy, "ACTING timeout; abort");
            this.clearTarget();
            this.enterPhase(BotDebug.GoalPhase.IDLE, "abort act");
        }
    }

    private void handleSeeking() {
        if (!this.timedOut(20)) {
            return;
        }
        if (this.targetReselectRetries++ < 2) {
            Optional<HarvestPlan> plan = this.findHarvestPlan();
            if (plan.isPresent()) {
                this.targetPos = plan.get().crop();
                this.approachPos = plan.get().targetPos();
                this.targetAnchor = GoalUtil.getEdgeAnchor(this.targetPos, this.approachPos);
                this.resetProgress();
                this.enterPhase(BotDebug.GoalPhase.MOVING, "retry seek -> moving");
            } else {
                this.enterPhase(BotDebug.GoalPhase.IDLE, "seek timeout, no target");
            }
        } else {
            this.enterPhase(BotDebug.GoalPhase.IDLE, "seek timeout (exhausted)");
        }
    }

    private Optional<HarvestPlan> findHarvestPlan() {
        BlockPos dockPos = this.byteBuddy.getDock().orElse(null);
        if (dockPos == null) {
            return Optional.empty();
        }
        int effectiveRadius = this.byteBuddy.effectiveRadius();
        Level level = this.byteBuddy.level();
        DockingStationBlockEntity dockBlock = GoalUtil.dockBlockEntity(this.byteBuddy);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos.MutableBlockPos potentialCandidate = new BlockPos.MutableBlockPos();
            for (int y = -1; y <= 2; ++y) {
                for (int x = -effectiveRadius; x <= effectiveRadius; ++x) {
                    for (int z = -effectiveRadius; z <= effectiveRadius; ++z) {
                        List<Approach> approachPlans;
                        CropBlock crop;
                        potentialCandidate.set(dockPos.getX() + x, dockPos.getY() + y, dockPos.getZ() + z);
                        BlockState blockState = level.getBlockState((BlockPos)potentialCandidate);
                        Block block = blockState.getBlock();
                        if (!(block instanceof CropBlock) || !(crop = (CropBlock)block).isMaxAge(blockState) || dockBlock != null && dockBlock.isReserved(serverLevel, ByteBuddyEntity.TaskType.HARVEST, (BlockPos)potentialCandidate) || (approachPlans = this.buildApproachPlans(level, potentialCandidate.immutable())).isEmpty()) continue;
                        if (dockBlock != null) {
                            boolean targetViable = dockBlock.tryClaim(serverLevel, ByteBuddyEntity.TaskType.HARVEST, potentialCandidate.immutable(), this.byteBuddy.getUUID(), 120);
                            if (!targetViable) continue;
                            this.claimedHarvestPos = potentialCandidate.immutable();
                            this.nextClaimRenewHarvest = serverLevel.getGameTime() + 5L;
                        }
                        this.approachPlans = approachPlans;
                        this.anchorIndex = 0;
                        Approach approach = approachPlans.get(0);
                        this.approachPos = approach.targetPos();
                        return Optional.of(new HarvestPlan(potentialCandidate.immutable(), approach.targetPos(), approach.path()));
                    }
                }
            }
        }
        return Optional.empty();
    }

    private List<Approach> buildApproachPlans(Level level, BlockPos cropPos) {
        BlockPos[] targetSides;
        ArrayList<Approach> approachList = new ArrayList<Approach>(4);
        for (BlockPos targetPos : targetSides = new BlockPos[]{cropPos.east(), cropPos.west(), cropPos.south(), cropPos.north()}) {
            Path path;
            Vec3 cropEdgeAnchor;
            if (!ByteBuddyEntity.isStandableForMove(this.byteBuddy, level, targetPos) || (cropEdgeAnchor = GoalUtil.getEdgeAnchor(cropPos, targetPos)) == null) continue;
            PathNavigation pathNavigation = this.byteBuddy.getNavigation();
            if (pathNavigation instanceof GroundPathNavigation) {
                GroundPathNavigation pathNavigation2 = (GroundPathNavigation)pathNavigation;
                v0 = pathNavigation2.createPath(targetPos, 0);
            } else {
                v0 = path = null;
            }
            if (path == null) continue;
            double distSq = GoalUtil.hDistSq(this.byteBuddy.position(), cropEdgeAnchor);
            approachList.add(new Approach(targetPos, cropEdgeAnchor, distSq, path));
        }
        approachList.sort(Comparator.comparingDouble(Approach::distSq));
        return approachList;
    }

    private void performHarvest(BlockPos cropPos, BlockState blockState) {
        CropBlock crop;
        Level level = this.byteBuddy.level();
        Block block = blockState.getBlock();
        if (!(block instanceof CropBlock) || !(crop = (CropBlock)block).isMaxAge(blockState)) {
            BotDebug.log(this.byteBuddy, "HARVEST: no longer ripe at " + (cropPos != null ? cropPos.toShortString() : "null"));
            return;
        }
        if (!this.byteBuddy.consumeEnergy(25)) {
            BotDebug.log(this.byteBuddy, "HARVEST: out of energy");
            return;
        }
        List drops = Block.getDrops((BlockState)blockState, (ServerLevel)((ServerLevel)level), (BlockPos)cropPos, null, (Entity)this.byteBuddy, (ItemStack)ItemStack.EMPTY);
        try {
            FloppyDiskItem.DiskHooks.applyPrimaryYieldBonus(drops, blockState.getBlock(), this.byteBuddy, this.byteBuddy.yieldBonusChance());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        level.destroyBlock(cropPos, false);
        Vec3 cropCenter = cropPos.getCenter();
        int inserted = 0;
        int dropped = 0;
        for (ItemStack stack : drops) {
            ItemStack remainder = InventoryUtil.mergeInto(this.byteBuddy.getMainInv(), stack);
            if (!remainder.isEmpty()) {
                Containers.dropItemStack((Level)level, (double)cropCenter.x, (double)cropCenter.y, (double)cropCenter.z, (ItemStack)remainder);
                dropped += remainder.getCount();
                continue;
            }
            inserted += stack.getCount();
        }
        this.byteBuddy.onTaskSuccess(ByteBuddyEntity.TaskType.HARVEST, cropPos);
        BotDebug.log(this.byteBuddy, "HARVEST at " + cropPos.toShortString() + " inserted=" + inserted + " dropped=" + dropped);
        BotDebug.mark(level, cropPos);
        if (this.canPlantAfterHarvest) {
            this.tryEnqueueImmediatePlantFromPreState(cropPos, blockState);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.byteBuddy.holdHarvestForReplant(serverLevel, 40);
            }
        }
    }

    public HarvestGoal enablePostHarvestPlant(boolean enabled) {
        this.canPlantAfterHarvest = enabled;
        return this;
    }

    private void tryEnqueueImmediatePlantFromPreState(BlockPos plantPos, BlockState preBreakState) {
        Level level = this.byteBuddy.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Block plantBlock = preBreakState.getBlock();
        if (!(plantBlock instanceof SeedItemProvider)) {
            return;
        }
        SeedItemProvider seedItemProvider = (SeedItemProvider)plantBlock;
        Item seedItem = seedItemProvider.bytebuddies$getSeedItem().asItem();
        BlockState plantState = plantBlock.defaultBlockState();
        if (!GoalUtil.canPlantAt(level, plantPos, plantState)) {
            return;
        }
        DockingStationBlockEntity dockBlock = GoalUtil.dockBlockEntity(this.byteBuddy);
        if (dockBlock == null) {
            return;
        }
        if (dockBlock.tryClaim(serverLevel, ByteBuddyEntity.TaskType.PLANT, plantPos, this.byteBuddy.getUUID(), 120)) {
            this.byteBuddy.requestImmediatePlant(plantPos, plantState, seedItem);
        }
    }

    private boolean repath() {
        PathNavigation pathNavigation = this.byteBuddy.getNavigation();
        if (pathNavigation instanceof GroundPathNavigation) {
            Path path;
            GroundPathNavigation pathNavigation2 = (GroundPathNavigation)pathNavigation;
            if (this.repathRetries++ >= 2) {
                return false;
            }
            if (this.approachPos == null) {
                return false;
            }
            Level level = this.byteBuddy.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
            }
            if ((path = pathNavigation2.createPath(this.approachPos, 0)) == null) {
                return false;
            }
            pathNavigation2.moveTo(path, (double)this.byteBuddy.actionSpeedMultiplier());
            Level level2 = this.byteBuddy.level();
            if (level2 instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level2;
                GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
            }
            return true;
        }
        return false;
    }

    private boolean rotateAnchor() {
        if (this.approachPlans.isEmpty() || this.targetPos == null) {
            return false;
        }
        if (this.anchorRotateRetries >= 3) {
            return false;
        }
        int approaches = this.approachPlans.size();
        for (int tries = 0; tries < approaches; ++tries) {
            ServerLevel serverLevel;
            Vec3 anchor;
            this.anchorIndex = (this.anchorIndex + 1) % approaches;
            Approach approachCandidates = this.approachPlans.get(this.anchorIndex);
            BlockPos standPos = approachCandidates.targetPos();
            if (!ByteBuddyEntity.isStandableForMove(this.byteBuddy, this.byteBuddy.level(), standPos) || (anchor = approachCandidates.approachAnchor()) == null) continue;
            Path path = null;
            PathNavigation pathNavigation = this.byteBuddy.getNavigation();
            if (pathNavigation instanceof GroundPathNavigation) {
                GroundPathNavigation pathNavigation2 = (GroundPathNavigation)pathNavigation;
                path = pathNavigation2.createPath(standPos, 0);
            }
            if (path == null) continue;
            this.approachPos = standPos;
            this.targetAnchor = anchor;
            this.edgeAnchored = false;
            pathNavigation = this.byteBuddy.level();
            if (pathNavigation instanceof ServerLevel) {
                serverLevel = (ServerLevel)pathNavigation;
                GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
            }
            this.byteBuddy.getNavigation().moveTo(path, (double)this.byteBuddy.actionSpeedMultiplier());
            pathNavigation = this.byteBuddy.level();
            if (pathNavigation instanceof ServerLevel) {
                serverLevel = (ServerLevel)pathNavigation;
                GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
            }
            ++this.anchorRotateRetries;
            this.markProgress();
            this.lastMoveDistSq = Double.POSITIVE_INFINITY;
            this.lastAnchorDistSq = Double.POSITIVE_INFINITY;
            return true;
        }
        return false;
    }

    private void startTimedAnimation(int totalTicks, int startTick, @Nullable BlockPos fireAt, @Nullable BlockState preState) {
        Level level = this.byteBuddy.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.byteBuddy.getNavigation().stop();
            Vec3 deltaMovement = this.byteBuddy.getDeltaMovement();
            this.byteBuddy.setDeltaMovement(deltaMovement.x * 0.1, deltaMovement.y * 0.1, deltaMovement.z * 0.1);
            this.byteBuddy.setWorking(true);
            this.actionStarted = false;
            long currentTime = serverLevel.getGameTime();
            this.animationStart = currentTime + (long)Math.max(0, startTick);
            this.animationEnd = currentTime + (long)Math.max(1, totalTicks);
            this.firePos = fireAt;
            this.firePreState = preState;
            float speedMultiplier = Math.max(0.25f, this.byteBuddy.actionSpeedMultiplier());
            this.nextActionTick = currentTime + (long)Math.max(4, Math.round(20.0f / speedMultiplier));
            this.enterPhase(BotDebug.GoalPhase.ACTING, "animation: HARVEST fire@" + startTick + " end@" + totalTicks);
        }
    }

    private void tickTimedAnimation() {
        Level level = this.byteBuddy.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            long currentTime = serverLevel.getGameTime();
            if (!this.actionStarted && currentTime >= this.animationStart && this.firePos != null && this.firePreState != null) {
                this.actionStarted = true;
                BotDebug.log(this.byteBuddy, "HARVEST anim: now=" + currentTime + " start=" + this.animationStart + " end=" + this.animationEnd + " fired=" + this.actionStarted + " firePos=" + (this.firePos != null));
                this.performHarvest(this.firePos, this.firePreState);
            }
            if (this.currentPhase == BotDebug.GoalPhase.ACTING && this.animationEnd > 0L && currentTime >= this.animationEnd) {
                this.clearTimedAnimation();
                this.clearTarget();
                this.enterPhase(BotDebug.GoalPhase.IDLE, "HARVEST: complete");
            }
        }
    }

    private void clearTimedAnimation() {
        this.actionStarted = false;
        this.animationEnd = 0L;
        this.animationStart = 0L;
        this.byteBuddy.setWorking(false);
    }

    private boolean verifyClaimOrAbort(ServerLevel serverLevel, ByteBuddyEntity.TaskType taskType, @Nullable BlockPos claimedPos, @Nullable BlockPos currentTaskPos) {
        if (claimedPos == null) {
            return false;
        }
        if (currentTaskPos != null && !currentTaskPos.equals((Object)claimedPos)) {
            return false;
        }
        DockingStationBlockEntity dockBlock = GoalUtil.dockBlockEntity(this.byteBuddy);
        if (dockBlock == null) {
            return false;
        }
        boolean buddyReserved = dockBlock.isReservedBy(serverLevel, taskType, claimedPos, this.byteBuddy.getUUID());
        if (!buddyReserved) {
            BotDebug.log(this.byteBuddy, "lost " + String.valueOf((Object)taskType) + " claim at " + claimedPos.toShortString() + " \u2014 aborting");
            this.clearTarget();
            this.enterPhase(BotDebug.GoalPhase.IDLE, "claim lost; rescan");
        }
        return buddyReserved;
    }

    private void releaseHarvestClaim() {
        DockingStationBlockEntity dockBlock = GoalUtil.dockBlockEntity(this.byteBuddy);
        if (this.claimedHarvestPos != null && dockBlock != null) {
            dockBlock.releaseClaim(ByteBuddyEntity.TaskType.HARVEST, this.claimedHarvestPos, this.byteBuddy.getUUID());
        }
        this.claimedHarvestPos = null;
    }

    private void enterPhase(BotDebug.GoalPhase phase, String context) {
        Level level;
        this.currentPhase = phase;
        this.lastFail = BotDebug.FailReason.NONE;
        this.phaseStartedTick = this.phaseProgressTick = GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy);
        if (phase == BotDebug.GoalPhase.MOVING) {
            this.repathRetries = 0;
            this.anchorRotateRetries = 0;
            this.lastMoveDistSq = Double.POSITIVE_INFINITY;
            this.lastAnchorDistSq = Double.POSITIVE_INFINITY;
        }
        if (phase == BotDebug.GoalPhase.SEEKING) {
            this.repathRetries = 0;
            this.anchorRotateRetries = 0;
            this.targetReselectRetries = 0;
        }
        if (phase == BotDebug.GoalPhase.ACTING && (level = this.byteBuddy.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
        }
        BotDebug.log(this.byteBuddy, "FARMER: " + String.valueOf((Object)phase) + (String)(context.isEmpty() ? "" : " -> " + context));
    }

    private void clearTarget() {
        Level level = this.byteBuddy.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
        }
        this.releaseHarvestClaim();
        this.targetPos = null;
        this.approachPos = null;
        this.targetAnchor = null;
        this.edgeAnchored = false;
        this.firePos = null;
        this.firePreState = null;
        this.approachPlans = Collections.emptyList();
        this.anchorIndex = 0;
        this.lastMoveDistSq = Double.POSITIVE_INFINITY;
        this.lastAnchorDistSq = Double.POSITIVE_INFINITY;
    }

    private void failTask(BotDebug.FailReason reason, String context) {
        this.lastFail = reason;
        this.currentPhase = BotDebug.GoalPhase.IDLE;
        BotDebug.log(this.byteBuddy, "FARMER cannot start: " + String.valueOf((Object)reason) + (String)(context.isEmpty() ? "" : " (" + context + ")"));
        this.resetProgress();
        this.stop();
    }

    private void resetProgress() {
        this.lastMoveDistSq = Double.POSITIVE_INFINITY;
        this.lastAnchorDistSq = Double.POSITIVE_INFINITY;
        this.repathRetries = 0;
        this.anchorRotateRetries = 0;
        this.targetReselectRetries = 0;
        this.phaseStartedTick = this.phaseProgressTick = GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy);
    }

    private void markProgress() {
        this.phaseProgressTick = GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy);
    }

    private boolean stalledFor(int stallTime) {
        return GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy) - this.phaseProgressTick > (long)stallTime;
    }

    private boolean timedOut(int timeLimit) {
        return GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy) - this.phaseStartedTick > (long)timeLimit;
    }

    private record HarvestPlan(BlockPos crop, BlockPos targetPos, Path path) {
    }

    private record Approach(BlockPos targetPos, Vec3 approachAnchor, double distSq, Path path) {
    }
}

