/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.entity.entities;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.turtleboi.bytebuddies.block.entity.DockingStationBlockEntity;
import net.turtleboi.bytebuddies.entity.ai.AccessInventoryGoal;
import net.turtleboi.bytebuddies.entity.ai.BuddyFollowOwnerGoal;
import net.turtleboi.bytebuddies.entity.ai.BuddyPickUpItemGoal;
import net.turtleboi.bytebuddies.entity.ai.DepositToDockGoal;
import net.turtleboi.bytebuddies.entity.ai.RandomWaveAtFriendGoal;
import net.turtleboi.bytebuddies.entity.ai.combat.BuddyMeleeAttackGoal;
import net.turtleboi.bytebuddies.entity.ai.combat.BuddyOwnerHurtByTargetGoal;
import net.turtleboi.bytebuddies.entity.ai.combat.BuddyOwnerHurtTargetGoal;
import net.turtleboi.bytebuddies.entity.ai.farmer.HarvestGoal;
import net.turtleboi.bytebuddies.entity.ai.farmer.PlantGoal;
import net.turtleboi.bytebuddies.entity.ai.farmer.TillGoal;
import net.turtleboi.bytebuddies.entity.ai.miner.QuarryGoal;
import net.turtleboi.bytebuddies.entity.ai.storage.HaulerGoal;
import net.turtleboi.bytebuddies.init.ModTags;
import net.turtleboi.bytebuddies.item.ModItems;
import net.turtleboi.bytebuddies.item.custom.AugmentItem;
import net.turtleboi.bytebuddies.item.custom.BatteryItem;
import net.turtleboi.bytebuddies.item.custom.ClipboardItem;
import net.turtleboi.bytebuddies.item.custom.FloppyDiskItem;
import net.turtleboi.bytebuddies.screen.custom.menu.ByteBuddyDoubleMenu;
import net.turtleboi.bytebuddies.screen.custom.menu.ByteBuddyMenu;
import net.turtleboi.bytebuddies.screen.custom.menu.ByteBuddyTripleMenu;
import net.turtleboi.bytebuddies.util.AttributeModifierUtil;
import net.turtleboi.bytebuddies.util.BotDebug;
import net.turtleboi.bytebuddies.util.InventoryUtil;
import net.turtleboi.bytebuddies.util.ToolUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ByteBuddyEntity
extends PathfinderMob
implements IEnergyStorage {
    private final ItemStackHandler mainInv = new ItemStackHandler(36){

        public boolean isItemValid(int slot, ItemStack itemStack) {
            if (itemStack.isEmpty()) {
                return false;
            }
            return switch (slot) {
                case 0 -> ByteBuddyEntity.isAnyTool(itemStack);
                case 1, 2 -> {
                    int otherAugmentSlot;
                    ItemStack otherStack;
                    int otherAugmentSlot;
                    ItemStack otherStack;
                    if (!itemStack.is(ModTags.Items.AUGMENT)) {
                        yield false;
                    }
                    boolean isPlating = itemStack.is(ModTags.Items.PLATING);
                    if (isPlating && !(otherStack = this.getStackInSlot(otherAugmentSlot = slot == 1 ? 2 : 1)).isEmpty() && otherStack.is(ModTags.Items.PLATING)) {
                        yield false;
                    }
                    boolean isStorageCell = itemStack.is(ModTags.Items.STORAGE_CELL);
                    if (isStorageCell && !(otherStack = this.getStackInSlot(otherAugmentSlot = slot == 1 ? 2 : 1)).isEmpty() && otherStack.is(ModTags.Items.STORAGE_CELL)) {
                        yield false;
                    }
                    yield true;
                }
                case 3 -> InventoryUtil.isBattery(itemStack);
                case 4, 5, 6, 7 -> InventoryUtil.isFloppyDisk(itemStack);
                case 8 -> InventoryUtil.isClipboard(itemStack);
                case 9, 10, 11, 12, 13, 14, 15, 16, 17 -> true;
                case 18, 19, 20, 21, 22, 23, 24, 25, 26 -> {
                    if (ByteBuddyEntity.this.getStorageCellsExtraSlots() >= 9) {
                        yield true;
                    }
                    yield false;
                }
                case 27, 28, 29, 30, 31, 32, 33, 34, 35 -> {
                    if (ByteBuddyEntity.this.getStorageCellsExtraSlots() >= 18) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        protected int getStackLimit(int slot, ItemStack itemStack) {
            return switch (slot) {
                case 0, 1, 2, 3, 4, 5, 6, 7, 8 -> 1;
                default -> 64;
            };
        }

        protected void onContentsChanged(int slot) {
            if (!ByteBuddyEntity.this.level().isClientSide) {
                ByteBuddyEntity.this.refreshEffects();
                ByteBuddyEntity.this.computeChassis();
            }
        }
    };
    private final EnergyStorage energyStorage = new EnergyStorage(16000, 256, 256);
    private BuddyRole buddyRole = BuddyRole.NONE;
    private final Set<Goal> roleGoals = new HashSet<Goal>();
    @Nullable
    private BlockPos dockPos;
    private final FloppyDiskItem.DiskEffects diskEffects = new FloppyDiskItem.DiskEffects();
    private final AugmentItem.AugmentEffects augmentEffects = new AugmentItem.AugmentEffects();
    private static final ChassisMaterial defaultChassis = ChassisMaterial.ALUMINUM;
    private double augmentPrevX;
    private double augmentPrevY;
    private double augmentPrevZ;
    private double augmentMoveAccumMeters;
    private static final String momentumUntil = "dynamo_momentum_until";
    private boolean farmingEnabled = false;
    private boolean harvestEnabled = false;
    private boolean plantEnabled = false;
    private boolean tillEnabled = false;
    private boolean miningEnabled = false;
    private boolean quarryEnabled = false;
    private boolean haulingEnabled = false;
    private static final int baseCooldown = 20;
    private long cooldownUntil = 0L;
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.defineId(ByteBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Boolean> DATA_SLEEPING = SynchedEntityData.defineId(ByteBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_WAKING = SynchedEntityData.defineId(ByteBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_WAVING = SynchedEntityData.defineId(ByteBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_WORKING = SynchedEntityData.defineId(ByteBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_SLAMMING = SynchedEntityData.defineId(ByteBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_SLICING = SynchedEntityData.defineId(ByteBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_ROLE = SynchedEntityData.defineId(ByteBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_ENERGY = SynchedEntityData.defineId(ByteBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> CHASSIS_MATERIAL = SynchedEntityData.defineId(ByteBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> STORAGE_CELLS_TIER = SynchedEntityData.defineId(ByteBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DISPLAY_RGB = SynchedEntityData.defineId(ByteBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> MOOD_ID = SynchedEntityData.defineId(ByteBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> ATTACK_MODE = SynchedEntityData.defineId(ByteBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final NonNullList<ItemStack> armorItems = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    public AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    public final AnimationState sleepPoseState = new AnimationState();
    public final AnimationState wakeUpState = new AnimationState();
    private int wakingAnimationTimeout = 0;
    public final AnimationState workingState = new AnimationState();
    public final AnimationState slamState = new AnimationState();
    public final AnimationState sliceState = new AnimationState();
    public final AnimationState waveState = new AnimationState();
    private int openGuiCount = 0;
    @Nullable
    private UUID currentViewerId = null;
    @Nullable
    private PlantRequest pendingPlantRequest;
    private long replantHoldUntil = 0L;
    private Goal followOwnerGoal;
    private Goal ownerHurtBY;
    private Goal ownerHurt;
    private Goal hurtAnythingHostile;
    private Goal meleeAttackGoal;

    public ByteBuddyEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(OWNER_UUID, Optional.empty());
        builder.define(DATA_SLEEPING, (Object)true);
        builder.define(DATA_WAKING, (Object)false);
        builder.define(DATA_WAVING, (Object)false);
        builder.define(DATA_WORKING, (Object)false);
        builder.define(DATA_SLAMMING, (Object)false);
        builder.define(DATA_SLICING, (Object)false);
        builder.define(DATA_ROLE, (Object)BuddyRole.NONE.ordinal());
        builder.define(CHASSIS_MATERIAL, (Object)defaultChassis.ordinal());
        builder.define(STORAGE_CELLS_TIER, (Object)StorageCellsTier.NONE.ordinal());
        builder.define(DATA_ENERGY, (Object)0);
        builder.define(DISPLAY_RGB, (Object)DyeColor.CYAN.getFireworkColor());
        builder.define(MOOD_ID, (Object)Mood.NEUTRAL.ordinal());
        builder.define(ATTACK_MODE, (Object)AttackMode.PASSIVE.ordinal());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.MOVEMENT_SPEED, 0.24).add(Attributes.FOLLOW_RANGE, 18.0).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.ATTACK_SPEED, 1.6).add(Attributes.ATTACK_KNOCKBACK, 0.5).add(Attributes.ARMOR, 0.0).add(Attributes.ARMOR_TOUGHNESS, 0.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.05).add(Attributes.SAFE_FALL_DISTANCE, 2.147483647E9);
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (!this.level().isClientSide) {
            this.augmentPrevX = this.getX();
            this.augmentPrevY = this.getY();
            this.augmentPrevZ = this.getZ();
            this.refreshEffects();
            this.refreshCombatGoals();
        }
    }

    protected void checkInsideBlocks() {
    }

    public void reloadBuddy() {
        this.disableTasks();
        this.rebuildGoalsForRole();
        this.refreshEffects();
    }

    @NotNull
    public ItemStack getMainHandItem() {
        return this.mainInv.getStackInSlot(0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new AccessInventoryGoal(this));
        this.goalSelector.addGoal(0, (Goal)new GatedGoal(this, () -> this.canAct() && this.canSwim(), (Goal)new FloatGoal((Mob)this), 0));
        this.goalSelector.addGoal(1, (Goal)new GatedGoal(this, () -> this.canAct() && this.canPanic(), (Goal)new PanicGoal((PathfinderMob)this, 2.0), 0));
        this.goalSelector.addGoal(2, (Goal)new GatedGoal(this, () -> this.canAct() && this.getDock().isEmpty(), new BuddyFollowOwnerGoal(this, 1.05, 4.0, 16.0, true), 0));
        this.goalSelector.addGoal(5, (Goal)new GatedGoal(this, this::canAct, new BuddyPickUpItemGoal(this, 1.2, 6.0, 0.9, 10), 8));
        this.goalSelector.addGoal(6, (Goal)new GatedGoal(this, () -> this.canAct() && this.isInventoryFull(), new DepositToDockGoal(this), 0));
        this.goalSelector.addGoal(7, (Goal)new GatedGoal(this, this::canAct, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.75), 0));
        this.goalSelector.addGoal(8, (Goal)new GatedGoal(this, this::canAct, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f), 0));
        this.goalSelector.addGoal(9, (Goal)new GatedGoal(this, this::canAct, (Goal)new RandomLookAroundGoal((Mob)this), 0));
        this.goalSelector.addGoal(10, (Goal)new GatedGoal(this, this::canAct, new RandomWaveAtFriendGoal(this, 6.0, 120, 40), 0));
    }

    protected void updateWalkAnimation(float pPartialTick) {
        float f = this.getPose() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.walkAnimation.update(f, 0.2f);
    }

    public Optional<UUID> getOwnerUUID() {
        return (Optional)this.entityData.get(OWNER_UUID);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.entityData.set(OWNER_UUID, Optional.ofNullable(uuid));
    }

    public void clearOwner() {
        this.entityData.set(OWNER_UUID, Optional.empty());
    }

    public boolean hasOwner() {
        return ((Optional)this.entityData.get(OWNER_UUID)).isPresent();
    }

    public boolean isOwnedBy(@Nullable LivingEntity entity) {
        if (entity == null) {
            return false;
        }
        return this.getOwnerUUID().map(entity.getUUID()::equals).orElse(false);
    }

    public ServerPlayer getOwner(ServerLevel serverLevel) {
        Optional<UUID> id = this.getOwnerUUID();
        return id.map(buddyId -> serverLevel.getServer().getPlayerList().getPlayer(buddyId)).orElse(null);
    }

    public void setOwner(@Nullable Player player) {
        this.setOwnerUUID(player == null ? null : player.getUUID());
    }

    public boolean isEffectiveAi() {
        return super.isEffectiveAi() && this.canAct();
    }

    public boolean isSleeping() {
        return (Boolean)this.entityData.get(DATA_SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.entityData.set(DATA_SLEEPING, (Object)sleeping);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (sleeping) {
                this.armCooldown(serverLevel, Integer.MAX_VALUE);
                this.setMood(Mood.SLEEP);
                this.getNavigation().stop();
                this.setDeltaMovement(0.0, this.getDeltaMovement().y * 0.0, 0.0);
                this.setAggressive(false);
                this.setWorking(false);
                this.setSlamming(false);
                this.setMood(Mood.SLEEP);
            } else {
                this.armCooldown(serverLevel, 8);
                this.setMood(Mood.NEUTRAL);
            }
        }
    }

    public boolean isWaking() {
        return (Boolean)this.entityData.get(DATA_WAKING);
    }

    private void setWaking(boolean wakening) {
        this.entityData.set(DATA_WAKING, (Object)wakening);
    }

    public boolean isWaving() {
        return (Boolean)this.entityData.get(DATA_WAVING);
    }

    public void setWaving(boolean waving) {
        this.entityData.set(DATA_WAVING, (Object)waving);
    }

    public boolean isWorking() {
        return (Boolean)this.entityData.get(DATA_WORKING);
    }

    public void setWorking(boolean working) {
        this.entityData.set(DATA_WORKING, (Object)working);
    }

    public boolean isSlamming() {
        return (Boolean)this.entityData.get(DATA_SLAMMING);
    }

    public void setSlamming(boolean slamming) {
        this.entityData.set(DATA_SLAMMING, (Object)slamming);
    }

    public boolean isSlicing() {
        return (Boolean)this.entityData.get(DATA_SLICING);
    }

    public void setSlicing(boolean slicing) {
        this.entityData.set(DATA_SLICING, (Object)slicing);
    }

    public void setFarmingEnabled(boolean farmingEnabled) {
        this.farmingEnabled = farmingEnabled;
    }

    public void setHarvestEnabled(boolean harvestEnabled) {
        this.harvestEnabled = harvestEnabled;
    }

    public void setPlantEnabled(boolean plantingEnabled) {
        this.plantEnabled = plantingEnabled;
    }

    public void setTillEnabled(boolean tillingEnabled) {
        this.tillEnabled = tillingEnabled;
    }

    public boolean isFarmingEnabled() {
        return this.farmingEnabled;
    }

    public boolean isHarvestEnabled() {
        return this.farmingEnabled && this.harvestEnabled;
    }

    public boolean isPlantEnabled() {
        return this.farmingEnabled && this.plantEnabled;
    }

    public boolean isTillEnabled() {
        return this.farmingEnabled && this.tillEnabled;
    }

    public void setMiningEnabled(boolean miningEnabled) {
        this.miningEnabled = miningEnabled;
    }

    private boolean isMiningEnabled() {
        return this.miningEnabled;
    }

    public void setHaulingEnabled(boolean haulingEnabled) {
        this.haulingEnabled = haulingEnabled;
    }

    public boolean isHaulingEnabled() {
        return this.haulingEnabled;
    }

    public boolean cooldownActive(ServerLevel serverLevel) {
        return serverLevel.getGameTime() < this.cooldownUntil;
    }

    public void armCooldown(ServerLevel serverLevel, int ticks) {
        this.cooldownUntil = serverLevel.getGameTime() + (long)ticks;
    }

    public void setQuarryEnabled(boolean quarryEnabled) {
        this.quarryEnabled = quarryEnabled;
    }

    private boolean isQuarryEnabled() {
        return this.miningEnabled & this.quarryEnabled;
    }

    public boolean canAct() {
        return !this.isSleeping();
    }

    public boolean canPanic() {
        return this.getBuddyRole() != BuddyRole.COMBAT;
    }

    public AttackMode getAttackMode() {
        int i = (Integer)this.entityData.get(ATTACK_MODE);
        return AttackMode.values()[Mth.clamp((int)i, (int)0, (int)(AttackMode.values().length - 1))];
    }

    public void setAttackMode(AttackMode mode) {
        this.entityData.set(ATTACK_MODE, (Object)mode.ordinal());
        if (!this.level().isClientSide) {
            this.refreshCombatGoals();
        }
    }

    private static AttackMode cycleAttackMode(AttackMode attackMode, boolean backwards) {
        AttackMode[] attackValues = AttackMode.values();
        int attackModes = attackValues.length;
        int i = attackMode.ordinal();
        int next = backwards ? (i - 1 + attackModes) % attackModes : (i + 1) % attackModes;
        return attackValues[next];
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        SpawnGroupData spawnData = super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
        this.setSleeping(true);
        this.setNoAi(true);
        this.setPersistenceRequired();
        return spawnData;
    }

    public Iterable<ItemStack> getArmorSlots() {
        return this.armorItems;
    }

    public ItemStack getItemBySlot(EquipmentSlot slot) {
        if (slot == EquipmentSlot.MAINHAND) {
            return this.mainInv.getStackInSlot(0);
        }
        if (slot == EquipmentSlot.OFFHAND) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)this.armorItems.get(slot.getIndex());
    }

    public void setItemSlot(EquipmentSlot slot, ItemStack itemStack) {
        if (slot == EquipmentSlot.MAINHAND) {
            if (ByteBuddyEntity.isAnyTool(itemStack)) {
                ItemStack originalItemStack = this.mainInv.getStackInSlot(0);
                ItemStack newItemStack = itemStack.copy();
                newItemStack.setCount(1);
                this.mainInv.setStackInSlot(0, newItemStack);
                this.onEquipItem(slot, originalItemStack, newItemStack);
                return;
            }
            return;
        }
        if (slot == EquipmentSlot.OFFHAND) {
            return;
        }
        this.verifyEquippedItem(itemStack);
        this.onEquipItem(slot, (ItemStack)this.armorItems.set(slot.getIndex(), (Object)itemStack), itemStack);
    }

    @NotNull
    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    public int getHeldToolSlot() {
        return 0;
    }

    public ItemStack getHeldTool() {
        return this.mainInv.getStackInSlot(0);
    }

    public int getBatterySlot() {
        return 3;
    }

    public ItemStack getBattery() {
        return this.mainInv.getStackInSlot(3);
    }

    private boolean isInventoryFull() {
        ItemStackHandler inventory = this.getMainInv();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            if (!inventory.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean canFitInInventory(ItemStack incoming) {
        if (incoming == null || incoming.isEmpty()) {
            return false;
        }
        ItemStackHandler inv = this.getMainInv();
        ItemStack toInsert = incoming.copy();
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (!(toInsert = inv.insertItem(i, toInsert, true)).isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource damageSource, boolean recentlyHit) {
        super.dropCustomDeathLoot(level, damageSource, recentlyHit);
        this.dropAllFromHandler((IItemHandler)this.getMainInv());
    }

    private void dropAllFromHandler(IItemHandler itemHandler) {
        for (int slotIndex = 0; slotIndex < itemHandler.getSlots(); ++slotIndex) {
            ItemStack itemStack = itemHandler.getStackInSlot(slotIndex);
            if (itemStack.isEmpty()) continue;
            this.spawnAtLocation(itemStack.copy());
            if (itemHandler instanceof ItemStackHandler) {
                ItemStackHandler mutableHandler = (ItemStackHandler)itemHandler;
                mutableHandler.setStackInSlot(slotIndex, ItemStack.EMPTY);
                continue;
            }
            itemHandler.extractItem(slotIndex, itemStack.getCount(), false);
        }
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide) {
            int currentEnergy;
            if (this.isWaking() && this.wakingAnimationTimeout++ >= 56) {
                this.wakingAnimationTimeout = 0;
                this.setWaking(false);
            }
            if (this.tickCount % 10 == 0) {
                this.consumeEnergy(5);
            }
            if (this.tickCount % 20 == 0) {
                BatteryItem.buddyDrainBatteries(this);
                this.tickAugmentRuntime();
                if (this.supportAuraEnabled()) {
                    SupportAuras.tickSupportLattice(this);
                }
            }
            if ((currentEnergy = this.energyStorage.getEnergyStored()) != this.getSyncedEnergy()) {
                this.setSyncedEnergy(currentEnergy);
            }
            this.tickPropellerPhysics();
            this.tickDynamoMovement();
            this.tickMomentumExpiry();
            this.tickMagnet();
        } else {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        if (this.isSleeping()) {
            if (!this.sleepPoseState.isStarted()) {
                this.sleepPoseState.start(this.tickCount);
            }
        } else {
            this.sleepPoseState.stop();
        }
        if (!this.isSleeping()) {
            if (this.idleAnimationTimeout <= 0) {
                this.idleAnimationTimeout = 40;
                this.idleAnimationState.start(this.tickCount);
            } else {
                --this.idleAnimationTimeout;
            }
        }
        if (this.isWaking()) {
            if (!this.wakeUpState.isStarted()) {
                this.wakeUpState.start(this.tickCount);
                this.wakingAnimationTimeout = 56;
            } else if (this.wakingAnimationTimeout-- <= 0) {
                this.wakeUpState.stop();
            }
        } else {
            this.wakeUpState.stop();
        }
        if (this.isWaving()) {
            if (!this.waveState.isStarted()) {
                this.waveState.start(this.tickCount);
            }
        } else if (this.waveState.isStarted()) {
            this.waveState.stop();
        }
        if (this.isWorking()) {
            if (!this.workingState.isStarted()) {
                this.workingState.start(this.tickCount);
            }
        } else if (this.workingState.isStarted()) {
            this.workingState.stop();
        }
        if (this.isSlamming()) {
            if (!this.slamState.isStarted()) {
                this.slamState.start(this.tickCount);
            }
        } else if (this.slamState.isStarted()) {
            this.slamState.stop();
        }
        if (this.isSlicing()) {
            if (!this.sliceState.isStarted()) {
                this.sliceState.start(this.tickCount);
            }
        } else if (this.sliceState.isStarted()) {
            this.sliceState.stop();
        }
    }

    public void jumpFromGround() {
        super.jumpFromGround();
        if (this.canFly()) {
            Vec3 currentDelta = this.getDeltaMovement();
            double boostedY = currentDelta.y + 0.25;
            if (boostedY > 0.7) {
                boostedY = 0.7;
            }
            this.setDeltaMovement(currentDelta.x, boostedY, currentDelta.z);
            this.hasImpulse = true;
        }
    }

    public void onTaskSuccess(TaskType taskType, BlockPos blockPos) {
        FloppyDiskItem.DiskHooks.tryGiveByproduct(this, taskType, blockPos);
        FloppyDiskItem.DiskHooks.trySpawnHologram(this, taskType);
        this.addDynamoEffect();
    }

    public ChassisMaterial getChassisMaterial() {
        int ordinal = (Integer)this.entityData.get(CHASSIS_MATERIAL);
        int max = ChassisMaterial.values().length - 1;
        int clamped = Mth.clamp((int)ordinal, (int)0, (int)max);
        return ChassisMaterial.values()[clamped];
    }

    public void setChassisMaterial(ChassisMaterial material) {
        this.entityData.set(CHASSIS_MATERIAL, (Object)material.ordinal());
    }

    private void computeChassis() {
        ChassisMaterial current;
        if (this.level().isClientSide) {
            return;
        }
        ChassisMaterial computed = this.computeChassisTier();
        if (computed != (current = this.getChassisMaterial())) {
            this.setChassisMaterial(computed);
        }
    }

    private ChassisMaterial computeChassisTier() {
        ChassisMaterial chassisMaterial = ChassisMaterial.ALUMINUM;
        for (int i = 1; i < 3; ++i) {
            ItemStack stack = this.mainInv.getStackInSlot(i);
            if (stack.is((Item)ModItems.REINFORCED_CHARGED_STEEL_PLATING.get())) {
                chassisMaterial = ChassisMaterial.CHARGED_STEEL;
                continue;
            }
            if (stack.is((Item)ModItems.REINFORCED_NETHERITE_PLATING.get())) {
                if (chassisMaterial.ordinal() >= ChassisMaterial.NETHERITE.ordinal()) continue;
                chassisMaterial = ChassisMaterial.NETHERITE;
                continue;
            }
            if (stack.is((Item)ModItems.REINFORCED_STEEL_PLATING.get())) {
                if (chassisMaterial.ordinal() >= ChassisMaterial.STEEL.ordinal()) continue;
                chassisMaterial = ChassisMaterial.STEEL;
                continue;
            }
            if (!stack.is((Item)ModItems.REINFORCED_IRON_PLATING.get()) || chassisMaterial.ordinal() >= ChassisMaterial.IRON.ordinal()) continue;
            chassisMaterial = ChassisMaterial.IRON;
        }
        return chassisMaterial;
    }

    public StorageCellsTier getStorageCellsTier() {
        int ordinal = (Integer)this.entityData.get(STORAGE_CELLS_TIER);
        return StorageCellsTier.values()[Mth.clamp((int)ordinal, (int)0, (int)(StorageCellsTier.values().length - 1))];
    }

    public void setStorageCellsTier(StorageCellsTier tier) {
        this.entityData.set(STORAGE_CELLS_TIER, (Object)tier.ordinal());
    }

    public int getStorageCellsExtraSlots() {
        return switch (this.getStorageCellsTier().ordinal()) {
            case 1 -> 9;
            case 2, 3 -> 18;
            default -> 0;
        };
    }

    private StorageCellsTier computeStorageCellsTierFromMainInv() {
        StorageCellsTier best = StorageCellsTier.NONE;
        for (int slot = 1; slot <= 2; ++slot) {
            ItemStack storageCellInSlot = this.mainInv.getStackInSlot(slot);
            if (storageCellInSlot.isEmpty()) continue;
            if (storageCellInSlot.is((Item)ModItems.ENDERLINK_STORAGE_CELL.get())) {
                best = StorageCellsTier.ENDER_LINK;
                continue;
            }
            if (storageCellInSlot.is((Item)ModItems.ADVANCED_STORAGE_CELL.get())) {
                if (best.ordinal() >= StorageCellsTier.ADVANCED.ordinal()) continue;
                best = StorageCellsTier.ADVANCED;
                continue;
            }
            if (!storageCellInSlot.is((Item)ModItems.BASIC_STORAGE_CELL.get()) || best.ordinal() >= StorageCellsTier.BASIC.ordinal()) continue;
            best = StorageCellsTier.BASIC;
        }
        return best;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> dataAccessor) {
        super.onSyncedDataUpdated(dataAccessor);
        if (CHASSIS_MATERIAL.equals(dataAccessor)) {
            // empty if block
        }
    }

    public int getDisplayColorRGB() {
        return (Integer)this.entityData.get(DISPLAY_RGB);
    }

    public void setDisplayColorRGB(int rgb) {
        this.entityData.set(DISPLAY_RGB, (Object)(rgb & 0xFFFFFF));
    }

    public Mood getMood() {
        int id = (Integer)this.entityData.get(MOOD_ID);
        Mood[] values = Mood.values();
        return values[Math.max(0, Math.min(id, values.length - 1))];
    }

    public void setMood(Mood mood) {
        this.entityData.set(MOOD_ID, (Object)mood.ordinal());
    }

    private void cycleMood(boolean backwards) {
        Mood[] values = Mood.values();
        int n = values.length;
        int idx = this.getMood().ordinal();
        int next = (idx + (backwards ? -1 : 1) + n) % n;
        this.setMood(values[next]);
    }

    public ResourceLocation getMoodTexture() {
        return switch (this.getMood().ordinal()) {
            case 1 -> ByteBuddyEntity.resourceLocation("textures/entity/bytebuddy/faces/happy.png");
            case 2 -> ByteBuddyEntity.resourceLocation("textures/entity/bytebuddy/faces/annoyed.png");
            case 3 -> ByteBuddyEntity.resourceLocation("textures/entity/bytebuddy/faces/sleep.png");
            case 4 -> ByteBuddyEntity.resourceLocation("textures/entity/bytebuddy/faces/confused.png");
            case 5 -> ByteBuddyEntity.resourceLocation("textures/entity/bytebuddy/faces/crying.png");
            case 6 -> ByteBuddyEntity.resourceLocation("textures/entity/bytebuddy/faces/evil.png");
            case 7 -> ByteBuddyEntity.resourceLocation("textures/entity/bytebuddy/faces/pleased.png");
            case 8 -> ByteBuddyEntity.resourceLocation("textures/entity/bytebuddy/faces/sad.png");
            case 9 -> ByteBuddyEntity.resourceLocation("textures/entity/bytebuddy/faces/surprised.png");
            default -> ByteBuddyEntity.resourceLocation("textures/entity/bytebuddy/faces/neutral.png");
        };
    }

    private static ResourceLocation resourceLocation(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)path);
    }

    public void addAdditionalSaveData(CompoundTag nbtData) {
        super.addAdditionalSaveData(nbtData);
        this.getOwnerUUID().ifPresent(uuid -> nbtData.putUUID("Owner", uuid));
        nbtData.putInt("role", this.buddyRole.ordinal());
        if (this.dockPos != null) {
            nbtData.put("dockPos", NbtUtils.writeBlockPos((BlockPos)this.dockPos));
        }
        nbtData.putBoolean("Sleeping", this.isSleeping());
        nbtData.putBoolean("FarmingEnabled", this.farmingEnabled);
        nbtData.putBoolean("HarvestEnabled", this.harvestEnabled);
        nbtData.putBoolean("PlantEnabled", this.plantEnabled);
        nbtData.putBoolean("TillEnabled", this.tillEnabled);
        nbtData.putBoolean("MiningEnabled", this.miningEnabled);
        nbtData.putBoolean("QuarryEnabled", this.quarryEnabled);
        nbtData.putBoolean("HaulingEnabled", this.haulingEnabled);
        RegistryAccess provider = this.level().registryAccess();
        nbtData.put("MainInv", (Tag)this.mainInv.serializeNBT((HolderLookup.Provider)provider));
        nbtData.putInt("Energy", this.energyStorage.getEnergyStored());
        nbtData.putInt("ChassisMaterial", ((Integer)this.entityData.get(CHASSIS_MATERIAL)).intValue());
        nbtData.putInt("StorageTier", ((Integer)this.entityData.get(STORAGE_CELLS_TIER)).intValue());
        nbtData.putInt("AttackMode", ((Integer)this.entityData.get(ATTACK_MODE)).intValue());
        nbtData.putInt("DisplayRGB", ((Integer)this.entityData.get(DISPLAY_RGB)).intValue());
        int moodIdx = Mth.clamp((int)((Integer)this.entityData.get(MOOD_ID)), (int)0, (int)(Mood.values().length - 1));
        nbtData.putString("Mood", Mood.values()[moodIdx].name());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag nbtData) {
        int ordinal;
        super.readAdditionalSaveData(nbtData);
        if (nbtData.hasUUID("Owner")) {
            this.setOwnerUUID(nbtData.getUUID("Owner"));
        } else {
            this.clearOwner();
        }
        boolean sleeping = nbtData.getBoolean("Sleeping");
        this.setSleeping(sleeping);
        this.setNoAi(sleeping);
        int roleOrdinal = Mth.clamp((int)nbtData.getInt("role"), (int)0, (int)(BuddyRole.values().length - 1));
        this.buddyRole = BuddyRole.values()[roleOrdinal];
        this.entityData.set(DATA_ROLE, (Object)roleOrdinal);
        this.dockPos = NbtUtils.readBlockPos((CompoundTag)nbtData, (String)"dockPos").orElse(null);
        if (nbtData.contains("FarmingEnabled")) {
            this.farmingEnabled = nbtData.getBoolean("FarmingEnabled");
        }
        if (nbtData.contains("HarvestEnabled")) {
            this.harvestEnabled = nbtData.getBoolean("HarvestEnabled");
        }
        if (nbtData.contains("PlantEnabled")) {
            this.plantEnabled = nbtData.getBoolean("PlantEnabled");
        }
        if (nbtData.contains("TillEnabled")) {
            this.tillEnabled = nbtData.getBoolean("TillEnabled");
        }
        if (nbtData.contains("MiningEnabled")) {
            this.miningEnabled = nbtData.getBoolean("MiningEnabled");
        }
        if (nbtData.contains("QuarryEnabled")) {
            this.quarryEnabled = nbtData.getBoolean("QuarryEnabled");
        }
        if (nbtData.contains("HaulingEnabled")) {
            this.haulingEnabled = nbtData.getBoolean("HaulingEnabled");
        }
        RegistryAccess provider = this.level().registryAccess();
        if (nbtData.contains("MainInv")) {
            this.mainInv.deserializeNBT((HolderLookup.Provider)provider, nbtData.getCompound("MainInv"));
        }
        if (nbtData.contains("Energy")) {
            this.setEnergyUnsafe(nbtData.getInt("Energy"));
            this.setSyncedEnergy(this.energyStorage.getEnergyStored());
        }
        if (nbtData.contains("ChassisMaterial")) {
            ordinal = Mth.clamp((int)nbtData.getInt("ChassisMaterial"), (int)0, (int)(ChassisMaterial.values().length - 1));
            this.entityData.set(CHASSIS_MATERIAL, (Object)ordinal);
        } else {
            this.entityData.set(CHASSIS_MATERIAL, (Object)defaultChassis.ordinal());
        }
        if (nbtData.contains("StorageTier")) {
            ordinal = Mth.clamp((int)nbtData.getInt("StorageTier"), (int)0, (int)(StorageCellsTier.values().length - 1));
            this.entityData.set(STORAGE_CELLS_TIER, (Object)ordinal);
        } else {
            this.entityData.set(STORAGE_CELLS_TIER, (Object)StorageCellsTier.NONE.ordinal());
        }
        if (nbtData.contains("AttackMode")) {
            ordinal = Mth.clamp((int)nbtData.getInt("AttackMode"), (int)0, (int)(AttackMode.values().length - 1));
            this.entityData.set(ATTACK_MODE, (Object)ordinal);
        }
        if (nbtData.contains("DisplayRGB")) {
            this.entityData.set(DISPLAY_RGB, (Object)nbtData.getInt("DisplayRGB"));
        }
        int moodOrdinal = 0;
        if (nbtData.contains("Mood")) {
            try {
                moodOrdinal = Mood.valueOf(nbtData.getString("Mood")).ordinal();
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else if (nbtData.contains("MoodId")) {
            moodOrdinal = nbtData.getInt("MoodId");
        }
        this.entityData.set(MOOD_ID, (Object)Mth.clamp((int)moodOrdinal, (int)0, (int)(Mood.values().length - 1)));
        if (!this.level().isClientSide) {
            this.rebuildGoalsForRole();
            this.refreshEffects();
            this.refreshCombatGoals();
        }
    }

    @NotNull
    protected InteractionResult mobInteract(Player player, InteractionHand interactionHand) {
        if (!this.level().isClientSide) {
            if (this.isSleeping() && !this.hasOwner()) {
                this.setOwner(player);
                player.displayClientMessage((Component)Component.literal((String)("Buddy bound to " + player.getName().getString())), true);
                this.awaken();
                return InteractionResult.CONSUME;
            }
            ItemStack inHand = player.getItemInHand(interactionHand);
            ItemStack mainHand = player.getMainHandItem();
            ItemStack offHand = player.getOffhandItem();
            if (inHand.is(Items.WHEAT)) {
                this.setBuddyRole(BuddyRole.FARMER);
                inHand.shrink(1);
                this.setFarmingEnabled(true);
                this.setHarvestEnabled(true);
                this.setPlantEnabled(true);
                this.setTillEnabled(true);
                player.displayClientMessage((Component)Component.literal((String)("Set bot role to " + String.valueOf((Object)this.buddyRole))), true);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (inHand.is(Items.COBBLESTONE)) {
                this.setBuddyRole(BuddyRole.MINER);
                inHand.shrink(1);
                this.setMiningEnabled(true);
                this.setQuarryEnabled(true);
                player.displayClientMessage((Component)Component.literal((String)("Set bot role to " + String.valueOf((Object)this.buddyRole))), true);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (inHand.is(Items.CHEST)) {
                this.setBuddyRole(BuddyRole.STORAGE);
                inHand.shrink(1);
                this.setHaulingEnabled(true);
                player.displayClientMessage((Component)Component.literal((String)("Set bot role to " + String.valueOf((Object)this.buddyRole))), true);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (inHand.is(Items.SHIELD)) {
                this.setBuddyRole(BuddyRole.COMBAT);
                inHand.shrink(1);
                this.setHaulingEnabled(true);
                player.displayClientMessage((Component)Component.literal((String)("Set bot role to " + String.valueOf((Object)this.buddyRole))), true);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            Item item = inHand.getItem();
            if (item instanceof DyeItem) {
                DyeItem dyeItem = (DyeItem)item;
                DyeColor dye = dyeItem.getDyeColor();
                int rgb = dye.getFireworkColor();
                this.setDisplayColorRGB(rgb);
                if (!player.getAbilities().instabuild) {
                    inHand.shrink(1);
                }
                player.displayClientMessage((Component)Component.literal((String)("Buddy color set to: " + dye.getName())), true);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (inHand.is(Items.STICK)) {
                if (!this.level().isClientSide) {
                    boolean backwards = player.isShiftKeyDown();
                    this.cycleMood(backwards);
                    player.displayClientMessage((Component)Component.literal((String)("Face: " + this.getMood().name())), true);
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (inHand.getItem() instanceof SwordItem) {
                if (!this.level().isClientSide) {
                    boolean backwards = player.isShiftKeyDown();
                    AttackMode next = ByteBuddyEntity.cycleAttackMode(this.getAttackMode(), backwards);
                    this.setAttackMode(next);
                    player.displayClientMessage((Component)Component.literal((String)("Mode: " + next.name())), true);
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (!this.isSleeping() && !this.isWaking() && mainHand.isEmpty() && offHand.isEmpty() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ByteBuddyEntity.openStorageMenu(serverPlayer, this);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
        }
        return super.mobInteract(player, interactionHand);
    }

    public static void openStorageMenu(ServerPlayer serverPlayer, ByteBuddyEntity byteBuddy) {
        byteBuddy.refreshEffects();
        serverPlayer.openMenu((MenuProvider)new SimpleMenuProvider((containerId, inventory, player) -> {
            int slots = byteBuddy.getStorageCellsExtraSlots();
            if (slots == 18) {
                return new ByteBuddyTripleMenu(containerId, inventory, byteBuddy);
            }
            if (slots == 9) {
                return new ByteBuddyDoubleMenu(containerId, inventory, byteBuddy);
            }
            return new ByteBuddyMenu(containerId, inventory, byteBuddy);
        }, (Component)Component.literal((String)"ByteBuddy")), buf -> buf.writeInt(byteBuddy.getId()));
    }

    public void onMenuOpened(Player player) {
        if (player == null || player.level().isClientSide) {
            return;
        }
        ++this.openGuiCount;
        this.currentViewerId = player.getUUID();
    }

    public void onMenuClosed(Player player) {
        if (player == null || player.level().isClientSide) {
            return;
        }
        this.openGuiCount = Math.max(0, this.openGuiCount - 1);
        if (this.openGuiCount == 0) {
            this.currentViewerId = null;
        }
    }

    public boolean isInteracting() {
        return this.openGuiCount > 0;
    }

    @Nullable
    public Player getCurrentViewer() {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.currentViewerId == null) {
            return null;
        }
        return serverLevel.getPlayerByUUID(this.currentViewerId);
    }

    public void awaken() {
        if (!this.level().isClientSide && this.isSleeping()) {
            this.setSleeping(false);
            this.setNoAi(false);
            this.setWaking(true);
        }
    }

    public ItemStackHandler getMainInv() {
        return this.mainInv;
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    private void setEnergyUnsafe(int value) {
        try {
            Field storedEnergy = EnergyStorage.class.getDeclaredField("energy");
            storedEnergy.setAccessible(true);
            storedEnergy.setInt(this.energyStorage, Mth.clamp((int)value, (int)0, (int)this.energyStorage.getMaxEnergyStored()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setBuddyRole(BuddyRole newRole) {
        if (newRole == null) {
            return;
        }
        this.buddyRole = newRole;
        this.entityData.set(DATA_ROLE, (Object)newRole.getId());
        this.reloadBuddy();
    }

    public BuddyRole getBuddyRole() {
        return BuddyRole.byId((Integer)this.entityData.get(DATA_ROLE));
    }

    public void setBuddyRoleById(int id) {
        this.setBuddyRole(BuddyRole.byId(id));
    }

    public Optional<BlockPos> getDock() {
        return Optional.ofNullable(this.dockPos);
    }

    public void setDock(BlockPos blockPos) {
        this.dockPos = blockPos.immutable();
        if (!this.level().isClientSide) {
            BotDebug.log(this, "[ByteBuddies] bot id=" + this.getId() + "dock set to " + String.valueOf(blockPos));
        }
    }

    public void clearDock() {
        this.dockPos = null;
    }

    public void refreshEffects() {
        this.diskEffects.recomputeFrom(this.mainInv);
        FloppyDiskItem.DiskHooks.applyDiskHealthBoost(this, this.diskEffects.healthBoostPercent());
        this.augmentEffects.recomputeFrom(this.mainInv, this);
        StorageCellsTier tierBefore = this.getStorageCellsTier();
        StorageCellsTier tierAfter = this.computeStorageCellsTierFromMainInv();
        if (!this.level().isClientSide && tierBefore != tierAfter) {
            this.setStorageCellsTier(tierAfter);
            this.enforceStorageCapacity();
        }
    }

    private void enforceStorageCapacity() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ItemStack leftover;
            ItemStack stackInSlot;
            int slot;
            ServerLevel serverLevel = (ServerLevel)level;
            int extraSlots = this.getStorageCellsExtraSlots();
            int coreStart = 9;
            int coreEnd = 17;
            int firstUpgradeStart = 18;
            int firstUpgradeEnd = 26;
            int secondUpgradeStart = 27;
            int secondUpgradeEnd = 35;
            RangeItemHandler coreDestination = new RangeItemHandler(this.mainInv, 9, 17);
            RangeItemHandler firstUpgradeDestination = extraSlots >= 9 ? new RangeItemHandler(this.mainInv, 18, 26) : null;
            RangeItemHandler secondUpgradeDestination = extraSlots >= 18 ? new RangeItemHandler(this.mainInv, 27, 35) : null;
            Function<ItemStack, ItemStack> tryInsert = itemStack -> {
                if (itemStack.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                ItemStack leftoverItems = ItemHandlerHelper.insertItemStacked((IItemHandler)coreDestination, (ItemStack)itemStack, (boolean)false);
                if (leftoverItems.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                if (firstUpgradeDestination != null && (leftoverItems = ItemHandlerHelper.insertItemStacked((IItemHandler)firstUpgradeDestination, (ItemStack)leftoverItems, (boolean)false)).isEmpty()) {
                    return ItemStack.EMPTY;
                }
                if (secondUpgradeDestination != null) {
                    leftoverItems = ItemHandlerHelper.insertItemStacked((IItemHandler)secondUpgradeDestination, (ItemStack)leftoverItems, (boolean)false);
                }
                return leftoverItems;
            };
            if (extraSlots < 18) {
                for (slot = 27; slot <= 35; ++slot) {
                    stackInSlot = this.mainInv.getStackInSlot(slot);
                    if (stackInSlot.isEmpty()) continue;
                    this.mainInv.setStackInSlot(slot, ItemStack.EMPTY);
                    leftover = tryInsert.apply(stackInSlot.copy());
                    if (leftover.isEmpty()) continue;
                    Containers.dropItemStack((Level)serverLevel, (double)(this.getX() + 0.5), (double)(this.getY() + 0.75), (double)(this.getZ() + 0.5), (ItemStack)leftover);
                }
            }
            if (extraSlots < 9) {
                for (slot = 18; slot <= 26; ++slot) {
                    stackInSlot = this.mainInv.getStackInSlot(slot);
                    if (stackInSlot.isEmpty()) continue;
                    this.mainInv.setStackInSlot(slot, ItemStack.EMPTY);
                    leftover = tryInsert.apply(stackInSlot.copy());
                    if (leftover.isEmpty()) continue;
                    Containers.dropItemStack((Level)serverLevel, (double)(this.getX() + 0.5), (double)(this.getY() + 0.75), (double)(this.getZ() + 0.5), (ItemStack)leftover);
                }
            }
        }
    }

    public boolean fireImmune() {
        return this.augmentEffects.fireResistant();
    }

    public ItemStack getClipboardStack() {
        return this.mainInv.getStackInSlot(8);
    }

    @Nullable
    public BlockPos getFirstPos() {
        ItemStack clipboard = this.getClipboardStack();
        return ClipboardItem.getFirstPosition(clipboard).orElse(null);
    }

    @Nullable
    public BlockPos getSecondPos() {
        ItemStack clipboard = this.getClipboardStack();
        return ClipboardItem.getSecondPosition(clipboard).orElse(null);
    }

    public int effectiveRadius() {
        Optional<BlockPos> dockOpt = this.getDock();
        if (dockOpt.isEmpty()) {
            return 0;
        }
        BlockPos dockPos = dockOpt.get();
        BlockEntity blockEntity = this.level().getBlockEntity(dockPos);
        if (blockEntity instanceof DockingStationBlockEntity) {
            DockingStationBlockEntity dockBlock = (DockingStationBlockEntity)blockEntity;
            return (int)Math.ceil((float)dockBlock.dockBaseRadius * this.diskEffects.radiusMultiplier());
        }
        return 0;
    }

    public float actionSpeedMultiplier() {
        return this.diskEffects.actionSpeedMultiplier();
    }

    public float energyCostMultiplier() {
        return this.diskEffects.energyCostMultiplier();
    }

    public float toolWearMultiplier() {
        return this.diskEffects.toolWearMultiplier();
    }

    public float yieldBonusChance() {
        return this.diskEffects.yieldPrimaryChance();
    }

    public float byproductChance() {
        return this.diskEffects.secondaryByproductChance();
    }

    public boolean supportAuraEnabled() {
        return this.diskEffects.supportAuraEnabled();
    }

    public boolean hologramEnabled() {
        return this.diskEffects.hologramEnabled();
    }

    public float hologramChance() {
        return this.diskEffects.hologramChance();
    }

    public boolean consumeEnergy(int energyCost) {
        int adjustedEnergyCost = Math.max(1, Math.round((float)energyCost * this.energyCostMultiplier()));
        if (this.energyStorage.getEnergyStored() >= adjustedEnergyCost) {
            this.energyStorage.extractEnergy(adjustedEnergyCost, false);
            return true;
        }
        return false;
    }

    private void rebuildGoalsForRole() {
        for (Goal goals : this.roleGoals) {
            this.goalSelector.removeGoal(goals);
        }
        this.roleGoals.clear();
        switch (this.getBuddyRole().ordinal()) {
            case 1: {
                this.enableFarming();
                this.roleGoals.add(new GatedGoal(this, () -> this.canAct() && this.isPlantEnabled(), new PlantGoal(this), this.scaledCooldownTicks()));
                this.roleGoals.add(new GatedGoal(this, () -> this.canAct() && this.isHarvestEnabled(), new HarvestGoal(this), this.scaledCooldownTicks()));
                this.roleGoals.add(new GatedGoal(this, () -> this.canAct() && this.isTillEnabled(), new TillGoal(this), this.scaledCooldownTicks()));
                break;
            }
            case 2: {
                this.enableMining();
                this.roleGoals.add(new GatedGoal(this, () -> this.canAct() && this.isQuarryEnabled(), new QuarryGoal(this), this.scaledCooldownTicks()));
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.enabledStorage();
                this.roleGoals.add(new GatedGoal(this, () -> this.canAct() && this.isHaulingEnabled(), new HaulerGoal(this), this.scaledCooldownTicks()));
                break;
            }
        }
        int priority = 2;
        for (Goal goals : this.roleGoals) {
            this.goalSelector.addGoal(priority++, goals);
        }
    }

    private void disableTasks() {
        this.setFarmingEnabled(false);
        this.setHarvestEnabled(false);
        this.setPlantEnabled(false);
        this.setTillEnabled(false);
        this.setMiningEnabled(false);
        this.setQuarryEnabled(false);
        this.setHaulingEnabled(false);
    }

    private void enableFarming() {
        this.setFarmingEnabled(true);
        this.setHarvestEnabled(true);
        this.setPlantEnabled(true);
        this.setTillEnabled(true);
    }

    private void enableMining() {
        this.setMiningEnabled(true);
        this.setQuarryEnabled(true);
    }

    private void enabledStorage() {
        this.setHaulingEnabled(true);
    }

    public void requestImmediatePlant(BlockPos pos, BlockState state, Item seed) {
        this.pendingPlantRequest = new PlantRequest(pos, state, seed);
    }

    @Nullable
    public PlantRequest pollPlantRequest() {
        PlantRequest plantRequest = this.pendingPlantRequest;
        this.pendingPlantRequest = null;
        return plantRequest;
    }

    public void holdHarvestForReplant(ServerLevel serverLevel, int ticks) {
        this.replantHoldUntil = serverLevel.getGameTime() + (long)Math.max(1, ticks);
    }

    public boolean harvestOnHold(ServerLevel serverLevel) {
        return serverLevel.getGameTime() < this.replantHoldUntil;
    }

    private static List<BlockPos> pathBlockPositions(Path path, int from, int to) {
        int start = Math.max(0, from);
        int end = Math.min(path.getNodeCount(), to);
        ArrayList<BlockPos> out = new ArrayList<BlockPos>(Math.max(0, end - start));
        for (int i = start; i < end; ++i) {
            out.add(path.getNodePos(i));
        }
        return out;
    }

    private static List<BlockPos> pathAhead(Path path, int lookAhead) {
        int start = Math.min(path.getNextNodeIndex(), path.getNodeCount());
        int end = Math.min(start + Math.max(0, lookAhead), path.getNodeCount());
        return ByteBuddyEntity.pathBlockPositions(path, start, end);
    }

    public static void reservePathAhead(ByteBuddyEntity byteBuddy, ServerLevel serverLevel, Path path, int lookAhead) {
        Optional<BlockPos> dockOpt = byteBuddy.getDock();
        if (dockOpt.isEmpty()) {
            return;
        }
        BlockPos dockPos = dockOpt.get();
        BlockEntity blockEntity = serverLevel.getBlockEntity(dockPos);
        if (blockEntity instanceof DockingStationBlockEntity) {
            DockingStationBlockEntity dockBlock = (DockingStationBlockEntity)blockEntity;
            for (BlockPos node : ByteBuddyEntity.pathAhead(path, lookAhead)) {
                dockBlock.tryClaim(serverLevel, TaskType.MOVE, node, byteBuddy.getUUID(), 20);
            }
        }
    }

    public void renewPathAhead(ServerLevel serverLevel, Path path, int lookAhead) {
        Optional<BlockPos> dockOpt = this.getDock();
        if (dockOpt.isEmpty()) {
            return;
        }
        BlockPos dockPos = dockOpt.get();
        BlockEntity blockEntity = this.level().getBlockEntity(dockPos);
        if (blockEntity instanceof DockingStationBlockEntity) {
            DockingStationBlockEntity dockBlock = (DockingStationBlockEntity)blockEntity;
            for (BlockPos node : ByteBuddyEntity.pathAhead(path, lookAhead)) {
                dockBlock.renewClaim(serverLevel, TaskType.MOVE, node, this.getUUID(), 20);
            }
        }
    }

    public void releasePath(Path path) {
        Optional<BlockPos> dockOpt = this.getDock();
        if (dockOpt.isEmpty()) {
            return;
        }
        BlockPos dockPos = dockOpt.get();
        BlockEntity blockEntity = this.level().getBlockEntity(dockPos);
        if (blockEntity instanceof DockingStationBlockEntity) {
            DockingStationBlockEntity dockBlock = (DockingStationBlockEntity)blockEntity;
            for (int i = 0; i < path.getNodeCount(); ++i) {
                dockBlock.releaseClaim(TaskType.MOVE, path.getNodePos(i), this.getUUID());
            }
        }
    }

    public static boolean isStandableTerrain(Level level, BlockPos blockPos) {
        if (!level.isLoaded(blockPos)) {
            return false;
        }
        BlockState below = level.getBlockState(blockPos.below());
        boolean solidFloor = !below.getCollisionShape((BlockGetter)level, blockPos.below()).isEmpty();
        BlockState feet = level.getBlockState(blockPos);
        boolean feetFree = feet.getCollisionShape((BlockGetter)level, blockPos).isEmpty();
        BlockState head = level.getBlockState(blockPos.above());
        boolean headFree = head.getCollisionShape((BlockGetter)level, blockPos.above()).isEmpty();
        boolean noLiquid = level.getFluidState(blockPos).isEmpty() && level.getFluidState(blockPos.above()).isEmpty();
        return solidFloor && feetFree && headFree && noLiquid;
    }

    public static boolean isStandableForMove(ByteBuddyEntity byteBuddy, Level level, BlockPos blockPos) {
        if (!ByteBuddyEntity.isStandableTerrain(level, blockPos)) {
            return false;
        }
        if (!(level instanceof ServerLevel)) {
            return true;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos dockPos = byteBuddy.getDock().orElse(null);
        if (dockPos == null) {
            return true;
        }
        BlockEntity blockEntity = level.getBlockEntity(dockPos);
        if (!(blockEntity instanceof DockingStationBlockEntity)) {
            return true;
        }
        DockingStationBlockEntity dockBlock = (DockingStationBlockEntity)blockEntity;
        boolean reserved = dockBlock.isReserved(serverLevel, TaskType.MOVE, blockPos);
        if (!reserved) {
            return true;
        }
        return dockBlock.isReservedBy(serverLevel, TaskType.MOVE, blockPos, byteBuddy.getUUID());
    }

    public static boolean isAnyTool(ItemStack stack) {
        for (ToolUtil.ToolType toolType : ToolUtil.ToolType.values()) {
            if (toolType == ToolUtil.ToolType.EMPTY_HAND || !ToolUtil.matchesToolType(stack, toolType)) continue;
            return true;
        }
        return false;
    }

    public int receiveEnergy(int toReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(toReceive, simulate);
    }

    public int extractEnergy(int toExtract, boolean simulate) {
        return this.energyStorage.extractEnergy(toExtract, simulate);
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.energyStorage.canExtract();
    }

    public boolean canReceive() {
        return this.energyStorage.canReceive();
    }

    public void setSyncedEnergy(int value) {
        if (!this.level().isClientSide) {
            this.entityData.set(DATA_ENERGY, (Object)Math.max(0, value));
        }
    }

    public int getSyncedEnergy() {
        return (Integer)this.entityData.get(DATA_ENERGY);
    }

    private void onEnergyChanged() {
        if (!this.level().isClientSide) {
            this.setSyncedEnergy(this.energyStorage.getEnergyStored());
        }
    }

    private void tickAugmentRuntime() {
        if (this.augmentEffects.solarEnabled() && this.level().isDay() && this.level().canSeeSky(this.blockPosition())) {
            this.getEnergyStorage().receiveEnergy((int)Math.round(this.augmentEffects.solarChargePerSecond()), false);
        }
        if (this.augmentEffects.geothermalEnabled() && this.isNearHeatSource()) {
            this.getEnergyStorage().receiveEnergy((int)Math.round(this.augmentEffects.geothermalChargePerSecond()), false);
        }
        if (this.augmentEffects.arcWelderEnabled() && this.getHealth() < this.getMaxHealth() && this.getEnergyStorage().extractEnergy(5, true) > 0) {
            this.getEnergyStorage().extractEnergy(5, false);
            this.heal((float)this.augmentEffects.selfRepairPerSecond());
        }
    }

    private void tickPropellerPhysics() {
        if (this.canFly()) {
            boolean isOnGround = this.onGround();
            boolean isInWater = this.isInWater();
            boolean isInLava = this.isInLava();
            if (!(isOnGround || isInWater || isInLava)) {
                Vec3 currentDelta = this.getDeltaMovement();
                if (currentDelta.y < 0.0) {
                    double newY = currentDelta.y * 0.6;
                    if (newY < -0.12) {
                        newY = -0.12;
                    }
                    double newX = currentDelta.x * 0.98;
                    double newZ = currentDelta.z * 0.98;
                    this.setDeltaMovement(newX, newY, newZ);
                    this.hasImpulse = true;
                }
            }
        }
    }

    private boolean isNearHeatSource() {
        BlockPos origin = this.blockPosition();
        int radius = 2;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -1; dy <= 2; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos blockPos = origin.offset(dx, dy, dz);
                    BlockState blockState = this.level().getBlockState(blockPos);
                    if (blockState.is(Blocks.LAVA) || blockState.is(Blocks.LAVA_CAULDRON) || blockState.is(Blocks.MAGMA_BLOCK)) {
                        return true;
                    }
                    if (blockState.getBlock() instanceof AbstractFurnaceBlock && ((Boolean)blockState.getValue((Property)AbstractFurnaceBlock.LIT)).booleanValue()) {
                        return true;
                    }
                    if (!(blockState.getBlock() instanceof CampfireBlock) || !((Boolean)blockState.getValue((Property)CampfireBlock.LIT)).booleanValue()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void tickDynamoMovement() {
        if (!this.augmentEffects.dynamoEnabled()) {
            return;
        }
        double dx = this.getX() - this.augmentPrevX;
        double dy = this.getY() - this.augmentPrevY;
        double dz = this.getZ() - this.augmentPrevZ;
        this.augmentPrevX = this.getX();
        this.augmentPrevY = this.getY();
        this.augmentPrevZ = this.getZ();
        double moved = Math.sqrt(dx * dx + dy * dy + dz * dz);
        this.augmentMoveAccumMeters += moved;
        if (this.augmentMoveAccumMeters >= 1.0) {
            int meters = (int)Math.floor(this.augmentMoveAccumMeters);
            this.augmentMoveAccumMeters -= (double)meters;
            int charge = (int)Math.round(this.augmentEffects.dynamoChargePerMeter() * (double)meters);
            if (charge > 0) {
                this.getEnergyStorage().receiveEnergy(charge, false);
            }
        }
    }

    public void addDynamoEffect() {
        if (this.augmentEffects.dynamoEnabled()) {
            this.addMomentum(this.augmentEffects.momentumTicks(), this.augmentEffects.momentumSpeedMultiplier());
        }
    }

    private void addMomentum(int ticks, double speedMultiplier) {
        if (ticks <= 0) {
            return;
        }
        if (Math.abs(speedMultiplier - 1.0) <= 1.0E-4) {
            return;
        }
        AttributeModifierUtil.applyTransientModifier((LivingEntity)this, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, "dynamo_momentum", speedMultiplier - 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        this.getPersistentData().putInt(momentumUntil, this.tickCount + ticks);
    }

    private void tickMomentumExpiry() {
        int until = this.getPersistentData().getInt(momentumUntil);
        if (until > 0 && this.tickCount >= until) {
            AttributeModifierUtil.removeModifier((LivingEntity)this, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, "dynamo_momentum");
            this.getPersistentData().remove(momentumUntil);
        }
    }

    private void tickMagnet() {
        if (!this.augmentEffects.magnetEnabled()) {
            return;
        }
        if (this.level().isClientSide) {
            return;
        }
        double radius = this.augmentEffects.magnetRadiusBlocks();
        if (radius <= 0.0) {
            return;
        }
        AABB boundingBox = new AABB(this.getX() - radius, this.getY() - radius, this.getZ() - radius, this.getX() + radius, this.getY() + radius, this.getZ() + radius);
        List items = this.level().getEntitiesOfClass(ItemEntity.class, boundingBox);
        for (ItemEntity item : items) {
            Vec3 toBuddy;
            double distance;
            if (!item.isAlive() || (distance = (toBuddy = new Vec3(this.getX() - item.getX(), this.getY() + (double)(this.getBbHeight() / 2.0f) - item.getY(), this.getZ() - item.getZ())).length()) < 0.01) continue;
            if (distance <= 0.9) {
                this.pickupItem(item);
            }
            double pullFactor = Mth.clamp((double)((radius - distance) / radius), (double)0.08, (double)0.9);
            double accel = 0.1 * pullFactor;
            Vec3 push = toBuddy.normalize().scale(accel);
            Vec3 newVelocity = item.getDeltaMovement().add(push);
            double maxSpeed = 0.35;
            double lenSq = newVelocity.lengthSqr();
            if (lenSq > maxSpeed * maxSpeed) {
                newVelocity = newVelocity.normalize().scale(maxSpeed);
            }
            item.setDeltaMovement(newVelocity);
            item.hasImpulse = true;
        }
    }

    private void pickupItem(ItemEntity itemEntity) {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack stack = itemEntity.getItem();
        int before = stack.getCount();
        ItemStack leftover = InventoryUtil.mergeInto(this.getMainInv(), stack);
        int taken = before - leftover.getCount();
        if (taken <= 0) {
            return;
        }
        serverLevel.getChunkSource().broadcastAndSend((Entity)this, (Packet)new ClientboundTakeItemEntityPacket(itemEntity.getId(), this.getId(), taken));
        serverLevel.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, 1.0f + (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.4f);
        if (leftover.isEmpty()) {
            itemEntity.discard();
        } else {
            itemEntity.setItem(leftover);
        }
    }

    public void onMeleeHit(LivingEntity victim) {
        if (this.augmentEffects.shockOnHit()) {
            victim.hurt(this.damageSources().generic(), 2.0f);
            victim.knockback(0.4, this.getX() - victim.getX(), this.getZ() - victim.getZ());
        }
    }

    public float rangedInaccuracyMultiplier() {
        if (this.augmentEffects.gyroEnabled()) {
            return 0.8f;
        }
        return 1.0f;
    }

    public boolean canFly() {
        return this.augmentEffects.propellerEnabled();
    }

    public boolean canSwim() {
        return this.augmentEffects.aquaEnabled();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public boolean augmentEnderLinkEnabled() {
        return this.augmentEffects.enderLinkEnabled();
    }

    public AugmentItem.AugmentEffects getAugmentEffects() {
        return this.augmentEffects;
    }

    public int scaledCooldownTicks() {
        float speedMultiplier = Math.max(0.25f, this.actionSpeedMultiplier());
        return Math.max(4, Math.round(20.0f / speedMultiplier));
    }

    public void refreshCombatGoals() {
        if (this.followOwnerGoal != null) {
            this.goalSelector.removeGoal(this.followOwnerGoal);
        }
        if (this.ownerHurtBY != null) {
            this.targetSelector.removeGoal(this.ownerHurtBY);
        }
        if (this.ownerHurt != null) {
            this.targetSelector.removeGoal(this.ownerHurt);
        }
        if (this.hurtAnythingHostile != null) {
            this.targetSelector.removeGoal(this.hurtAnythingHostile);
        }
        if (this.meleeAttackGoal != null) {
            this.goalSelector.removeGoal(this.meleeAttackGoal);
        }
        boolean ableToFight = this.getBuddyRole() == BuddyRole.COMBAT;
        boolean hasOwner = this.getOwnerUUID().isPresent();
        boolean hasDock = this.getDock().isPresent();
        if (!ableToFight || !hasOwner || hasDock) {
            return;
        }
        this.followOwnerGoal = new BuddyFollowOwnerGoal(this, 1.05, 4.0, 18.0, true);
        this.goalSelector.addGoal(4, this.followOwnerGoal);
        this.meleeAttackGoal = new BuddyMeleeAttackGoal(this, 1.2, 2.0, true);
        this.goalSelector.addGoal(3, this.meleeAttackGoal);
        switch (this.getAttackMode().ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                this.ownerHurtBY = new BuddyOwnerHurtByTargetGoal(this);
                this.ownerHurt = new BuddyOwnerHurtTargetGoal(this);
                this.targetSelector.addGoal(1, this.ownerHurtBY);
                this.targetSelector.addGoal(2, this.ownerHurt);
                break;
            }
            case 2: {
                this.hurtAnythingHostile = new NearestAttackableTargetGoal((Mob)this, Monster.class, 10, true, false, this::isValidAggressiveTarget);
                this.targetSelector.addGoal(1, this.hurtAnythingHostile);
            }
        }
    }

    private boolean isValidAggressiveTarget(LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (this.getOwnerUUID().map(player.getUUID()::equals).orElse(false).booleanValue()) {
                return false;
            }
            return !player.isCreative() && !player.isSpectator();
        }
        return true;
    }

    public static enum BuddyRole {
        NONE(0),
        FARMER(1),
        MINER(2),
        COMBAT(3),
        POTION(4),
        STORAGE(5),
        ANIMAL(6);

        private final int id;
        private static final IntFunction<BuddyRole> BY_ID;

        private BuddyRole(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static BuddyRole byId(int id) {
            return BY_ID.apply(id);
        }

        static {
            BY_ID = ByIdMap.continuous(BuddyRole::getId, (Object[])BuddyRole.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }

    public static enum ChassisMaterial {
        ALUMINUM,
        IRON,
        STEEL,
        NETHERITE,
        CHARGED_STEEL;

    }

    public static enum StorageCellsTier {
        NONE,
        BASIC,
        ADVANCED,
        ENDER_LINK;

    }

    public static enum Mood {
        NEUTRAL,
        HAPPY,
        ANNOYED,
        SLEEP,
        CONFUSED,
        CRYING,
        EVIL,
        PLEASED,
        SAD,
        SURPRISED;

    }

    public static enum AttackMode {
        PASSIVE,
        ASSIST,
        AGGRESSIVE;

    }

    private static final class GatedGoal
    extends Goal {
        private final ByteBuddyEntity byteBuddy;
        private final BooleanSupplier requirement;
        private final Goal lockedGoal;
        private final int cooldownTicks;

        GatedGoal(ByteBuddyEntity byteBuddy, BooleanSupplier requirement, Goal lockedGoal, int cooldownTicks) {
            this.byteBuddy = byteBuddy;
            this.requirement = requirement;
            this.lockedGoal = lockedGoal;
            this.cooldownTicks = cooldownTicks;
            this.setFlags(lockedGoal.getFlags());
        }

        public boolean canUse() {
            Level level = this.byteBuddy.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!this.byteBuddy.canAct()) {
                    return false;
                }
                if (!this.requirement.getAsBoolean()) {
                    BotDebug.log(this.byteBuddy, "[ByteBuddy: " + this.byteBuddy.getId() + "] GatedGoal " + this.lockedGoal.getClass().getSimpleName() + ": requirement = false");
                    return false;
                }
                if (this.byteBuddy.cooldownActive(serverLevel)) {
                    BotDebug.log(this.byteBuddy, "[ByteBuddy: " + this.byteBuddy.getId() + "] GatedGoal " + this.lockedGoal.getClass().getSimpleName() + ": cooldown active");
                    return false;
                }
                boolean canUse = this.lockedGoal.canUse();
                if (!canUse) {
                    BotDebug.log(this.byteBuddy, "[ByteBuddy: " + this.byteBuddy.getId() + "] GatedGoal " + this.lockedGoal.getClass().getSimpleName() + ": inner canUse = false");
                }
                return canUse;
            }
            return false;
        }

        public boolean canContinueToUse() {
            Level level = this.byteBuddy.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!this.byteBuddy.canAct()) {
                    return false;
                }
                if (!this.requirement.getAsBoolean()) {
                    return false;
                }
                if (this.byteBuddy.cooldownActive(serverLevel)) {
                    return false;
                }
                boolean continueToUse = this.lockedGoal.canContinueToUse();
                if (!continueToUse) {
                    BotDebug.log(this.byteBuddy, "[ByteBuddy: " + this.byteBuddy.getId() + "] GatedGoal " + this.lockedGoal.getClass().getSimpleName() + ": canContinueToUse = false");
                }
                return continueToUse;
            }
            return false;
        }

        public void start() {
            this.lockedGoal.start();
        }

        public void tick() {
            Level level = this.byteBuddy.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!this.byteBuddy.canAct() || this.byteBuddy.cooldownActive(serverLevel) || !this.requirement.getAsBoolean()) {
                    this.lockedGoal.stop();
                    return;
                }
                this.lockedGoal.tick();
            }
        }

        public void stop() {
            this.lockedGoal.stop();
            Level level = this.byteBuddy.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.byteBuddy.armCooldown(serverLevel, this.cooldownTicks);
            }
        }

        public boolean isInterruptable() {
            return this.lockedGoal.isInterruptable();
        }
    }

    public static final class SupportAuras {
        public static void tickSupportLattice(ByteBuddyEntity byteBuddy) {
            Level level = byteBuddy.level();
            BlockPos buddyPos = byteBuddy.blockPosition();
            int radius = 5;
            if (level.random.nextFloat() < 0.1f) {
                BlockPos.betweenClosedStream((BlockPos)buddyPos.offset(-radius, -1, -radius), (BlockPos)buddyPos.offset(radius, 2, radius)).limit(24L).forEach(blockPos -> {
                    CropBlock cropBlock;
                    BlockState blockState = level.getBlockState(blockPos);
                    Block patt0$temp = blockState.getBlock();
                    if (patt0$temp instanceof CropBlock && !(cropBlock = (CropBlock)patt0$temp).isMaxAge(blockState) && level.random.nextFloat() < 0.05f) {
                        level.setBlock(blockPos, cropBlock.getStateForAge(cropBlock.getAge(blockState) + 1), 3);
                    }
                });
            }
            List players = level.getEntitiesOfClass(Player.class, new AABB(buddyPos).inflate(5.0));
            for (Player player : players) {
                player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 40, 0, true, false));
            }
            List byteBuddies = level.getEntitiesOfClass(ByteBuddyEntity.class, new AABB(buddyPos).inflate(5.0));
            for (ByteBuddyEntity buddyEntity : byteBuddies) {
                buddyEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 40, 0, true, false));
            }
        }
    }

    public static enum TaskType {
        HARVEST,
        FORESTRY,
        PLANT,
        TILL,
        MOVE,
        HAUL,
        MINE,
        COMBAT,
        BREW,
        DISTRIBUTE_POTION,
        SORT,
        PICKUP,
        DEPOSIT,
        SHEAR,
        MILK,
        BREED,
        WRANGLE,
        NONE;

    }

    private static final class RangeItemHandler
    implements IItemHandler {
        private final ItemStackHandler itemStackHandler;
        private final int startSlot;
        private final int endSlot;

        RangeItemHandler(ItemStackHandler itemStackHandler, int startSlot, int end) {
            this.itemStackHandler = itemStackHandler;
            this.startSlot = startSlot;
            this.endSlot = end;
        }

        public int getSlots() {
            return this.endSlot - this.startSlot + 1;
        }

        private int map(int slot) {
            return this.startSlot + slot;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            if (slot < 0 || slot >= this.getSlots()) {
                return ItemStack.EMPTY;
            }
            return this.itemStackHandler.getStackInSlot(this.map(slot));
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack itemStack, boolean simulate) {
            if (slot < 0 || slot >= this.getSlots()) {
                return itemStack;
            }
            return this.itemStackHandler.insertItem(this.map(slot), itemStack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot < 0 || slot >= this.getSlots()) {
                return ItemStack.EMPTY;
            }
            return this.itemStackHandler.extractItem(this.map(slot), amount, simulate);
        }

        public int getSlotLimit(int slot) {
            if (slot < 0 || slot >= this.getSlots()) {
                return 0;
            }
            return this.itemStackHandler.getSlotLimit(this.map(slot));
        }

        public boolean isItemValid(int slot, @NotNull ItemStack itemStack) {
            if (slot < 0 || slot >= this.getSlots()) {
                return false;
            }
            return this.itemStackHandler.isItemValid(this.map(slot), itemStack);
        }
    }

    public static final class PlantRequest {
        public final BlockPos blockPos;
        public final BlockState blockState;
        public final Item seedItem;

        public PlantRequest(BlockPos blockPos, BlockState blockState, Item seedItem) {
            this.blockPos = blockPos;
            this.blockState = blockState;
            this.seedItem = seedItem;
        }
    }
}

