/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.entity.entities;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import net.turtleboi.bytebuddies.item.custom.FloppyDiskItem;
import net.turtleboi.bytebuddies.util.InventoryUtil;
import org.jetbrains.annotations.NotNull;

public class HologramBuddyEntity
extends ByteBuddyEntity {
    @Nullable
    private UUID parentBuddyUUID = null;
    private int lifetimeTicks = 200;

    public HologramBuddyEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.noCulling = true;
        this.setInvulnerable(true);
    }

    @Nullable
    public static HologramBuddyEntity spawnFrom(ByteBuddyEntity sourceBuddy, EntityType<? extends ByteBuddyEntity> hologramType, BlockPos spawnAt, int lifetimeTicks) {
        ServerLevel serverLevel;
        HologramBuddyEntity candidate;
        HologramBuddyEntity created = null;
        Level level = sourceBuddy.level();
        if (level instanceof ServerLevel && (candidate = (HologramBuddyEntity)hologramType.create((Level)(serverLevel = (ServerLevel)level))) != null) {
            candidate.copyLightweightStateFrom(sourceBuddy);
            candidate.setLifetimeTicks(lifetimeTicks);
            candidate.setPos((double)spawnAt.getX() + 0.5, spawnAt.getY(), (double)spawnAt.getZ() + 0.5);
            sourceBuddy.getOwnerUUID().ifPresent(candidate::setOwnerUUID);
            candidate.setSleeping(false);
            serverLevel.addFreshEntity((Entity)candidate);
            created = candidate;
        }
        return created;
    }

    public void tick() {
        super.tick();
        if (this.lifetimeTicks > 0) {
            --this.lifetimeTicks;
        }
        if (this.lifetimeTicks <= 0) {
            this.transferInvOnExpire();
            this.discard();
        }
    }

    private void copyLightweightStateFrom(ByteBuddyEntity source) {
        this.setBuddyRole(source.getBuddyRole());
        this.setParentBuddyUUID(source.getUUID());
        if (source.getDock().isPresent()) {
            this.setDock(source.getDock().get());
        }
        this.setDisplayColorRGB(source.getDisplayColorRGB());
        this.setChassisMaterial(source.getChassisMaterial());
        this.setStorageCellsTier(source.getStorageCellsTier());
        this.setMood(source.getMood());
        this.setAttackMode(source.getAttackMode());
        this.copyInventory(source);
        this.receiveEnergy(16000, false);
        this.refreshEffects();
    }

    public void setLifetimeTicks(int ticks) {
        this.lifetimeTicks = Math.max(ticks, 1);
    }

    private void copyInventory(ByteBuddyEntity source) {
        int[] slotsToCopy;
        ItemStackHandler sourceHandler = source.getMainInv();
        ItemStackHandler targetHandler = this.getMainInv();
        for (int slotIndex : slotsToCopy = new int[]{0, 1, 2, 3, 8}) {
            ItemStack sourceStack = sourceHandler.getStackInSlot(slotIndex);
            if (!sourceStack.isEmpty()) {
                ItemStack copied = sourceStack.copy();
                int targetLimit = targetHandler.getSlotLimit(slotIndex);
                if (copied.getCount() > targetLimit) {
                    copied.setCount(targetLimit);
                }
                targetHandler.setStackInSlot(slotIndex, copied);
                continue;
            }
            targetHandler.setStackInSlot(slotIndex, ItemStack.EMPTY);
        }
    }

    public void setParentBuddyUUID(@Nullable UUID uuid) {
        this.parentBuddyUUID = uuid;
    }

    @Nullable
    private ByteBuddyEntity resolveParentBuddy(ServerLevel serverLevel) {
        Entity entity;
        ByteBuddyEntity parent = null;
        if (this.parentBuddyUUID != null && (entity = serverLevel.getEntity(this.parentBuddyUUID)) instanceof ByteBuddyEntity) {
            ByteBuddyEntity byteBuddy;
            parent = byteBuddy = (ByteBuddyEntity)entity;
        }
        return parent;
    }

    private void transferInvOnExpire() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            double dropZ;
            double dropY;
            double dropX;
            ItemStackHandler targetHandler;
            ServerLevel serverLevel = (ServerLevel)level;
            ByteBuddyEntity parent = this.resolveParentBuddy(serverLevel);
            ItemStackHandler sourceHandler = this.getMainInv();
            ItemStackHandler itemStackHandler = targetHandler = parent != null ? parent.getMainInv() : null;
            if (parent != null) {
                dropX = parent.getX() + 0.5;
                dropY = parent.getY() + 0.75;
                dropZ = parent.getZ() + 0.5;
            } else {
                dropX = this.getX() + 0.5;
                dropY = this.getY() + 0.75;
                dropZ = this.getZ() + 0.5;
            }
            for (int slotIndex = 9; slotIndex <= 35; ++slotIndex) {
                ItemStack toInsert;
                ItemStack stackInSlot = sourceHandler.getStackInSlot(slotIndex);
                if (stackInSlot.isEmpty()) continue;
                ItemStack leftover = toInsert = stackInSlot.copy();
                if (targetHandler != null) {
                    leftover = InventoryUtil.mergeInto(targetHandler, toInsert);
                }
                if (leftover.isEmpty()) {
                    sourceHandler.setStackInSlot(slotIndex, ItemStack.EMPTY);
                    continue;
                }
                sourceHandler.setStackInSlot(slotIndex, ItemStack.EMPTY);
                Containers.dropItemStack((Level)serverLevel, (double)dropX, (double)dropY, (double)dropZ, (ItemStack)leftover);
            }
        }
    }

    @Override
    @NotNull
    protected InteractionResult mobInteract(Player player, InteractionHand interactionHand) {
        return InteractionResult.CONSUME;
    }

    public boolean isPushable() {
        return false;
    }

    protected void doPush(Entity entity) {
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    protected void pushEntities() {
    }

    @Override
    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource damageSource, boolean recentlyHit) {
    }

    @NotNull
    public AABB getBoundingBoxForCulling() {
        return super.getBoundingBoxForCulling().inflate(0.25);
    }

    @Override
    public void onTaskSuccess(ByteBuddyEntity.TaskType taskType, BlockPos blockPos) {
        FloppyDiskItem.DiskHooks.tryGiveByproduct(this, taskType, blockPos);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("HoloLife", this.lifetimeTicks);
        if (this.parentBuddyUUID != null) {
            tag.putUUID("HoloParent", this.parentBuddyUUID);
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.lifetimeTicks = Math.max(1, tag.getInt("HoloLife"));
        if (tag.hasUUID("HoloParent")) {
            this.parentBuddyUUID = tag.getUUID("HoloParent");
        }
    }
}

