/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.item.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.turtleboi.bytebuddies.entity.ModEntities;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;

public class ByteBuddySpawnerItem
extends Item {
    public ByteBuddySpawnerItem(Item.Properties props) {
        super(props);
    }

    public InteractionResult useOn(UseOnContext useOnContext) {
        Level level = useOnContext.getLevel();
        Player player = useOnContext.getPlayer();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player == null) {
                return InteractionResult.FAIL;
            }
            BlockPos clickedPos = useOnContext.getClickedPos();
            Direction facingDirection = useOnContext.getClickedFace();
            BlockPos spawnPos = clickedPos.relative(facingDirection);
            double x = (double)spawnPos.getX() + 0.5;
            double y = spawnPos.getY();
            double z = (double)spawnPos.getZ() + 0.5;
            EntityType<ByteBuddyEntity> entityType = ModEntities.BYTEBUDDY.get();
            ByteBuddyEntity buddy = (ByteBuddyEntity)entityType.create((Level)serverLevel);
            if (buddy == null) {
                return InteractionResult.FAIL;
            }
            buddy.setPos(x, y, z);
            Vec3 toPlayer = player.position().subtract(buddy.position());
            float yaw = (float)(Mth.atan2((double)toPlayer.z, (double)toPlayer.x) * 57.29577951308232) - 90.0f;
            buddy.setYRot(yaw);
            buddy.setXRot(0.0f);
            buddy.setYBodyRot(yaw);
            buddy.setYHeadRot(yaw);
            buddy.setMood(ByteBuddyEntity.Mood.SLEEP);
            serverLevel.addFreshEntity((Entity)buddy);
            ItemStack stack = useOnContext.getItemInHand();
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS_NO_ITEM_USED;
    }
}

