/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.item.custom;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.turtleboi.bytebuddies.ByteBuddies;
import net.turtleboi.bytebuddies.block.custom.DockingStationBlock;
import net.turtleboi.bytebuddies.block.entity.DockingStationBlockEntity;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;

public class WrenchItem
extends Item {
    private static final String dockPos = "DockPos";
    private static final String dockDimension = "DockDim";

    public WrenchItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext useOnContext) {
        Level level = useOnContext.getLevel();
        BlockPos blockPos = useOnContext.getClickedPos();
        BlockState blockState = level.getBlockState(blockPos);
        ByteBuddies.LOGGER.info("[ByteBuddies] Wrench.useOn: side={} pos={} block={}", new Object[]{level.isClientSide ? "CLIENT" : "SERVER", blockPos, blockState.getBlock().getClass().getSimpleName()});
        Player player = useOnContext.getPlayer();
        ItemStack wrenchStack = useOnContext.getItemInHand();
        if (player != null && player.isShiftKeyDown()) {
            WrenchItem.clearDock(wrenchStack);
            if (!level.isClientSide) {
                ByteBuddies.LOGGER.info("[ByteBuddies] wrench: cleared link");
            }
            player.displayClientMessage((Component)Component.literal((String)"Cleared wrench link"), true);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (!level.isClientSide && blockState.getBlock() instanceof DockingStationBlock) {
            WrenchItem.setDock(wrenchStack, level, blockPos);
            ByteBuddies.LOGGER.info("[ByteBuddies] wrench: stored dock {} in {}", (Object)blockPos, (Object)level.dimension().location());
        }
        if (player != null) {
            player.displayClientMessage((Component)Component.literal((String)("Stored dock: " + blockPos.toShortString() + " (" + String.valueOf(level.dimension().location()) + ")")), true);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public InteractionResult interactLivingEntity(ItemStack wrenchStack, Player player, LivingEntity target, InteractionHand hand) {
        if (!(target instanceof ByteBuddyEntity)) {
            return InteractionResult.PASS;
        }
        ByteBuddyEntity byteBuddy = (ByteBuddyEntity)target;
        Level level = player.level();
        if (player.isShiftKeyDown()) {
            Optional<BlockPos> byteBuddyDock = byteBuddy.getDock();
            byteBuddy.clearDock();
            WrenchItem.sendMessage(player, "Bot unbound from dock" + (String)(byteBuddyDock.isPresent() ? " " + byteBuddyDock.get().toShortString() : ""));
            ByteBuddies.LOGGER.info("[ByteBuddies] wrench: unbound bot id={} from dock={}", (Object)byteBuddy.getId(), (Object)byteBuddyDock.map(Vec3i::toShortString).orElse("-"));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        Optional<GlobalPos> dockBlockPosOpt = WrenchItem.getDock(wrenchStack);
        if (dockBlockPosOpt.isEmpty()) {
            WrenchItem.sendMessage(player, "Wrench is not linked to a dock (right-click a Docking Station first)");
            ByteBuddies.LOGGER.warn("[ByteBuddies] wrench: no dock stored when attempting to bind");
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        GlobalPos dockBlockPos = dockBlockPosOpt.get();
        if (!dockBlockPos.dimension().equals(level.dimension())) {
            WrenchItem.sendMessage(player, "Dock is in different dimension: " + String.valueOf(dockBlockPos.dimension().location()));
            ByteBuddies.LOGGER.warn("[ByteBuddies] wrench: dim mismatch botDim={} dockDim={}", (Object)level.dimension().location(), (Object)dockBlockPos.dimension().location());
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (!(level.getBlockState(dockBlockPos.pos()).getBlock() instanceof DockingStationBlock)) {
            WrenchItem.sendMessage(player, "Stored dock is missing. Clear the wrench link and re-set it.");
            ByteBuddies.LOGGER.warn("[ByteBuddies] wrench: stored dock not found at {}", (Object)dockBlockPos.pos());
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        byteBuddy.setDock(dockBlockPos.pos());
        BlockEntity blockEntity = level.getBlockEntity(dockBlockPos.pos());
        if (blockEntity instanceof DockingStationBlockEntity) {
            DockingStationBlockEntity dockBlockEntity = (DockingStationBlockEntity)blockEntity;
            dockBlockEntity.addBoundBuddy(byteBuddy);
        }
        WrenchItem.sendMessage(player, "Bot bound to dock " + dockBlockPos.pos().toShortString());
        ByteBuddies.LOGGER.info("[ByteBuddies] wrench: bound bot id={} to dock {}", (Object)byteBuddy.getId(), (Object)dockBlockPos.pos());
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    private static void setDock(ItemStack wrenchStack, Level level, BlockPos blockPos) {
        CompoundTag nbtData = wrenchStack.get(DataComponents.CUSTOM_DATA) != null ? ((CustomData)wrenchStack.get(DataComponents.CUSTOM_DATA)).copyTag() : new CompoundTag();
        nbtData.putLong(dockPos, blockPos.asLong());
        nbtData.putString(dockDimension, level.dimension().location().toString());
        wrenchStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbtData));
    }

    private static Optional<GlobalPos> getDock(ItemStack wrenchStack) {
        CustomData dataComponents = (CustomData)wrenchStack.get(DataComponents.CUSTOM_DATA);
        if (dataComponents == null) {
            return Optional.empty();
        }
        CompoundTag nbtData = dataComponents.copyTag();
        if (!nbtData.contains(dockPos) || !nbtData.contains(dockDimension)) {
            return Optional.empty();
        }
        BlockPos blockPos = BlockPos.of((long)nbtData.getLong(dockPos));
        ResourceLocation dimensionLocation = ResourceLocation.parse((String)nbtData.getString(dockDimension));
        ResourceKey levelKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimensionLocation);
        return Optional.of(GlobalPos.of((ResourceKey)levelKey, (BlockPos)blockPos));
    }

    private static void clearDock(ItemStack wrenchStack) {
        CustomData dataComponents = (CustomData)wrenchStack.get(DataComponents.CUSTOM_DATA);
        if (dataComponents == null) {
            return;
        }
        CompoundTag nbtData = dataComponents.copyTag();
        nbtData.remove(dockPos);
        nbtData.remove(dockDimension);
        wrenchStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbtData));
    }

    private static void sendMessage(Player player, String message) {
        if (player != null) {
            player.displayClientMessage((Component)Component.literal((String)message), true);
        }
    }

    public void appendHoverText(ItemStack wrenchItem, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag nbtData;
        super.appendHoverText(wrenchItem, context, tooltip, flag);
        CustomData dataComponents = (CustomData)wrenchItem.get(DataComponents.CUSTOM_DATA);
        if (dataComponents != null && (nbtData = dataComponents.copyTag()).contains(dockPos) && nbtData.contains(dockDimension)) {
            BlockPos blockPos = BlockPos.of((long)nbtData.getLong(dockPos));
            String dimensionString = nbtData.getString(dockDimension);
            tooltip.add((Component)Component.literal((String)("Linked Dock: " + blockPos.toShortString() + " (" + dimensionString + ")")));
            return;
        }
        tooltip.add((Component)Component.literal((String)"Linked Dock: <none>"));
    }
}

