/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.network.payloads;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;

public record SleepData(int entityId, boolean asleep) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SleepData> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"sleep_data"));
    public static final StreamCodec<FriendlyByteBuf, SleepData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SleepData::entityId, (StreamCodec)ByteBufCodecs.BOOL, SleepData::asleep, SleepData::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleAsleepData(SleepData data, IPayloadContext context) {
        context.enqueueWork(() -> {
            ByteBuddyEntity byteBuddyEntity;
            ServerLevel serverLevel;
            Entity entity;
            Player player = context.player();
            Level patt0$temp = player.level();
            if (patt0$temp instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)patt0$temp).getEntity(data.entityId())) instanceof ByteBuddyEntity && (byteBuddyEntity = (ByteBuddyEntity)entity).isOwnedBy((LivingEntity)player)) {
                byteBuddyEntity.setSleeping(data.asleep);
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"bytebuddies.networking.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void setSleepingStatus(LivingEntity livingEntity, boolean asleep) {
        SleepData packet = new SleepData(livingEntity.getId(), asleep);
        PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

