/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.screen.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import net.turtleboi.bytebuddies.network.payloads.RoleData;
import net.turtleboi.bytebuddies.screen.custom.menu.ByteBuddyDoubleMenu;
import net.turtleboi.bytebuddies.screen.custom.widget.TinyIconButton;
import org.jetbrains.annotations.NotNull;

public class ByteBuddyDoubleScreen
extends AbstractContainerScreen<ByteBuddyDoubleMenu> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"textures/gui/bytebuddy_double_gui.png");
    private static final ResourceLocation GUI_ADDONS_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"textures/gui/gui_addons.png");
    private static final int energyX = 6;
    private static final int energyY = 64;
    private static final int energyWidth = 16;
    private static final int energyHeight = 52;
    private static final int energyEmptyU = 16;
    private static final int energyEmptyV = 0;
    private static final int energyFullU = 0;
    private static final int energyFullV = 0;
    private static final int buddyPreviewX = 105;
    private static final int buddyPreviewY = 6;
    private static final int buddyPreviewWidth = 38;
    private static final int buddyPreviewHeight = 38;
    private static final int buddyPreviewU = 105;
    private static final int buddyPreviewV = 6;
    private static final int healthX = 226;
    private static final int healthY = 64;
    private static final int healthWidth = 16;
    private static final int healthHeight = 52;
    private static final int healthEmptyU = 16;
    private static final int healthEmptyV = 52;
    private static final int healthFullU = 0;
    private static final int healthFullV = 52;
    private boolean debugEnergyOverride = false;
    private boolean debugHealthOverride = false;
    private double debugFillPct = 0.5;

    public ByteBuddyDoubleScreen(ByteBuddyDoubleMenu buddyMenu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)buddyMenu, inventory, title);
        this.imageWidth = 248;
        this.imageHeight = 227;
    }

    protected void init() {
        super.init();
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.empty(), button -> this.setFarmer(((ByteBuddyDoubleMenu)this.menu).byteBuddy)).bounds(x + 95, y + 124, 12, 12).tooltip(Tooltip.create((Component)Component.literal((String)"Farmer"))).build(TinyIconButton.buttonFactoryWithIcon(GUI_ADDONS_TEXTURE, 128, 128, 32, 0, null, new TinyIconButton.MiniIcon(GUI_ADDONS_TEXTURE, 128, 128, 8, 112, 8, 104, 2, 2))));
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.empty(), button -> this.setMiner(((ByteBuddyDoubleMenu)this.menu).byteBuddy)).bounds(x + 110, y + 124, 12, 12).tooltip(Tooltip.create((Component)Component.literal((String)"Miner"))).build(TinyIconButton.buttonFactoryWithIcon(GUI_ADDONS_TEXTURE, 128, 128, 32, 0, null, new TinyIconButton.MiniIcon(GUI_ADDONS_TEXTURE, 128, 128, 0, 112, 0, 104, 2, 2))));
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.empty(), button -> this.setHauler(((ByteBuddyDoubleMenu)this.menu).byteBuddy)).bounds(x + 126, y + 124, 12, 12).tooltip(Tooltip.create((Component)Component.literal((String)"Hauler"))).build(TinyIconButton.buttonFactoryWithIcon(GUI_ADDONS_TEXTURE, 128, 128, 32, 0, null, new TinyIconButton.MiniIcon(GUI_ADDONS_TEXTURE, 128, 128, 16, 112, 16, 104, 2, 2))));
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.empty(), button -> this.setFighter(((ByteBuddyDoubleMenu)this.menu).byteBuddy)).bounds(x + 141, y + 124, 12, 12).tooltip(Tooltip.create((Component)Component.literal((String)"Fighter"))).build(TinyIconButton.buttonFactoryWithIcon(GUI_ADDONS_TEXTURE, 128, 128, 32, 0, null, new TinyIconButton.MiniIcon(GUI_ADDONS_TEXTURE, 128, 128, 24, 112, 24, 104, 2, 2))));
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(GUI_TEXTURE, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.drawEnergyBar(guiGraphics, x + 6, y + 64);
        this.drawHealthBar(guiGraphics, x + 226, y + 64);
        this.drawBuddyPreview(guiGraphics, x + 105, y + 6, mouseX, mouseY);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.drawEnergyToolTip(guiGraphics, mouseX, mouseY);
        this.drawHealthToolTip(guiGraphics, mouseX, mouseY);
    }

    private void drawEnergyBar(GuiGraphics guiGraphics, int x, int y) {
        int filled;
        guiGraphics.blit(GUI_ADDONS_TEXTURE, x, y, 16.0f, 0.0f, 16, 52, 128, 128);
        if (this.debugEnergyOverride) {
            filled = Mth.clamp((int)((int)Math.round(this.debugFillPct * 52.0)), (int)0, (int)52);
        } else {
            long energy = this.getEnergyStoredSafe();
            long energyMax = Math.max(1L, this.getMaxEnergyStoredSafe());
            filled = Mth.clamp((int)((int)Math.round((double)energy * 52.0 / (double)energyMax)), (int)0, (int)52);
        }
        if (filled <= 0) {
            return;
        }
        int dy = 52 - filled;
        int drawY = y + dy;
        int vFill = 0 + dy;
        guiGraphics.blit(GUI_ADDONS_TEXTURE, x, drawY, 0.0f, (float)vFill, 16, filled, 128, 128);
    }

    private void drawEnergyToolTip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int absoluteX = this.leftPos + 6;
        int absoluteY = this.topPos + 64;
        if (this.isMouseInArea(mouseX, mouseY, absoluteX, absoluteY, 16, 52)) {
            long energy = this.getEnergyStoredSafe();
            long energyMax = Math.max(1L, this.getMaxEnergyStoredSafe());
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            MutableComponent line1 = Component.literal((String)"Energy: ");
            MutableComponent line2 = Component.literal((String)(numberFormat.format(energy) + " / " + numberFormat.format(energyMax) + " FE"));
            guiGraphics.renderTooltip(this.font, List.of(line1, line2), Optional.empty(), mouseX, mouseY);
        }
    }

    private long getEnergyStoredSafe() {
        try {
            return Math.max(0, ((ByteBuddyDoubleMenu)this.menu).getEnergyStored());
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    private long getMaxEnergyStoredSafe() {
        try {
            return Math.max(1, ((ByteBuddyDoubleMenu)this.menu).getMaxEnergyStored());
        }
        catch (Throwable t) {
            return 1L;
        }
    }

    private void drawHealthBar(GuiGraphics guiGraphics, int x, int y) {
        int filled;
        guiGraphics.blit(GUI_ADDONS_TEXTURE, x, y, 16.0f, 52.0f, 16, 52, 128, 128);
        if (this.debugHealthOverride) {
            filled = Mth.clamp((int)((int)Math.round(this.debugFillPct * 52.0)), (int)0, (int)52);
        } else {
            double health = this.getHealthSafe();
            double healthMax = Math.max(1.0, this.getMaxHealthSafe());
            filled = Mth.clamp((int)((int)Math.round(health * 52.0 / healthMax)), (int)0, (int)52);
        }
        if (filled <= 0) {
            return;
        }
        int dy = 52 - filled;
        int drawY = y + dy;
        int vFill = 52 + dy;
        guiGraphics.blit(GUI_ADDONS_TEXTURE, x, drawY, 0.0f, (float)vFill, 16, filled, 128, 128);
    }

    private void drawHealthToolTip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int absoluteX = this.leftPos + 226;
        int absoluteY = this.topPos + 64;
        if (this.isMouseInArea(mouseX, mouseY, absoluteX, absoluteY, 16, 52)) {
            double health = this.getHealthSafe();
            double healthMax = Math.max(1.0, this.getMaxHealthSafe());
            DecimalFormat decimalFormat = new DecimalFormat("#.##");
            MutableComponent line1 = Component.literal((String)"Health: ");
            MutableComponent line2 = Component.literal((String)(decimalFormat.format(health) + " / " + decimalFormat.format(healthMax)));
            guiGraphics.renderTooltip(this.font, List.of(line1, line2), Optional.empty(), mouseX, mouseY);
        }
    }

    private double getHealthSafe() {
        try {
            return Math.max(0.0, ((ByteBuddyDoubleMenu)this.menu).getHealth());
        }
        catch (Throwable t) {
            return 0.0;
        }
    }

    private double getMaxHealthSafe() {
        try {
            return Math.max(1.0, ((ByteBuddyDoubleMenu)this.menu).getMaxHealth());
        }
        catch (Throwable t) {
            return 1.0;
        }
    }

    private boolean isMouseInArea(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    private void drawBuddyPreview(GuiGraphics guiGraphics, int previewX, int previewY, int mouseX, int mouseY) {
        guiGraphics.blit(GUI_TEXTURE, previewX, previewY, 105.0f, 6.0f, 38, 38, 256, 256);
        LivingEntity entity = this.getPreviewEntity();
        if (entity == null) {
            return;
        }
        int x2 = previewX + 38;
        int y2 = previewY + 38;
        float entityHeight = Math.max(0.6f, entity.getBbHeight());
        float targetScale = 24.699999f;
        int scale = Math.max(8, Mth.floor((float)(24.699999f / entityHeight)));
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)previewX, (int)previewY, (int)x2, (int)y2, (int)scale, (float)0.1f, (float)mouseX, (float)mouseY, (LivingEntity)entity);
    }

    private LivingEntity getPreviewEntity() {
        try {
            return ((ByteBuddyDoubleMenu)this.menu).getByteBuddy();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private void setFarmer(ByteBuddyEntity byteBuddy) {
        RoleData.setBuddyRole((LivingEntity)byteBuddy, 1);
    }

    private void setMiner(ByteBuddyEntity byteBuddy) {
        RoleData.setBuddyRole((LivingEntity)byteBuddy, 2);
    }

    private void setHauler(ByteBuddyEntity byteBuddy) {
        RoleData.setBuddyRole((LivingEntity)byteBuddy, 5);
    }

    private void setFighter(ByteBuddyEntity byteBuddy) {
        RoleData.setBuddyRole((LivingEntity)byteBuddy, 3);
    }
}

