/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.screen.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.NumberFormat;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import net.turtleboi.bytebuddies.network.payloads.ReloadData;
import net.turtleboi.bytebuddies.network.payloads.SleepData;
import net.turtleboi.bytebuddies.network.payloads.TeleportData;
import net.turtleboi.bytebuddies.screen.custom.menu.DockingStationMenu;
import net.turtleboi.bytebuddies.screen.custom.widget.TinyIconButton;
import org.jetbrains.annotations.NotNull;

public class DockingStationScreen
extends AbstractContainerScreen<DockingStationMenu> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"textures/gui/docking_station_gui.png");
    private static final ResourceLocation GUI_ADDONS_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"textures/gui/gui_addons.png");
    private static final int energyX = 6;
    private static final int energyY = 53;
    private static final int energyWidth = 16;
    private static final int energyHeight = 52;
    private static final int energyEmptyU = 16;
    private static final int energyEmptyV = 0;
    private static final int energyFullU = 0;
    private static final int energyFullV = 0;
    private static final int buddyPreviewX = 71;
    private static final int buddyPreviewY = 6;
    private static final int buddyPreviewWidth = 38;
    private static final int buddyPreviewHeight = 38;
    private static final int buddyPreviewU = 71;
    private static final int buddyPreviewV = 6;
    private static final int infoX = 114;
    private static final int infoY = 7;
    private static final int infoW = 54;
    private static final int infoH = 22;
    private boolean debugEnergyOverride = false;
    private double debugFillPct = 0.5;
    private int selected = 0;
    private Button previousButton;
    private Button nextButton;
    private Button sleepButton;
    private Button restartButton;
    private Button teleportButton;

    public DockingStationScreen(DockingStationMenu dockingStationMenu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)dockingStationMenu, inventory, title);
        this.imageWidth = 240;
        this.imageHeight = 227;
    }

    protected void init() {
        super.init();
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        int bx = x + 71;
        int by = y + 6;
        this.previousButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"<"), button -> this.cycleBuddy(-1)).bounds(bx - 20, by + 19 - 6, 12, 12).build());
        this.nextButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)">"), button -> this.cycleBuddy(1)).bounds(bx + 38 + 68, by + 19 - 6, 12, 12).build());
        this.sleepButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.empty(), b -> this.setSleepStatus(Objects.requireNonNull(((DockingStationMenu)this.menu).getBuddyByIndexClient(this.selected)))).bounds(bx + 44, by + 26, 12, 12).tooltip(Tooltip.create((Component)Component.literal((String)"Sleep Buddy"))).build(TinyIconButton.buttonFactory(GUI_ADDONS_TEXTURE, 128, 128, 32, 24, this::isSleepLocked)));
        this.restartButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.empty(), b -> this.reloadBuddy(Objects.requireNonNull(((DockingStationMenu)this.menu).getBuddyByIndexClient(this.selected)))).bounds(bx + 64, by + 26, 12, 12).tooltip(Tooltip.create((Component)Component.literal((String)"Reset Job"))).build(TinyIconButton.buttonFactory(GUI_ADDONS_TEXTURE, 128, 128, 32, 72, this::isRestartLocked)));
        this.teleportButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.empty(), b -> this.teleportBuddy(Objects.requireNonNull(((DockingStationMenu)this.menu).getBuddyByIndexClient(this.selected)))).bounds(bx + 84, by + 26, 12, 12).tooltip(Tooltip.create((Component)Component.literal((String)"Teleport to Dock"))).build(TinyIconButton.buttonFactory(GUI_ADDONS_TEXTURE, 128, 128, 32, 96, this::isTeleportLocked)));
        this.updateNavState();
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(GUI_TEXTURE, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.drawEnergyBar(guiGraphics, x + 6, y + 53);
        this.drawBuddyPreview(guiGraphics, x + 71, y + 6, mouseX, mouseY);
        this.drawBuddyInfo(guiGraphics, x + 114, y + 7);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.drawEnergyToolTip(guiGraphics, mouseX, mouseY);
    }

    private void drawEnergyBar(GuiGraphics guiGraphics, int x, int y) {
        int filled;
        guiGraphics.blit(GUI_ADDONS_TEXTURE, x, y, 16.0f, 0.0f, 16, 52, 128, 128);
        if (this.debugEnergyOverride) {
            filled = Mth.clamp((int)((int)Math.round(this.debugFillPct * 52.0)), (int)0, (int)52);
        } else {
            long energy = this.getEnergyStoredSafe();
            long energyMax = Math.max(1L, this.getMaxEnergyStoredSafe());
            filled = Mth.clamp((int)((int)Math.round((double)energy * 52.0 / (double)energyMax)), (int)0, (int)52);
        }
        if (filled <= 0) {
            return;
        }
        int dy = 52 - filled;
        int drawY = y + dy;
        int vFill = 0 + dy;
        guiGraphics.blit(GUI_ADDONS_TEXTURE, x, drawY, 0.0f, (float)vFill, 16, filled, 128, 128);
    }

    private void drawEnergyToolTip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int absoluteX = this.leftPos + 6;
        int absoluteY = this.topPos + 53;
        if (this.isMouseInArea(mouseX, mouseY, absoluteX, absoluteY, 16, 52)) {
            long energy = this.getEnergyStoredSafe();
            long energyMax = Math.max(1L, this.getMaxEnergyStoredSafe());
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            MutableComponent line1 = Component.literal((String)(numberFormat.format(energy) + " / " + numberFormat.format(energyMax) + " FE"));
            guiGraphics.renderTooltip(this.font, List.of(line1), Optional.empty(), mouseX, mouseY);
        }
    }

    private long getEnergyStoredSafe() {
        try {
            return Math.max(0, ((DockingStationMenu)this.menu).getEnergyStored());
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    private long getMaxEnergyStoredSafe() {
        try {
            return Math.max(1, ((DockingStationMenu)this.menu).getMaxEnergyStored());
        }
        catch (Throwable t) {
            return 1L;
        }
    }

    private boolean isMouseInArea(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    private void drawBuddyPreview(GuiGraphics guiGraphics, int previewX, int previewY, int mouseX, int mouseY) {
        guiGraphics.blit(GUI_TEXTURE, previewX, previewY, 71.0f, 6.0f, 38, 38, 256, 256);
        ByteBuddyEntity entity = ((DockingStationMenu)this.menu).getBuddyByIndexClient(this.selected);
        if (entity == null) {
            return;
        }
        int x2 = previewX + 38;
        int y2 = previewY + 38;
        float entityHeight = Math.max(0.6f, entity.getBbHeight());
        float targetScale = 24.699999f;
        int scale = Math.max(8, Mth.floor((float)(24.699999f / entityHeight)));
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)previewX, (int)previewY, (int)x2, (int)y2, (int)scale, (float)0.1f, (float)mouseX, (float)mouseY, (LivingEntity)entity);
    }

    private void drawBuddyInfo(GuiGraphics guiGraphics, int boxX, int boxY) {
        String string;
        ByteBuddyEntity entity = ((DockingStationMenu)this.menu).getBuddyByIndexClient(this.selected);
        if (entity == null) {
            return;
        }
        String name = entity.getName().getString();
        if (entity instanceof ByteBuddyEntity) {
            ByteBuddyEntity byteBuddy = entity;
            string = byteBuddy.getBuddyRole().name();
        } else {
            string = "Unknown";
        }
        String role = string;
        BlockPos pos = entity.blockPosition();
        String coords = "(" + pos.getX() + "," + pos.getY() + "," + pos.getZ() + ")";
        String[] lines = new String[]{name, "Role: " + role, coords};
        Objects.requireNonNull(this.font);
        int lineHeight = 9;
        int rawHeight = lines.length * lineHeight;
        int maxWidth = 0;
        for (String string2 : lines) {
            maxWidth = Math.max(maxWidth, this.font.width(string2));
        }
        if (maxWidth == 0 || rawHeight == 0) {
            return;
        }
        float scaleX = 54.0f / (float)maxWidth;
        float scaleY = 22.0f / (float)rawHeight;
        float scale = Math.min(scaleX, scaleY);
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.translate((float)boxX, (float)boxY, 0.0f);
        pose.scale(scale, scale, 1.0f);
        int drawAreaWScaled = Mth.floor((float)(54.0f / scale));
        int drawAreaHScaled = Mth.floor((float)(22.0f / scale));
        int y = Math.max(0, (drawAreaHScaled - rawHeight) / 2);
        for (String string3 : lines) {
            int fontWidth = this.font.width(string3);
            int x = (drawAreaWScaled - fontWidth) / 2;
            guiGraphics.drawString(this.font, string3, x, y, 0xFFFFFF, false);
            y += lineHeight;
        }
        pose.popPose();
    }

    private void cycleBuddy(int delta) {
        int count = ((DockingStationMenu)this.menu).getBuddyCount();
        if (count <= 0) {
            return;
        }
        this.selected = (this.selected + delta) % count;
        if (this.selected < 0) {
            this.selected += count;
        }
        this.updateNavState();
    }

    private void setSleepStatus(ByteBuddyEntity byteBuddyEntity) {
        boolean asleep = byteBuddyEntity.isSleeping();
        SleepData.setSleepingStatus((LivingEntity)byteBuddyEntity, !asleep);
    }

    private void reloadBuddy(ByteBuddyEntity byteBuddyEntity) {
        ReloadData.reloadBuddy((LivingEntity)byteBuddyEntity);
    }

    private void teleportBuddy(ByteBuddyEntity byteBuddyEntity) {
        TeleportData.teleportBuddy((LivingEntity)byteBuddyEntity, (double)((DockingStationMenu)this.menu).dockBlock.getBlockPos().getX() + 0.5, ((DockingStationMenu)this.menu).dockBlock.getBlockPos().getY() + 1, (double)((DockingStationMenu)this.menu).dockBlock.getBlockPos().getZ() + 0.5);
    }

    private void updateNavState() {
        boolean enable;
        int count = ((DockingStationMenu)this.menu).getBuddyCount();
        boolean bl = enable = count > 1;
        if (this.previousButton != null) {
            this.previousButton.active = enable;
        }
        if (this.nextButton != null) {
            this.nextButton.active = enable;
        }
        this.sleepButton.active = count > 0;
        this.restartButton.active = count > 0;
        boolean bl2 = this.teleportButton.active = count > 0;
        if (count == 0) {
            this.selected = 0;
        } else if (this.selected >= count) {
            this.selected = count - 1;
        }
    }

    private boolean isSleepLocked() {
        return ((DockingStationMenu)this.menu).getBuddyByIndexClient(this.selected) == null;
    }

    private boolean isRestartLocked() {
        return ((DockingStationMenu)this.menu).getBuddyByIndexClient(this.selected) == null;
    }

    private boolean isTeleportLocked() {
        return ((DockingStationMenu)this.menu).getBuddyByIndexClient(this.selected) == null || this.getEnergyStoredSafe() < 50L;
    }
}

