/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.screen.custom.menu;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.turtleboi.bytebuddies.block.entity.DockingStationBlockEntity;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import net.turtleboi.bytebuddies.screen.ModMenuTypes;
import org.jetbrains.annotations.NotNull;

public class DockingStationMenu
extends AbstractContainerMenu {
    public final DockingStationBlockEntity dockBlock;
    public final Level level;
    private final IntList buddyEntityIds = new IntArrayList();
    private int clientEnergy;
    private int clientMaxEnergy;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 29;
    private static final int SLOT_SIZE = 18;

    public DockingStationMenu(int containerId, Inventory playerInv, BlockEntity blockEntity) {
        super((MenuType)ModMenuTypes.DOCKING_STATION_MENU.get(), containerId);
        this.dockBlock = (DockingStationBlockEntity)blockEntity;
        this.level = playerInv.player.level();
        this.addPlayerInventory(playerInv);
        this.addPlayerHotbar(playerInv);
        this.addStationInventory();
        this.addDataSlot(new DataSlot(){

            public int get() {
                return DockingStationMenu.this.dockBlock.getEnergyStorage().getEnergyStored();
            }

            public void set(int value) {
                DockingStationMenu.this.clientEnergy = value;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return DockingStationMenu.this.dockBlock.getEnergyStorage().getMaxEnergyStored();
            }

            public void set(int value) {
                DockingStationMenu.this.clientMaxEnergy = value;
            }
        });
    }

    public static DockingStationMenu clientFactory(int containerId, Inventory inventory, FriendlyByteBuf byteBuf) {
        DockingStationMenu dockingStationMenu = new DockingStationMenu(containerId, inventory, inventory.player.level().getBlockEntity(byteBuf.readBlockPos()));
        int idCount = byteBuf.readVarInt();
        for (int i = 0; i < idCount; ++i) {
            dockingStationMenu.getBuddyEntityIds().add(byteBuf.readVarInt());
        }
        return dockingStationMenu;
    }

    public BlockEntity getDockingStation() {
        return this.dockBlock;
    }

    public IntList getBuddyEntityIds() {
        return this.buddyEntityIds;
    }

    public int getBuddyCount() {
        return this.buddyEntityIds.size();
    }

    @Nullable
    public ByteBuddyEntity getBuddyByIndexClient(int index) {
        if (this.level.isClientSide) {
            ByteBuddyEntity byteBuddy;
            if (index < 0 || index >= this.buddyEntityIds.size()) {
                return null;
            }
            int id = this.buddyEntityIds.getInt(index);
            Entity buddyEntity = this.level.getEntity(id);
            return buddyEntity instanceof ByteBuddyEntity ? (byteBuddy = (ByteBuddyEntity)buddyEntity) : null;
        }
        return null;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.slots.get(pIndex);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (pIndex < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 65, false)) {
                return ItemStack.EMPTY;
            }
        } else if (pIndex < 65) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(@NotNull Player player) {
        return this.dockBlock != null && player.distanceToSqr((double)this.dockBlock.getBlockPos().getX() + 0.5, (double)this.dockBlock.getBlockPos().getY() + 0.5, (double)this.dockBlock.getBlockPos().getZ() + 0.5) <= 64.0;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        int startX = 40;
        int startY = 145;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, startX + col * 18, startY + row * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        int startX = 40;
        int startY = 203;
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, startX + i * 18, startY));
        }
    }

    private void addStationInventory() {
        if (this.dockBlock == null) {
            return;
        }
        int startX = 40;
        int startY = 63;
        int slot = 2;
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.dockBlock.getMainInv(), 0, 6, 109){

            public boolean mayPlace(@NotNull ItemStack itemStack) {
                return DockingStationMenu.this.dockBlock.getMainInv().isItemValid(0, itemStack);
            }

            public int getMaxStackSize(ItemStack itemStack) {
                return 1;
            }

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"item/empty_slot_battery"));
            }
        });
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.dockBlock.getMainInv(), 1, 218, 53){

            public boolean mayPlace(@NotNull ItemStack itemStack) {
                return DockingStationMenu.this.dockBlock.getMainInv().isItemValid(1, itemStack);
            }

            public int getMaxStackSize(ItemStack itemStack) {
                return 1;
            }

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"item/empty_slot_clipboard"));
            }
        });
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.dockBlock.getMainInv(), slot++, startX + col * 18, startY + row * 18){

                    public int getMaxStackSize(ItemStack itemStack) {
                        return 64;
                    }
                });
            }
        }
    }

    public int getEnergyStored() {
        return this.clientEnergy;
    }

    public int getMaxEnergyStored() {
        return this.clientMaxEnergy;
    }
}

