/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.screen.custom.menu;

import com.mojang.datafixers.util.Pair;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.turtleboi.bytebuddies.block.entity.SolarPanelBlockEntity;
import net.turtleboi.bytebuddies.screen.ModMenuTypes;
import org.jetbrains.annotations.NotNull;

public class SolarPanelMenu
extends AbstractContainerMenu {
    public final SolarPanelBlockEntity solarPanelBlock;
    public final Level level;
    private int clientEnergy;
    private int clientMaxEnergy;
    private int clientGenerating;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 1;
    private static final int SLOT_SIZE = 18;

    public SolarPanelMenu(int containerId, Inventory playerInv, BlockEntity blockEntity) {
        super((MenuType)ModMenuTypes.SOLAR_PANEL_MENU.get(), containerId);
        this.solarPanelBlock = (SolarPanelBlockEntity)blockEntity;
        this.level = playerInv.player.level();
        this.addPlayerInventory(playerInv);
        this.addPlayerHotbar(playerInv);
        this.addBatterySlot();
        this.addDataSlot(new DataSlot(){

            public int get() {
                return SolarPanelMenu.this.solarPanelBlock.getEnergyStorage().getEnergyStored();
            }

            public void set(int value) {
                SolarPanelMenu.this.clientEnergy = value;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return SolarPanelMenu.this.solarPanelBlock.getEnergyStorage().getMaxEnergyStored();
            }

            public void set(int value) {
                SolarPanelMenu.this.clientMaxEnergy = value;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return SolarPanelMenu.this.solarPanelBlock.isGeneratingBinary();
            }

            public void set(int value) {
                SolarPanelMenu.this.clientGenerating = value;
            }
        });
    }

    public static SolarPanelMenu clientFactory(int containerId, Inventory inventory, FriendlyByteBuf byteBuf) {
        return new SolarPanelMenu(containerId, inventory, inventory.player.level().getBlockEntity(byteBuf.readBlockPos()));
    }

    public BlockEntity getSolarPanel() {
        return this.solarPanelBlock;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.slots.get(pIndex);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (pIndex < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 37, false)) {
                return ItemStack.EMPTY;
            }
        } else if (pIndex < 37) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(@NotNull Player player) {
        return this.solarPanelBlock != null && player.distanceToSqr((double)this.solarPanelBlock.getBlockPos().getX() + 0.5, (double)this.solarPanelBlock.getBlockPos().getY() + 0.5, (double)this.solarPanelBlock.getBlockPos().getZ() + 0.5) <= 64.0;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        int startX = 8;
        int startY = 123;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, startX + col * 18, startY + row * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        int startX = 8;
        int startY = 181;
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, startX + i * 18, startY));
        }
    }

    private void addBatterySlot() {
        if (this.solarPanelBlock == null) {
            return;
        }
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.solarPanelBlock.getBatterySlot(), 0, 80, 79){

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"item/empty_slot_battery"));
            }
        });
    }

    public int getEnergyStored() {
        return this.clientEnergy;
    }

    public int getMaxEnergyStored() {
        return this.clientMaxEnergy;
    }

    public boolean getGeneratingBinary() {
        return this.clientGenerating == 1;
    }
}

