/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.screen.custom.widget;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class TinyIconButton
extends Button {
    public static final int ICON_SIZE = 12;
    private final ResourceLocation atlas;
    private final int atlasW;
    private final int atlasH;
    private final int tileU;
    private final int tileV;
    private final BooleanSupplier lockedCond;
    private boolean pressedVisual = false;
    private Component lockedTooltip;
    @Nullable
    private MiniIcon miniIcon;

    public TinyIconButton(Button.Builder buttonBuilder, ResourceLocation atlas, int atlasW, int atlasH, int tileU, int tileV, @Nullable BooleanSupplier lockedCond, @Nullable MiniIcon miniIcon) {
        super(buttonBuilder);
        this.atlas = Objects.requireNonNull(atlas);
        this.atlasW = atlasW;
        this.atlasH = atlasH;
        this.tileU = tileU;
        this.tileV = tileV;
        this.lockedCond = lockedCond == null ? () -> false : lockedCond;
        this.active = true;
        this.miniIcon = miniIcon;
    }

    public static Function<Button.Builder, Button> buttonFactory(ResourceLocation atlas, int atlasW, int atlasH, int tileU, int tileV, @Nullable BooleanSupplier lockedCond) {
        return builder -> new TinyIconButton((Button.Builder)builder, atlas, atlasW, atlasH, tileU, tileV, lockedCond, null);
    }

    public static Function<Button.Builder, Button> buttonFactoryWithIcon(ResourceLocation atlas, int atlasW, int atlasH, int tileU, int tileV, @Nullable BooleanSupplier lockedCond, @Nullable MiniIcon miniIcon) {
        return builder -> new TinyIconButton((Button.Builder)builder, atlas, atlasW, atlasH, tileU, tileV, lockedCond, miniIcon);
    }

    public TinyIconButton withLockedTooltip(Component reason) {
        this.lockedTooltip = reason;
        return this;
    }

    public boolean isLocked() {
        return this.lockedCond.getAsBoolean();
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        boolean hovered = this.isMouseOver(mouseX, mouseY);
        boolean enabled = this.active;
        boolean locked = this.isLocked();
        boolean showPressed = this.pressedVisual && hovered && enabled && !locked;
        int quadX = showPressed ? 12 : 0;
        int quadY = hovered ? 12 : 0;
        guiGraphics.blit(this.atlas, this.getX(), this.getY(), (float)(this.tileU + quadX), (float)(this.tileV + quadY), 12, 12, this.atlasW, this.atlasH);
        if (this.miniIcon != null) {
            int iu = showPressed ? this.miniIcon.uPressed : this.miniIcon.uNormal;
            int iv = showPressed ? this.miniIcon.vPressed : this.miniIcon.vNormal;
            guiGraphics.blit(this.miniIcon.atlas, this.getX() + this.miniIcon.xOff, this.getY() + this.miniIcon.yOff, (float)iu, (float)iv, 8, 8, this.miniIcon.atlasW, this.miniIcon.atlasH);
        }
        if (hovered && locked && this.lockedTooltip != null) {
            guiGraphics.renderTooltip(Minecraft.getInstance().font, this.lockedTooltip, mouseX, mouseY);
        }
    }

    public void onClick(double mouseX, double mouseY) {
        if (!this.active || this.isLocked()) {
            return;
        }
        this.pressedVisual = true;
        super.onClick(mouseX, mouseY);
    }

    public void onRelease(double mouseX, double mouseY) {
        boolean wasPressed = this.pressedVisual;
        this.pressedVisual = false;
        if (!this.active || this.isLocked()) {
            return;
        }
        if (wasPressed && this.isMouseOver(mouseX, mouseY)) {
            super.onPress();
        }
    }

    public void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
        super.updateWidgetNarration(narrationElementOutput);
    }

    public static final class MiniIcon {
        public final ResourceLocation atlas;
        public final int atlasW;
        public final int atlasH;
        public final int uNormal;
        public final int vNormal;
        public final int uPressed;
        public final int vPressed;
        public final int xOff;
        public final int yOff;

        public MiniIcon(ResourceLocation atlas, int atlasW, int atlasH, int uNormal, int vNormal, int uPressed, int vPressed, int xOff, int yOff) {
            this.atlas = atlas;
            this.atlasW = atlasW;
            this.atlasH = atlasH;
            this.uNormal = uNormal;
            this.vNormal = vNormal;
            this.uPressed = uPressed;
            this.vPressed = vPressed;
            this.xOff = xOff;
            this.yOff = yOff;
        }
    }
}

