/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.blocks;

import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.herbalbrews.core.blocks.entity.TeaKettleBlockEntity;
import net.satisfy.herbalbrews.core.registry.EntityTypeRegistry;
import net.satisfy.herbalbrews.core.registry.SoundEventRegistry;
import net.satisfy.herbalbrews.core.util.HerbalBrewsUtil;
import org.jetbrains.annotations.NotNull;

public class TeaKettleBlock
extends BaseEntityBlock {
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.5, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.125, (double)0.4375, (double)0.1875, (double)0.5, (double)0.5625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.5, (double)0.3125, (double)0.6875, (double)0.5625, (double)0.6875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)0.5625, (double)0.4375, (double)0.5625, (double)0.625, (double)0.5625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.5, (double)0.4375, (double)0.1875, (double)0.625, (double)0.5625), (BooleanOp)BooleanOp.OR);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
            map.put(direction, HerbalBrewsUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
        }
    });
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty LIT = BooleanProperty.create((String)"lit");
    public static final BooleanProperty COOKING = BooleanProperty.create((String)"cooking");
    public static final MapCodec<TeaKettleBlock> CODEC = TeaKettleBlock.simpleCodec(TeaKettleBlock::new);

    public TeaKettleBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)COOKING, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection());
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.getValue((Property)FACING));
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        BlockEntity entity = level.getBlockEntity(blockPos);
        if (entity instanceof MenuProvider) {
            MenuProvider factory = (MenuProvider)entity;
            player.openMenu(factory);
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(blockState, level, blockPos, player, blockHitResult);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof TeaKettleBlockEntity) {
                TeaKettleBlockEntity pot = (TeaKettleBlockEntity)blockEntity;
                if (world instanceof ServerLevel) {
                    Containers.dropContents((Level)world, (BlockPos)pos, (Container)pot);
                }
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, moved);
        }
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity;
        if (world.isClientSide() && (blockEntity = world.getBlockEntity(pos)) instanceof TeaKettleBlockEntity) {
            TeaKettleBlockEntity be = (TeaKettleBlockEntity)blockEntity;
            if (be.doEffect) {
                double d = (double)pos.getX() + 0.5;
                double e = (double)pos.getY() + 0.5;
                double f = (double)pos.getZ() + 0.5;
                world.playLocalSound(d, e, f, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                double radius = 0.75;
                int particleCount = 16;
                for (int i = 0; i < particleCount; ++i) {
                    double angle = Math.PI * 2 * (double)i / (double)particleCount;
                    double offsetX = radius * Math.cos(angle);
                    double offsetZ = radius * Math.sin(angle);
                    double px = d + offsetX;
                    double pz = f + offsetZ;
                    world.addParticle((ParticleOptions)ParticleTypes.FLAME, px, e, pz, 0.0, 0.02, 0.0);
                }
                be.doEffect = false;
            }
        }
        if (((Boolean)state.getValue((Property)COOKING)).booleanValue() || ((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            double d = (double)pos.getX() + 0.5;
            double e = (float)pos.getY() + 8.0f + 5.0f;
            double f = (double)pos.getZ() + 0.5;
            if (random.nextDouble() < 0.3) {
                world.playLocalSound(d, e, f, (SoundEvent)SoundEventRegistry.TEA_KETTLE_BOILING.get(), SoundSource.BLOCKS, 0.05f, 1.0f, false);
            }
            SimpleParticleType cozySmokeParticle = ParticleTypes.SMOKE;
            this.addParticle(world, (ParticleOptions)cozySmokeParticle, pos.getX(), (double)pos.getY() + 0.5, pos.getZ(), random, 0.02);
            this.addParticle(world, (ParticleOptions)ParticleTypes.SMOKE, pos.getX(), (double)pos.getY() + 2.2, pos.getZ(), random, 0.002);
        }
    }

    private void addParticle(Level world, ParticleOptions particleOptions, double x, double y, double z, RandomSource random, double velocityY) {
        world.addAlwaysVisibleParticle(particleOptions, x + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), y + random.nextDouble() + random.nextDouble(), z + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, velocityY, 0.0);
    }

    public void stepOn(Level world, BlockPos pos, BlockState state, Entity entity) {
        boolean isLit = (Boolean)state.getValue((Property)LIT);
        if (isLit && !entity.fireImmune() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.hurt(world.damageSources().hotFloor(), 1.0f);
        }
        super.stepOn(world, pos, state, entity);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, COOKING, LIT});
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return TeaKettleBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)EntityTypeRegistry.TEA_KETTLE_BLOCK_ENTITY.get()), (world1, pos, state1, be) -> be.tick(world1, pos, state1));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TeaKettleBlockEntity(pos, state);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.herbalbrews.canbeplaced").withStyle(style -> style.withColor(TextColor.fromRgb((int)13467442)).withItalic(Boolean.valueOf(true))));
    }
}

