/*
 * Decompiled with CFR 0.152.
 */
package waves.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLPaths;
import waves.Waves;
import waves.common.WavesTags;
import waves.config.Config;
import waves.util.WaveHelpers;

public class TagLoader {
    public static final String DATA_PATH = "data/waves/tags/";
    public static final Map<TagKey<?>, Set<ResourceLocation>> LOADED_TAGS = new HashMap();
    private static boolean tagsLoaded = false;

    public static void init(IEventBus bus) {
        bus.addListener(TagLoader::onClientSetup);
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        if (!tagsLoaded) {
            if (((Boolean)Config.COMMON.debug.get()).booleanValue()) {
                String jarName = TagLoader.getJarName();
                Waves.LOGGER.info("Loading tags during client setup from {}\\{}", (Object)(jarName != null ? jarName : "mod JAR"), (Object)DATA_PATH);
            }
            TagLoader.loadTagsFromFiles();
            boolean bl = tagsLoaded = !LOADED_TAGS.isEmpty();
            if (((Boolean)Config.COMMON.debug.get()).booleanValue()) {
                Waves.LOGGER.info("Tags loaded: {}", LOADED_TAGS.keySet());
                for (Map.Entry<TagKey<?>, Set<ResourceLocation>> entry : LOADED_TAGS.entrySet()) {
                    Waves.LOGGER.info("Tag {} contents: {}", (Object)entry.getKey().location(), entry.getValue());
                }
            }
        }
    }

    private static String getJarName() {
        block3: {
            try {
                List<String> jarPaths = TagLoader.accessAllJars();
                if (!jarPaths.isEmpty()) {
                    return new File(jarPaths.get(0)).getName();
                }
            }
            catch (IOException e) {
                if (!((Boolean)Config.COMMON.debug.get()).booleanValue()) break block3;
                Waves.LOGGER.error("Failed to get JAR name: {}", (Object)e.getMessage());
            }
        }
        return null;
    }

    private static Map<String, Map<String, TagKey<?>>> getTagKeys() {
        HashMap tagKeys;
        block9: {
            tagKeys = new HashMap();
            try {
                for (Class<?> innerClass : WavesTags.class.getDeclaredClasses()) {
                    if (((Boolean)Config.COMMON.debug.get()).booleanValue()) {
                        Waves.LOGGER.debug("Scanning inner class: {}", (Object)innerClass.getSimpleName());
                    }
                    for (Field field : innerClass.getDeclaredFields()) {
                        if (field.getType() != TagKey.class) continue;
                        field.setAccessible(true);
                        TagKey tagKey = (TagKey)field.get(null);
                        String registryPath = TagLoader.getTagPathForRegistry(tagKey.registry());
                        String tagPath = tagKey.location().getPath();
                        tagKeys.computeIfAbsent(registryPath, k -> new HashMap()).put(registryPath + "/" + tagPath, tagKey);
                        if (!((Boolean)Config.COMMON.debug.get()).booleanValue()) continue;
                        Waves.LOGGER.debug("Registered tag key: {} for registry: {}", (Object)tagKey.location(), (Object)registryPath);
                    }
                }
            }
            catch (IllegalAccessException e) {
                if (!((Boolean)Config.COMMON.debug.get()).booleanValue()) break block9;
                Waves.LOGGER.error("Failed to access WavesTags fields: {}", (Object)e.getMessage());
            }
        }
        if (tagKeys.isEmpty()) {
            if (((Boolean)Config.COMMON.debug.get()).booleanValue()) {
                Waves.LOGGER.error("No tag keys found in WavesTags");
            }
        } else if (((Boolean)Config.COMMON.debug.get()).booleanValue()) {
            Waves.LOGGER.info("Discovered tag types: {}", tagKeys.keySet());
        }
        return tagKeys;
    }

    private static String getTagPathForRegistry(ResourceKey<? extends Registry<?>> registryKey) {
        return registryKey.location().getPath();
    }

    private static List<String> accessAllJars() throws IOException {
        File directory = new File(FMLPaths.MODSDIR.get().toString());
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IOException("Invalid mods directory: " + directory.getAbsolutePath());
        }
        File[] files = directory.listFiles((dir, name) -> name.toLowerCase().endsWith(".jar"));
        if (files == null || files.length == 0) {
            if (((Boolean)Config.COMMON.debug.get()).booleanValue()) {
                Waves.LOGGER.error("No JAR files found in {}", (Object)directory.getAbsolutePath());
            }
            return Collections.emptyList();
        }
        ArrayList<String> jarPaths = new ArrayList<String>();
        for (File jarFile : files) {
            if (((Boolean)Config.COMMON.debug.get()).booleanValue()) {
                Waves.LOGGER.debug("Found JAR: {}", (Object)jarFile.getName());
            }
            try (JarFile jar = new JarFile(jarFile);){
                jarPaths.add(jarFile.getAbsolutePath());
            }
            catch (IOException e) {
                if (!((Boolean)Config.COMMON.debug.get()).booleanValue()) continue;
                Waves.LOGGER.warn("Failed to access JAR {}: {}", (Object)jarFile.getName(), (Object)e.getMessage());
            }
        }
        if (jarPaths.isEmpty() && ((Boolean)Config.COMMON.debug.get()).booleanValue()) {
            Waves.LOGGER.error("No accessible JAR files found in {}", (Object)directory.getAbsolutePath());
        }
        return jarPaths;
    }

    private static void readAllJsonFromDirectory(String jarPath, Map<String, JsonElement> map) throws IOException {
        File jarFile = new File(jarPath);
        if (!jarFile.exists() || !jarFile.getName().endsWith(".jar")) {
            throw new IOException("Invalid JAR file path: " + jarPath);
        }
        String fullDirPath = "data/";
        if (((Boolean)Config.COMMON.debug.get()).booleanValue()) {
            Waves.LOGGER.info("Scanning for JSON tag files in: {} (JAR: {})", (Object)fullDirPath, (Object)jarFile.getName());
        }
        try (JarFile jar = new JarFile(jarFile);){
            Enumeration<JarEntry> entries = jar.entries();
            int tagFileCount = 0;
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(fullDirPath) || !name.endsWith(".json") || !name.contains("/tags/")) continue;
                String filePathWithoutExtension = name.substring("data/".length(), name.length() - ".json".length());
                if (((Boolean)Config.COMMON.debug.get()).booleanValue()) {
                    Waves.LOGGER.debug("Found tag file: {} (full path: {})", (Object)filePathWithoutExtension, (Object)name);
                }
                InputStream inputStream = jar.getInputStream(entry);
                try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                    JsonReader jsonReader = new JsonReader((Reader)reader);
                    jsonReader.setLenient(true);
                    try {
                        JsonElement jsonElement = JsonParser.parseReader((JsonReader)jsonReader);
                        map.put(filePathWithoutExtension, jsonElement);
                        if (((Boolean)Config.COMMON.debug.get()).booleanValue()) {
                            Waves.LOGGER.debug("Loaded JSON content for {}: {}", (Object)name, (Object)jsonElement.toString());
                        }
                        ++tagFileCount;
                    }
                    catch (JsonParseException e) {
                        if (!((Boolean)Config.COMMON.debug.get()).booleanValue()) continue;
                        Waves.LOGGER.warn("Skipping invalid JSON file: {} due to parsing error: {}", (Object)name, (Object)e.getMessage());
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            if (((Boolean)Config.COMMON.debug.get()).booleanValue()) {
                Waves.LOGGER.info("Found {} tag files in JAR: {}", (Object)tagFileCount, (Object)jarFile.getName());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Set<ResourceLocation> resolveTagRecursively(ResourceLocation tagId, String registryPath, Map<String, JsonElement> jsonMap, Set<ResourceLocation> visitedTags) {
        HashSet<ResourceLocation> locations;
        block23: {
            locations = new HashSet<ResourceLocation>();
            ArrayList<CallSite> pathsToTry = new ArrayList<CallSite>();
            pathsToTry.add((CallSite)((Object)(tagId.getNamespace() + "/tags/" + registryPath + "/" + tagId.getPath())));
            if (registryPath.equals("worldgen/biome")) {
                pathsToTry.add((CallSite)((Object)("biomes/" + tagId.getPath())));
                pathsToTry.add((CallSite)((Object)("tags/biomes/" + tagId.getPath())));
                pathsToTry.add((CallSite)((Object)("tags/worldgen/biome/" + tagId.getPath())));
            }
            JsonElement json = null;
            String foundPath = null;
            for (String string : pathsToTry) {
                json = jsonMap.get(string);
                if (json == null) continue;
                foundPath = string;
                break;
            }
            if (json == null) {
                if (((Boolean)Config.COMMON.debug.get()).booleanValue()) {
                    Waves.LOGGER.warn("Tag file not found for {} in registry {} (paths tried: {})", new Object[]{tagId, registryPath, pathsToTry});
                }
                return locations;
            }
            if (visitedTags.contains(tagId)) {
                if (((Boolean)Config.COMMON.debug.get()).booleanValue()) {
                    Waves.LOGGER.warn("Circular tag reference detected for {} in registry {}", (Object)tagId, (Object)registryPath);
                }
                return locations;
            }
            visitedTags.add(tagId);
            try {
                JsonArray values;
                JsonArray jsonArray = values = json.isJsonArray() ? json.getAsJsonArray() : json.getAsJsonObject().getAsJsonArray("values");
                if (((Boolean)Config.COMMON.debug.get()).booleanValue()) {
                    Waves.LOGGER.debug("Processing tag {} (path: {}): {}", new Object[]{tagId, foundPath, values.toString()});
                }
                for (JsonElement element : values) {
                    String id;
                    boolean required;
                    block22: {
                        required = true;
                        if (element.isJsonObject()) {
                            JsonObject obj = element.getAsJsonObject();
                            if (obj.has("id")) {
                                id = obj.get("id").getAsString();
                                if (obj.has("required")) {
                                    required = obj.get("required").getAsBoolean();
                                }
                                break block22;
                            } else {
                                if (!((Boolean)Config.COMMON.debug.get()).booleanValue()) continue;
                                Waves.LOGGER.warn("Skipping JSON object without 'id' field in tag {}: {}", (Object)tagId, (Object)element.toString());
                                continue;
                            }
                        }
                        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                            id = element.getAsString();
                        } else {
                            if (!((Boolean)Config.COMMON.debug.get()).booleanValue()) continue;
                            Waves.LOGGER.warn("Skipping invalid JSON element in tag {}: {}", (Object)tagId, (Object)element.toString());
                            continue;
                        }
                    }
                    try {
                        if (id.startsWith("#")) {
                            ResourceLocation nestedTagId = WaveHelpers.resourceLocation(id.substring(1));
                            Set<ResourceLocation> nestedLocations = TagLoader.resolveTagRecursively(nestedTagId, registryPath, jsonMap, visitedTags);
                            if (!nestedLocations.isEmpty()) {
                                locations.addAll(nestedLocations);
                                if (!((Boolean)Config.COMMON.debug.get()).booleanValue()) continue;
                                Waves.LOGGER.debug("Resolved nested tag {} for {}: {}", new Object[]{id, tagId, nestedLocations});
                                continue;
                            }
                            if (!required || !((Boolean)Config.COMMON.debug.get()).booleanValue()) continue;
                            Waves.LOGGER.warn("Required nested tag {} not found or empty for {}", (Object)id, (Object)tagId);
                            continue;
                        }
                        if (id.matches("[a-z0-9_.-]+:[a-z0-9_.-/]+")) {
                            ResourceLocation location = WaveHelpers.resourceLocation(id);
                            locations.add(location);
                            if (!((Boolean)Config.COMMON.debug.get()).booleanValue()) continue;
                            Waves.LOGGER.debug("Added ResourceLocation to tag {}: {}", (Object)tagId, (Object)id);
                            continue;
                        }
                        if (!((Boolean)Config.COMMON.debug.get()).booleanValue()) continue;
                        Waves.LOGGER.warn("Invalid ResourceLocation format in tag {}: {}", (Object)tagId, (Object)id);
                    }
                    catch (Exception e) {
                        if (!((Boolean)Config.COMMON.debug.get()).booleanValue()) continue;
                        Waves.LOGGER.warn("Failed to process entry in tag {}: {} ({})", new Object[]{tagId, id, e.getMessage()});
                    }
                }
            }
            catch (Exception e) {
                if (!((Boolean)Config.COMMON.debug.get()).booleanValue()) break block23;
                Waves.LOGGER.error("Failed to parse tag {} (path: {}): {}", new Object[]{tagId, foundPath, e.getMessage()});
            }
        }
        visitedTags.remove(tagId);
        if (((Boolean)Config.COMMON.debug.get()).booleanValue()) {
            Waves.LOGGER.debug("Resolved tag {}: {}", (Object)tagId, locations);
        }
        return locations;
    }

    private static void loadTagsFromFiles() {
        block13: {
            ConcurrentHashMap<String, JsonElement> jsonMap = new ConcurrentHashMap<String, JsonElement>();
            try {
                List<String> jarPaths = TagLoader.accessAllJars();
                if (jarPaths.isEmpty()) {
                    if (((Boolean)Config.COMMON.debug.get()).booleanValue()) {
                        Waves.LOGGER.error("No JAR files found in mods directory");
                    }
                    return;
                }
                for (String jarPath : jarPaths) {
                    if (((Boolean)Config.COMMON.debug.get()).booleanValue()) {
                        Waves.LOGGER.info("Scanning JAR file: {}", (Object)jarPath);
                    }
                    TagLoader.readAllJsonFromDirectory(jarPath, jsonMap);
                }
                if (jsonMap.isEmpty()) {
                    if (((Boolean)Config.COMMON.debug.get()).booleanValue()) {
                        Waves.LOGGER.error("No JSON tag files found in any JAR");
                    }
                    return;
                }
                if (((Boolean)Config.COMMON.debug.get()).booleanValue()) {
                    Waves.LOGGER.info("Loaded JSON tag files: {}", jsonMap.keySet());
                }
                Map<String, Map<String, TagKey<?>>> tagKeys = TagLoader.getTagKeys();
                for (Map.Entry<String, Map<String, TagKey<?>>> typeEntry : tagKeys.entrySet()) {
                    String registryPath = typeEntry.getKey();
                    if (((Boolean)Config.COMMON.debug.get()).booleanValue()) {
                        Waves.LOGGER.info("Processing tag type: {}", (Object)registryPath);
                    }
                    for (Map.Entry<String, TagKey<?>> tagEntry : typeEntry.getValue().entrySet()) {
                        TagKey<?> tagKey = tagEntry.getValue();
                        if (((Boolean)Config.COMMON.debug.get()).booleanValue()) {
                            Waves.LOGGER.info("Processing tag {} (registry: {})", (Object)tagKey.location(), (Object)tagKey.registry().location());
                        }
                        ResourceLocation tagId = tagKey.location();
                        Set<ResourceLocation> locations = TagLoader.resolveTagRecursively(tagId, registryPath, jsonMap, new HashSet<ResourceLocation>());
                        LOADED_TAGS.put(tagKey, locations);
                        if (!((Boolean)Config.COMMON.debug.get()).booleanValue()) continue;
                        Waves.LOGGER.info("Loaded tag {}: {}", (Object)tagKey.location(), locations);
                    }
                }
            }
            catch (IOException e) {
                if (!((Boolean)Config.COMMON.debug.get()).booleanValue()) break block13;
                Waves.LOGGER.error("Failed to load JSON files from JARs: {}", (Object)e.getMessage());
            }
        }
    }

    public static <T> Set<ResourceLocation> getTagLocations(TagKey<T> tagKey) {
        return LOADED_TAGS.getOrDefault(tagKey, Collections.emptySet());
    }

    public static <T> boolean isInTag(T element, TagKey<T> tagKey) {
        boolean debug = (Boolean)Config.COMMON.debug.get();
        if (Minecraft.getInstance().level == null) {
            if (debug) {
                Waves.LOGGER.warn("Cannot access registry: no world loaded for tag check {}", (Object)tagKey.location());
            }
            return false;
        }
        Registry registry = Minecraft.getInstance().level.registryAccess().registryOrThrow(tagKey.registry());
        Optional resourceKey = registry.getResourceKey(element);
        if (resourceKey.isEmpty()) {
            if (debug) {
                Waves.LOGGER.debug("No ResourceKey found for element {} in tag check: {} (registry: {})", new Object[]{element, tagKey.location(), tagKey.registry().location()});
            }
            return false;
        }
        ResourceLocation elementLocation = ((ResourceKey)resourceKey.get()).location();
        Set tagLocations = LOADED_TAGS.getOrDefault(tagKey, Collections.emptySet());
        boolean isInTag = tagLocations.contains(elementLocation);
        if (debug) {
            Waves.LOGGER.debug("Checking if {} is in tag {} (registry: {}, contents: {}): {}", new Object[]{elementLocation, tagKey.location(), tagKey.registry().location(), tagLocations, isInTag});
        }
        return isInTag;
    }
}

