/*
 * Decompiled with CFR 0.152.
 */
package waves.common.entities;

import com.mojang.math.Axis;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import waves.client.WaveSounds;
import waves.common.WavesTags;
import waves.config.Config;
import waves.util.Color;
import waves.util.WaveHelpers;

public class Wave
extends Entity {
    private static final EntityDataAccessor<Integer> AGE = SynchedEntityData.defineId(Wave.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> X = SynchedEntityData.defineId(Wave.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> Y = SynchedEntityData.defineId(Wave.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> Z = SynchedEntityData.defineId(Wave.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> XO = SynchedEntityData.defineId(Wave.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> YO = SynchedEntityData.defineId(Wave.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ZO = SynchedEntityData.defineId(Wave.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> QUAD_SIZE = SynchedEntityData.defineId(Wave.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> PACKED_LIGHT = SynchedEntityData.defineId(Wave.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<String> WAVE_TEXTURE = SynchedEntityData.defineId(Wave.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Float> ALPHA = SynchedEntityData.defineId(Wave.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.defineId(Wave.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.defineId(Wave.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.defineId(Wave.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_X = SynchedEntityData.defineId(Wave.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_Y = SynchedEntityData.defineId(Wave.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_Z = SynchedEntityData.defineId(Wave.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_W = SynchedEntityData.defineId(Wave.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public boolean hasInitializedParameters = false;
    public Level level;
    public Vec3 startPos;
    public Vec3 shorePos;
    public Vec3 direction;
    public Vec3 wavePos;
    public BlockPos behindBlockPos;
    public BlockPos shoreBlockPos;
    public float scale;
    public float size;
    public float speed;
    public float alpha;
    public int waveSize;
    public int surroundWaterBlocks;
    public int seaLevel;
    public double initialDistance;
    public double angleToShore;
    public String waveSizeName;
    public boolean hasReachedShore = false;
    public boolean hasTouchedLand = false;
    public boolean hasPlacedBlock = false;
    public boolean hasPlayedSound = false;
    public int waveSpriteOld;
    public double distanceOld;
    public double waveSpeedOld;
    public String waveTexture;
    public float starBrightness;
    public float skyOvercast;
    public double bioluminescenceNoise;
    public int packedLight;
    public Color color = new Color();
    public Quaternionf rotation = new Quaternionf();
    public float quadSize;
    public boolean onGround;
    public float bbWidth = 0.6f;
    public float bbHeight = 1.8f;
    public double x;
    public double y;
    public double z;
    public double xd;
    public double yd;
    public double zd;
    public int age;
    public double diagonalSize;
    public AABB aabb;

    public Wave(EntityType<? extends Entity> entityType, Level level) {
        super(entityType, level);
        this.level = level;
        this.setNoGravity(true);
        this.setInvisible(true);
        this.setSilent(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(AGE, (Object)0);
        builder.define(X, (Object)Float.valueOf(0.0f));
        builder.define(Y, (Object)Float.valueOf(0.0f));
        builder.define(Z, (Object)Float.valueOf(0.0f));
        builder.define(XO, (Object)Float.valueOf(0.0f));
        builder.define(YO, (Object)Float.valueOf(0.0f));
        builder.define(ZO, (Object)Float.valueOf(0.0f));
        builder.define(QUAD_SIZE, (Object)Float.valueOf(0.5f));
        builder.define(PACKED_LIGHT, (Object)0);
        builder.define(WAVE_TEXTURE, (Object)"textures/particle/waves/small_0.png");
        builder.define(ALPHA, (Object)Float.valueOf(0.0f));
        builder.define(COLOR_R, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_G, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_B, (Object)Float.valueOf(1.0f));
        builder.define(ROTATION_X, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_Y, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_Z, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_W, (Object)Float.valueOf(1.0f));
    }

    public void setParameters(Vec3 startPos, Vec3 shorePos, Vec3 direction, float scale, float size, float speed, int waveSize, int surroundWaterBlocks, int seaLevel) {
        this.hasInitializedParameters = true;
        this.startPos = startPos;
        this.shorePos = shorePos;
        this.direction = direction;
        this.scale = scale;
        this.size = size;
        this.speed = speed;
        this.waveSize = waveSize;
        this.surroundWaterBlocks = surroundWaterBlocks;
        this.seaLevel = seaLevel;
        this.setPos(startPos);
        this.x = startPos.x();
        this.y = startPos.y();
        this.z = startPos.z();
        this.xd = direction.x() * (double)speed;
        this.zd = direction.z() * (double)speed;
        this.yd = 0.0;
        this.entityData.set(X, (Object)Float.valueOf((float)this.x));
        this.entityData.set(Y, (Object)Float.valueOf((float)this.y));
        this.entityData.set(Z, (Object)Float.valueOf((float)this.z));
        this.entityData.set(XO, (Object)Float.valueOf((float)this.xo));
        this.entityData.set(YO, (Object)Float.valueOf((float)this.yo));
        this.entityData.set(ZO, (Object)Float.valueOf((float)this.zo));
        this.waveTexture = "textures/particle/waves/" + WaveHelpers.toSize(waveSize).toLowerCase() + "_0.png";
        this.entityData.set(WAVE_TEXTURE, (Object)this.waveTexture);
        this.quadSize = size * 0.5f;
        this.entityData.set(QUAD_SIZE, (Object)Float.valueOf(this.quadSize));
        this.waveSizeName = WaveHelpers.toSize(waveSize).toLowerCase();
        this.initialDistance = startPos.distanceTo(shorePos);
        this.angleToShore = WaveHelpers.calculateAngleToTarget(startPos, shorePos);
        this.waveSpriteOld = 0;
        this.distanceOld = Double.MAX_VALUE;
        this.waveSpeedOld = 0.0;
        this.age = 0;
        this.entityData.set(AGE, (Object)this.age);
        this.diagonalSize = Math.sqrt(Math.pow(this.quadSize, 2.0) + Math.pow(this.quadSize, 2.0)) / 2.0;
        this.aabb = new AABB(-this.diagonalSize, -this.diagonalSize, -this.diagonalSize, this.diagonalSize, this.diagonalSize, this.diagonalSize);
        this.setSize(this.quadSize, (double)this.quadSize * 0.075, (double)this.quadSize * 0.2);
        this.setInvulnerable(true);
        this.noPhysics = true;
        this.rotation = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f).mul((Quaternionfc)Axis.YN.rotation((float)(this.angleToShore - 1.5707963267948966))).mul((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        this.entityData.set(ROTATION_X, (Object)Float.valueOf(this.rotation.x));
        this.entityData.set(ROTATION_Y, (Object)Float.valueOf(this.rotation.y));
        this.entityData.set(ROTATION_Z, (Object)Float.valueOf(this.rotation.z));
        this.entityData.set(ROTATION_W, (Object)Float.valueOf(this.rotation.w));
    }

    public void tick() {
        if (!this.hasInitializedParameters) {
            return;
        }
        RandomSource random = RandomSource.createNewThreadLocalInstance();
        Vec3 currentPos = new Vec3(this.getX(), this.getY(), this.getZ());
        BlockPos blockPos = WaveHelpers.toBlockPos(currentPos);
        double distance = currentPos.distanceTo(this.shorePos);
        FluidState fluidState = WaveHelpers.getFastFluidState(this.level, blockPos.below());
        boolean hasFluidBelow = fluidState == null ? true : !fluidState.isEmpty();
        int waveSprite = WaveHelpers.updateSprite(this.initialDistance, distance, 3.0);
        double vecSpeed = new Vec3(this.xd, 0.0, this.zd).length();
        boolean shouldDecay = this.hasReachedShore || vecSpeed == 0.0 || waveSprite >= (Integer)Config.COMMON.waveSpriteCount.get() - 1;
        this.skyOvercast = (float)WaveHelpers.scale(this.level.getRainLevel(0.0f) * (0.5f + this.level.getThunderLevel(0.0f)), 0.0, 1.5, 0.0, 1.0);
        if (!shouldDecay) {
            this.alpha = Mth.clamp((float)(this.alpha + 0.025f), (float)0.0f, (float)1.0f);
            this.entityData.set(ALPHA, (Object)Float.valueOf(this.alpha));
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (!this.hasReachedShore && !hasFluidBelow) {
            this.xd *= 0.95;
            this.zd *= 0.95;
            if (vecSpeed <= 0.01) {
                Vec3 vecInverse = WaveHelpers.inverse(this.direction);
                this.zd = vecInverse.z() * 0.015;
                this.xd = vecInverse.x() * 0.015;
                this.hasReachedShore = true;
            }
            this.hasTouchedLand = true;
        }
        if (this.hasReachedShore && currentPos.distanceTo(this.shorePos) <= 2.0) {
            double weatherFactor = WaveHelpers.scale(1.0f - this.skyOvercast, 0.0, 1.0, 0.5, 1.0);
            double speedFactor = 1.0 + (0.05 - WaveHelpers.applyEaseOutQuart(this.direction, distance, 5.0, 0.5, 1.0).length() * 0.02) * weatherFactor;
            this.xd *= speedFactor;
            this.zd *= speedFactor;
        }
        if ((!hasFluidBelow || this.waveSpeedOld == vecSpeed || distance > this.distanceOld) && this.hasReachedShore) {
            this.alpha = Mth.clamp((float)(this.alpha - 0.1f), (float)0.0f, (float)1.0f);
            this.entityData.set(ALPHA, (Object)Float.valueOf(this.alpha));
        }
        if (hasFluidBelow && this.hasTouchedLand) {
            this.xd *= 0.95;
            this.zd *= 0.95;
            this.alpha = Mth.clamp((float)(this.alpha - 0.1f), (float)0.0f, (float)1.0f);
            this.entityData.set(ALPHA, (Object)Float.valueOf(this.alpha));
        }
        this.move(MoverType.SELF, new Vec3(this.xd, 0.0, this.zd));
        this.depositBlock(currentPos, this.waveSpriteOld);
        if (this.alpha <= 0.01f || this.age > 600 || hasFluidBelow && this.hasTouchedLand) {
            this.remove();
            return;
        }
        ++this.age;
        this.entityData.set(AGE, (Object)this.age);
        this.waveSpeedOld = vecSpeed;
        this.distanceOld = distance;
        if (this.waveSpriteOld < waveSprite) {
            this.waveTexture = "textures/particle/waves/" + this.waveSizeName + "_" + waveSprite + ".png";
            this.entityData.set(WAVE_TEXTURE, (Object)this.waveTexture);
            this.waveSpriteOld = waveSprite;
        }
        this.wavePos = new Vec3(this.x, this.y, this.z);
        this.entityData.set(X, (Object)Float.valueOf((float)this.x));
        this.entityData.set(Y, (Object)Float.valueOf((float)this.y));
        this.entityData.set(Z, (Object)Float.valueOf((float)this.z));
        this.entityData.set(XO, (Object)Float.valueOf((float)this.xo));
        this.entityData.set(YO, (Object)Float.valueOf((float)this.yo));
        this.entityData.set(ZO, (Object)Float.valueOf((float)this.zo));
        this.behindBlockPos = WaveHelpers.toBlockPos(WaveHelpers.getPositionOffset(this.wavePos, this.angleToShore, 180.0, 6.0));
        this.shoreBlockPos = WaveHelpers.toBlockPos(this.shorePos);
        if (currentPos.distanceTo(this.shorePos) < 4.0 && random.nextInt((Integer)Config.COMMON.waveBreakingSoundChance.get() + 1) == 0 && !this.hasPlayedSound) {
            for (Player player : this.level.players()) {
                float soundMod = (float)WaveHelpers.soundDistanceMod(player, this.shorePos, 60.0, 10.0);
                if (!(soundMod > 0.0f)) continue;
                float rainfall = 1.0f + this.skyOvercast * 0.5f;
                float amplifier = rainfall * 0.5f * soundMod * ((Double)Config.COMMON.waveVolume.get()).floatValue();
                float volume = (random.nextFloat() * 0.75f + 0.35f) * amplifier;
                float pitch = random.nextFloat() * 0.8f + 0.7f;
                this.level().playSound((Player)null, this.x, this.y, this.z, (SoundEvent)WaveSounds.WAVES_BREAKING.get(), SoundSource.AMBIENT, volume, pitch);
                this.hasPlayedSound = true;
            }
        }
        double dayTime = (double)this.level.getDayTime() * (Double)Config.COMMON.waveBioluminescenceFrequency.get();
        double speed = Math.sqrt(this.xd * this.xd + this.zd * this.zd) * 10.0;
        double skyBrightness = WaveHelpers.getSkyBrightness(this.level, 0.0f);
        double bioluminescenceNoise = Mth.clamp((double)(WaveHelpers.bioluminescenceNoise(this.level, 10L, (Integer)Config.COMMON.waveBioluminescenceChange.get()).noise(dayTime + this.x, dayTime + this.z) * speed), (double)0.0, (double)1.0) * (1.0 - skyBrightness);
        this.bioluminescenceNoise = bioluminescenceNoise < 0.05 ? 0.0 : bioluminescenceNoise;
        float r = (float)Mth.clamp((double)skyBrightness, (double)0.2, (double)1.0);
        float g = (float)Mth.clamp((double)(skyBrightness + bioluminescenceNoise * 0.8), (double)0.2, (double)1.0);
        float b = (float)Mth.clamp((double)(skyBrightness + bioluminescenceNoise), (double)0.2, (double)1.0);
        this.packedLight = (int)Math.round(Mth.clamp((double)((double)WaveHelpers.getLightColor(this.level, this.behindBlockPos.above()) + 1.0E7 * bioluminescenceNoise), (double)0.0, (double)1.572888E7));
        this.entityData.set(PACKED_LIGHT, (Object)this.packedLight);
        this.color = new Color(r, g, b, this.alpha);
        this.entityData.set(COLOR_R, (Object)Float.valueOf(r));
        this.entityData.set(COLOR_G, (Object)Float.valueOf(g));
        this.entityData.set(COLOR_B, (Object)Float.valueOf(b));
        if (((Boolean)Config.COMMON.waveEntityInteraction.get()).booleanValue() && this.level.getGameTime() % (long)((Integer)Config.COMMON.waveInteractionUpdateFrequency.get()).intValue() == 0L) {
            AABB box = this.aabb.move(currentPos).inflate(2.0);
            List entityList = this.level.getEntitiesOfClass(Entity.class, box);
            entityList.stream().filter(entity -> !(entity instanceof Wave)).forEach(entity -> {
                boolean isWhitelisted = WaveHelpers.isEntity(entity, WavesTags.EntityTypes.WAVE_INTERACTION_WHITELIST);
                boolean isBlacklisted = WaveHelpers.isEntity(entity, WavesTags.EntityTypes.WAVE_INTERACTION_BLACKLIST);
                if (isWhitelisted && !isBlacklisted || !isWhitelisted && !isBlacklisted) {
                    double sizeNorm = ((double)this.size - 3.0) / 11.0;
                    double sizeForceFactor = sizeNorm + 0.5;
                    Vec3 sizeFactor = new Vec3(0.125, 0.125, 0.125).scale(sizeNorm * 3.0 + 1.0);
                    for (double i = 0.0; i < 7.0; i += 1.0) {
                        ServerLevel server;
                        Level patt0$temp;
                        double spacing = (i / 3.0 - 1.0) * (double)this.quadSize * 0.5;
                        Vec3 offsetVec = new Vec3(spacing, 0.0, 0.0).yRot((float)(-this.angleToShore + 1.5707963267948966));
                        Vec3 aabbCenter = offsetVec.add(currentPos);
                        AABB aabb = new AABB(Vec3.ZERO, sizeFactor).move(aabbCenter);
                        if (entity.getBoundingBox().intersects(aabb)) {
                            if (this.level.getGameTime() % 1L + (long)random.nextInt(8) == 0L && (patt0$temp = this.level) instanceof ServerLevel) {
                                server = (ServerLevel)patt0$temp;
                                double entityWidth = (double)entity.getBbWidth() * 0.5;
                                server.sendParticles((ParticleOptions)ParticleTypes.SPLASH, entity.getX() + random.nextGaussian() * entityWidth * 0.8, currentPos.y() - 0.1 + random.nextDouble() * 0.2, entity.getZ() + random.nextGaussian() * entityWidth * 0.8, 1, 0.0, 0.0, 0.0, 0.0);
                                server.sendParticles((ParticleOptions)ParticleTypes.BUBBLE, entity.getX() + random.nextGaussian() * entityWidth * 0.8, currentPos.y() - 0.1 + random.nextDouble() * 0.2, entity.getZ() + random.nextGaussian() * entityWidth * 0.8, 1, 0.0, 0.0, 0.0, 0.0);
                            }
                            entity.setDeltaMovement(entity.getDeltaMovement().add(new Vec3(this.xd * 0.025, (double)this.quadSize * 0.0015, this.zd * 0.025).scale(sizeForceFactor).scale(((Double)Config.COMMON.waveInteractionForceFactor.get()).doubleValue())));
                            break;
                        }
                        if (!((Boolean)Config.COMMON.debug.get()).booleanValue() || !((patt0$temp = this.level) instanceof ServerLevel)) continue;
                        server = (ServerLevel)patt0$temp;
                        server.sendParticles((ParticleOptions)ParticleTypes.FLAME, aabbCenter.x(), aabbCenter.y(), aabbCenter.z(), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            });
        }
    }

    public void depositBlock(Vec3 currentPos, int waveSprite) {
        if (!this.hasPlacedBlock && this.hasReachedShore && waveSprite >= (Integer)Config.COMMON.waveSpriteCount.get() - 1) {
            this.hasPlacedBlock = true;
            RandomSource random = this.level.getRandom();
            if ((Integer)Config.COMMON.waveBlockDepositChance.get() <= 0 || random.nextInt(((Integer)Config.COMMON.waveBlockDepositChance.get()).intValue()) == 0) {
                BlockPos posDeposit = WaveHelpers.getRandomBlockPosAlongWave(this.level, random, currentPos, this.direction, this.size, this.seaLevel);
                BlockState stateDeposit = WaveHelpers.getFastBlockState(this.level, posDeposit);
                BlockState stateDepositBelow = WaveHelpers.getFastBlockState(this.level, posDeposit.below());
                Optional<Block> depositBlock = WaveHelpers.randomBlock(WavesTags.Blocks.TIDE_POOL_BLOCKS, random);
                if (!depositBlock.isEmpty()) {
                    BlockState depositState = depositBlock.get().defaultBlockState();
                    if ((stateDeposit.isAir() || stateDeposit.canBeReplaced()) && stateDepositBelow.getFluidState().isEmpty() && depositState.canSurvive((LevelReader)this.level, posDeposit)) {
                        this.level.setBlockAndUpdate(posDeposit, depositState);
                    }
                }
            }
        }
    }

    public void remove() {
        this.discard();
    }

    public void setSize(double length, double height, double width) {
        this.bbWidth = (float)width;
        this.bbHeight = (float)height;
        this.setBoundingBox(new AABB(-length, -width, -height, length, width, height));
    }

    public Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putBoolean("HasInitializedParameters", this.hasInitializedParameters);
        tag.putDouble("X", this.x);
        tag.putDouble("Y", this.y);
        tag.putDouble("Z", this.z);
        tag.putDouble("XO", this.xo);
        tag.putDouble("YO", this.yo);
        tag.putDouble("ZO", this.zo);
        tag.putDouble("StartPosX", this.startPos.x());
        tag.putDouble("StartPosY", this.startPos.y());
        tag.putDouble("StartPosZ", this.startPos.z());
        tag.putDouble("ShorePosX", this.shorePos.x());
        tag.putDouble("ShorePosY", this.shorePos.y());
        tag.putDouble("ShorePosZ", this.shorePos.z());
        tag.putDouble("DirectionX", this.direction.x());
        tag.putDouble("DirectionY", this.direction.y());
        tag.putDouble("DirectionZ", this.direction.z());
        tag.putFloat("Scale", this.scale);
        tag.putFloat("Size", this.size);
        tag.putFloat("Speed", this.speed);
        tag.putInt("WaveSize", this.waveSize);
        tag.putInt("SurroundWaterBlocks", this.surroundWaterBlocks);
        tag.putInt("SeaLevel", this.seaLevel);
        tag.putDouble("InitialDistance", this.initialDistance);
        tag.putBoolean("HasReachedShore", this.hasReachedShore);
        tag.putBoolean("HasTouchedLand", this.hasTouchedLand);
        tag.putBoolean("HasPlacedBlock", this.hasPlacedBlock);
        tag.putBoolean("HasPlayedSound", this.hasPlayedSound);
        tag.putInt("WaveSpriteOld", this.waveSpriteOld);
        tag.putDouble("DistanceOld", this.distanceOld);
        tag.putDouble("WaveSpeedOld", this.waveSpeedOld);
        tag.putString("WaveTexture", this.waveTexture);
        tag.putDouble("AngleToShore", this.angleToShore);
        tag.putFloat("QuadSize", this.quadSize);
        tag.putInt("Age", this.age);
        tag.putDouble("DiagonalSize", this.diagonalSize);
        tag.putFloat("Alpha", this.alpha);
        tag.putFloat("ColorR", this.color.red());
        tag.putFloat("ColorG", this.color.green());
        tag.putFloat("ColorB", this.color.blue());
        tag.putFloat("RotationX", this.rotation.x);
        tag.putFloat("RotationY", this.rotation.y);
        tag.putFloat("RotationZ", this.rotation.z);
        tag.putFloat("RotationW", this.rotation.w);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        this.hasInitializedParameters = tag.getBoolean("HasInitializedParameters");
        this.x = tag.getDouble("X");
        this.y = tag.getDouble("Y");
        this.z = tag.getDouble("Z");
        this.xo = tag.getDouble("XO");
        this.yo = tag.getDouble("YO");
        this.zo = tag.getDouble("ZO");
        this.startPos = new Vec3(tag.getDouble("StartPosX"), tag.getDouble("StartPosY"), tag.getDouble("StartPosZ"));
        this.shorePos = new Vec3(tag.getDouble("ShorePosX"), tag.getDouble("ShorePosY"), tag.getDouble("ShorePosZ"));
        this.direction = new Vec3(tag.getDouble("DirectionX"), tag.getDouble("DirectionY"), tag.getDouble("DirectionZ"));
        this.scale = tag.getFloat("Scale");
        this.size = tag.getFloat("Size");
        this.speed = tag.getFloat("Speed");
        this.waveSize = tag.getInt("WaveSize");
        this.surroundWaterBlocks = tag.getInt("SurroundWaterBlocks");
        this.seaLevel = tag.getInt("SeaLevel");
        this.initialDistance = tag.getDouble("InitialDistance");
        this.hasReachedShore = tag.getBoolean("HasReachedShore");
        this.hasTouchedLand = tag.getBoolean("HasTouchedLand");
        this.hasPlacedBlock = tag.getBoolean("HasPlacedBlock");
        this.hasPlayedSound = tag.getBoolean("HasPlayedSound");
        this.waveSpriteOld = tag.getInt("WaveSpriteOld");
        this.distanceOld = tag.getDouble("DistanceOld");
        this.waveSpeedOld = tag.getDouble("WaveSpeedOld");
        this.waveTexture = tag.getString("WaveTexture");
        this.entityData.set(WAVE_TEXTURE, (Object)this.waveTexture);
        this.angleToShore = tag.getDouble("AngleToShore");
        this.quadSize = tag.getFloat("QuadSize");
        this.entityData.set(QUAD_SIZE, (Object)Float.valueOf(this.quadSize));
        this.age = tag.getInt("Age");
        this.entityData.set(AGE, (Object)this.age);
        this.diagonalSize = tag.getDouble("DiagonalSize");
        this.alpha = tag.getFloat("Alpha");
        this.entityData.set(ALPHA, (Object)Float.valueOf(this.alpha));
        this.color = new Color(tag.getFloat("ColorR"), tag.getFloat("ColorG"), tag.getFloat("ColorB"), this.alpha);
        this.entityData.set(COLOR_R, (Object)Float.valueOf(tag.getFloat("ColorR")));
        this.entityData.set(COLOR_G, (Object)Float.valueOf(tag.getFloat("ColorG")));
        this.entityData.set(COLOR_B, (Object)Float.valueOf(tag.getFloat("ColorB")));
        this.rotation = new Quaternionf(tag.getFloat("RotationX"), tag.getFloat("RotationY"), tag.getFloat("RotationZ"), tag.getFloat("RotationW"));
        this.entityData.set(ROTATION_X, (Object)Float.valueOf(this.rotation.x));
        this.entityData.set(ROTATION_Y, (Object)Float.valueOf(this.rotation.y));
        this.entityData.set(ROTATION_Z, (Object)Float.valueOf(this.rotation.z));
        this.entityData.set(ROTATION_W, (Object)Float.valueOf(this.rotation.w));
        this.setSize(this.quadSize, (double)this.quadSize * 0.075, (double)this.quadSize * 0.2);
    }

    public Vec3 getPos() {
        return new Vec3((double)((Float)this.entityData.get(X)).floatValue(), (double)((Float)this.entityData.get(Y)).floatValue(), (double)((Float)this.entityData.get(Z)).floatValue());
    }

    public Vec3 getPosOld() {
        return new Vec3((double)((Float)this.entityData.get(XO)).floatValue(), (double)((Float)this.entityData.get(YO)).floatValue(), (double)((Float)this.entityData.get(ZO)).floatValue());
    }

    public float getQuadSize() {
        return ((Float)this.entityData.get(QUAD_SIZE)).floatValue();
    }

    public int getPackedLight() {
        return (Integer)this.entityData.get(PACKED_LIGHT);
    }

    public ResourceLocation getWaveTexture() {
        return WaveHelpers.identifier((String)this.entityData.get(WAVE_TEXTURE));
    }

    public Color getColor() {
        return new Color(((Float)this.entityData.get(COLOR_R)).floatValue(), ((Float)this.entityData.get(COLOR_G)).floatValue(), ((Float)this.entityData.get(COLOR_B)).floatValue(), ((Float)this.entityData.get(ALPHA)).floatValue());
    }

    public Quaternionf getRotation() {
        return new Quaternionf(((Float)this.entityData.get(ROTATION_X)).floatValue(), ((Float)this.entityData.get(ROTATION_Y)).floatValue(), ((Float)this.entityData.get(ROTATION_Z)).floatValue(), ((Float)this.entityData.get(ROTATION_W)).floatValue());
    }

    public boolean shouldShowName() {
        return false;
    }
}

