/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.client;

import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.crop.CropTextures;
import com.blakebr0.mysticalagriculture.api.crop.CropType;
import com.blakebr0.mysticalagriculture.init.ModItems;
import com.blakebr0.mysticalagriculture.item.ExperienceCapsuleItem;
import com.blakebr0.mysticalagriculture.item.SoulJarItem;
import com.blakebr0.mysticalagriculture.item.tool.EssenceBowItem;
import com.blakebr0.mysticalagriculture.item.tool.EssenceCrossbowItem;
import com.blakebr0.mysticalagriculture.item.tool.EssenceFishingRodItem;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import com.google.common.base.Stopwatch;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.level.block.CropBlock;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public final class ModelHandler {
    private static final ResourceLocation MISSING_NO = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"missingno");

    @SubscribeEvent
    public void onRegisterAdditionalModels(ModelEvent.RegisterAdditional event) {
        for (int i = 0; i < 8; ++i) {
            event.register(ModelResourceLocation.standalone((ResourceLocation)MysticalAgriculture.resource("block/mystical_resource_crop_" + i)));
            event.register(ModelResourceLocation.standalone((ResourceLocation)MysticalAgriculture.resource("block/mystical_mob_crop_" + i)));
        }
        for (CropType type : CropRegistry.getInstance().getTypes()) {
            event.register(ModelResourceLocation.standalone((ResourceLocation)CropTextures.FLOWER_INGOT_BLANK.withSuffix("_" + type.getName())));
            event.register(ModelResourceLocation.standalone((ResourceLocation)CropTextures.FLOWER_ROCK_BLANK.withSuffix("_" + type.getName())));
            event.register(ModelResourceLocation.standalone((ResourceLocation)CropTextures.FLOWER_DUST_BLANK.withSuffix("_" + type.getName())));
            event.register(ModelResourceLocation.standalone((ResourceLocation)CropTextures.FLOWER_FACE_BLANK.withSuffix("_" + type.getName())));
        }
        event.register(ModelResourceLocation.standalone((ResourceLocation)CropTextures.ESSENCE_INGOT_BLANK));
        event.register(ModelResourceLocation.standalone((ResourceLocation)CropTextures.ESSENCE_ROCK_BLANK));
        event.register(ModelResourceLocation.standalone((ResourceLocation)CropTextures.ESSENCE_DUST_BLANK));
        event.register(ModelResourceLocation.standalone((ResourceLocation)CropTextures.ESSENCE_GEM_BLANK));
        event.register(ModelResourceLocation.standalone((ResourceLocation)CropTextures.ESSENCE_TALL_GEM_BLANK));
        event.register(ModelResourceLocation.standalone((ResourceLocation)CropTextures.ESSENCE_DIAMOND_BLANK));
        event.register(ModelResourceLocation.standalone((ResourceLocation)CropTextures.ESSENCE_QUARTZ_BLANK));
        event.register(ModelResourceLocation.standalone((ResourceLocation)CropTextures.ESSENCE_FLAME_BLANK));
        event.register(ModelResourceLocation.standalone((ResourceLocation)CropTextures.ESSENCE_ROD_BLANK));
        event.register(ModelResourceLocation.standalone((ResourceLocation)CropTextures.SEED_BLANK));
    }

    @SubscribeEvent
    public void onModifyBakingResults(ModelEvent.ModifyBakingResult event) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Map registry = event.getModels();
        HashMap<ResourceLocation, BakedModel[]> cropModels = new HashMap<ResourceLocation, BakedModel[]>();
        for (CropType cropType : CropRegistry.getInstance().getTypes()) {
            cropModels.put(cropType.getId(), (BakedModel[])IntStream.range(0, 7).mapToObj(i -> (BakedModel)registry.get(ModelResourceLocation.standalone((ResourceLocation)cropType.getStemModel().withSuffix("_" + i)))).toArray(BakedModel[]::new));
        }
        for (Crop crop : CropRegistry.getInstance().getCrops()) {
            ItemNameBlockItem seeds;
            ResourceLocation seedsId;
            ModelResourceLocation location;
            BakedModel bakedModel;
            Item essence;
            ResourceLocation essenceId;
            ModelResourceLocation location2;
            BakedModel bakedModel2;
            BakedModel model;
            ResourceLocation texture;
            ResourceLocation type;
            CropTextures textures = crop.getTextures();
            CropBlock crops = crop.getCropBlock();
            ResourceLocation cropId = BuiltInRegistries.BLOCK.getKey((Object)crops);
            for (int i2 = 0; i2 < 7; ++i2) {
                ModelResourceLocation location3 = new ModelResourceLocation(cropId, "age=" + i2);
                BakedModel bakedModel3 = (BakedModel)registry.get(location3);
                if (bakedModel3 != null && !bakedModel3.getParticleIcon(ModelData.EMPTY).contents().name().equals((Object)MISSING_NO)) continue;
                type = crop.getType().getId();
                registry.replace(location3, ((BakedModel[])cropModels.get(type))[i2]);
            }
            ModelResourceLocation location4 = new ModelResourceLocation(cropId, "age=7");
            BakedModel bakedModel4 = (BakedModel)registry.get(location4);
            if (bakedModel4 == null || bakedModel4.getParticleIcon(ModelData.EMPTY).contents().name().equals((Object)MISSING_NO)) {
                ResourceLocation flower = textures.getFlowerTexture();
                type = crop.getType().getId();
                texture = ResourceLocation.fromNamespaceAndPath((String)type.getNamespace(), (String)(flower.getPath() + "_" + type.getPath()));
                model = ModelHandler.getBakedModel(texture, registry);
                registry.replace(location4, model);
            }
            if ((bakedModel2 = (BakedModel)registry.get(location2 = ModelResourceLocation.inventory((ResourceLocation)(essenceId = BuiltInRegistries.ITEM.getKey((Object)(essence = crop.getEssenceItem())))))) == null || bakedModel2.getParticleIcon(ModelData.EMPTY).contents().name().equals((Object)MISSING_NO)) {
                texture = textures.getEssenceTexture();
                model = ModelHandler.getBakedModel(texture, registry);
                registry.replace(location2, model);
            }
            if ((bakedModel = (BakedModel)registry.get(location = ModelResourceLocation.inventory((ResourceLocation)(seedsId = BuiltInRegistries.ITEM.getKey((Object)(seeds = crop.getSeedsItem())))))) != null && !bakedModel.getParticleIcon(ModelData.EMPTY).contents().name().equals((Object)MISSING_NO)) continue;
            ResourceLocation texture2 = textures.getSeedTexture();
            BakedModel model2 = ModelHandler.getBakedModel(texture2, registry);
            registry.replace(location, model2);
        }
        stopwatch.stop();
        MysticalAgriculture.LOGGER.info("Model replacement took {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)ModItems.EXPERIENCE_CAPSULE.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"fill"), (ItemPropertyFunction)ExperienceCapsuleItem.getFillPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.SOUL_JAR.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"fill"), (ItemPropertyFunction)SoulJarItem.getFillPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.INFERIUM_BOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (ItemPropertyFunction)EssenceBowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.INFERIUM_BOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), (ItemPropertyFunction)EssenceBowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.INFERIUM_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (ItemPropertyFunction)EssenceCrossbowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.INFERIUM_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), (ItemPropertyFunction)EssenceCrossbowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.INFERIUM_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"charged"), (ItemPropertyFunction)EssenceCrossbowItem.getChargedPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.INFERIUM_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"firework"), (ItemPropertyFunction)EssenceCrossbowItem.getFireworkPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.INFERIUM_FISHING_ROD.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"cast"), (ItemPropertyFunction)EssenceFishingRodItem.getCastPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.PRUDENTIUM_BOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (ItemPropertyFunction)EssenceBowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.PRUDENTIUM_BOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), (ItemPropertyFunction)EssenceBowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.PRUDENTIUM_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (ItemPropertyFunction)EssenceCrossbowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.PRUDENTIUM_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), (ItemPropertyFunction)EssenceCrossbowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.PRUDENTIUM_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"charged"), (ItemPropertyFunction)EssenceCrossbowItem.getChargedPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.PRUDENTIUM_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"firework"), (ItemPropertyFunction)EssenceCrossbowItem.getFireworkPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.PRUDENTIUM_FISHING_ROD.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"cast"), (ItemPropertyFunction)EssenceFishingRodItem.getCastPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.TERTIUM_BOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (ItemPropertyFunction)EssenceBowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.TERTIUM_BOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), (ItemPropertyFunction)EssenceBowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.TERTIUM_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (ItemPropertyFunction)EssenceCrossbowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.TERTIUM_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), (ItemPropertyFunction)EssenceCrossbowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.TERTIUM_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"charged"), (ItemPropertyFunction)EssenceCrossbowItem.getChargedPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.TERTIUM_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"firework"), (ItemPropertyFunction)EssenceCrossbowItem.getFireworkPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.TERTIUM_FISHING_ROD.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"cast"), (ItemPropertyFunction)EssenceFishingRodItem.getCastPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.IMPERIUM_BOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (ItemPropertyFunction)EssenceBowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.IMPERIUM_BOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), (ItemPropertyFunction)EssenceBowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.IMPERIUM_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (ItemPropertyFunction)EssenceCrossbowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.IMPERIUM_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), (ItemPropertyFunction)EssenceCrossbowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.IMPERIUM_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"charged"), (ItemPropertyFunction)EssenceCrossbowItem.getChargedPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.IMPERIUM_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"firework"), (ItemPropertyFunction)EssenceCrossbowItem.getFireworkPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.IMPERIUM_FISHING_ROD.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"cast"), (ItemPropertyFunction)EssenceFishingRodItem.getCastPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.SUPREMIUM_BOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (ItemPropertyFunction)EssenceBowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.SUPREMIUM_BOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), (ItemPropertyFunction)EssenceBowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.SUPREMIUM_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (ItemPropertyFunction)EssenceCrossbowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.SUPREMIUM_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), (ItemPropertyFunction)EssenceCrossbowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.SUPREMIUM_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"charged"), (ItemPropertyFunction)EssenceCrossbowItem.getChargedPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.SUPREMIUM_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"firework"), (ItemPropertyFunction)EssenceCrossbowItem.getFireworkPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.SUPREMIUM_FISHING_ROD.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"cast"), (ItemPropertyFunction)EssenceFishingRodItem.getCastPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.AWAKENED_SUPREMIUM_BOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (ItemPropertyFunction)EssenceBowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.AWAKENED_SUPREMIUM_BOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), (ItemPropertyFunction)EssenceBowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.AWAKENED_SUPREMIUM_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (ItemPropertyFunction)EssenceCrossbowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.AWAKENED_SUPREMIUM_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), (ItemPropertyFunction)EssenceCrossbowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.AWAKENED_SUPREMIUM_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"charged"), (ItemPropertyFunction)EssenceCrossbowItem.getChargedPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.AWAKENED_SUPREMIUM_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"firework"), (ItemPropertyFunction)EssenceCrossbowItem.getFireworkPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.AWAKENED_SUPREMIUM_FISHING_ROD.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"cast"), (ItemPropertyFunction)EssenceFishingRodItem.getCastPropertyGetter());
        });
    }

    @Nullable
    private static BakedModel getBakedModel(ResourceLocation location, Map<ModelResourceLocation, BakedModel> registry) {
        ModelResourceLocation path = ModelResourceLocation.standalone((ResourceLocation)location);
        BakedModel model = registry.get(path);
        if (model != null) {
            return model;
        }
        path = ModelResourceLocation.inventory((ResourceLocation)location);
        model = registry.get(path);
        return model;
    }
}

