/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.goal;

import com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.SandSnapperEntity;
import com.yungnickyoung.minecraft.yungscavebiomes.module.ItemModule;
import com.yungnickyoung.minecraft.yungscavebiomes.sandstorm.ISandstormServerDataProvider;
import com.yungnickyoung.minecraft.yungscavebiomes.sandstorm.SandstormServerData;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class EatPeachGoal
extends Goal {
    private final SandSnapperEntity sandSnapper;
    private final float horizontalRange;
    private final float verticalRange;
    private final float playerDist;
    private final float eatRange;
    private ItemEntity peachItem;
    private int eatingTimer;
    private static final int EAT_LENGTH = 31;

    public EatPeachGoal(SandSnapperEntity sandSnapper, float horizontalRange, float verticalRange, float playerDist, float eatRange) {
        this.sandSnapper = sandSnapper;
        this.horizontalRange = horizontalRange;
        this.verticalRange = verticalRange;
        this.playerDist = playerDist;
        this.eatRange = eatRange;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public void start() {
        this.sandSnapper.setSubmerged(false);
        this.sandSnapper.setSubmergeLocked(true);
        this.sandSnapper.getNavigation().moveTo((Entity)this.peachItem, 1.0);
    }

    public void stop() {
        this.sandSnapper.setEating(false);
        this.sandSnapper.setSubmergeLocked(false);
    }

    public void tick() {
        if (this.sandSnapper.distanceTo((Entity)this.peachItem) > this.eatRange && this.sandSnapper.getNavigation().isDone()) {
            if (this.sandSnapper.isEating()) {
                this.sandSnapper.setEating(false);
            }
            this.sandSnapper.getNavigation().moveTo((Entity)this.peachItem, 1.0);
        } else if (this.sandSnapper.distanceTo((Entity)this.peachItem) <= this.eatRange && !this.sandSnapper.isEating()) {
            this.sandSnapper.setEating(true);
            this.eatingTimer = 31;
        }
        if (this.sandSnapper.isEating()) {
            --this.eatingTimer;
            if (this.eatingTimer <= 0) {
                this.sandSnapper.setEating(false);
                this.peachItem.discard();
                this.sandSnapper.onEat();
            }
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean canUse() {
        List itemsNearby = this.sandSnapper.level().getEntitiesOfClass(ItemEntity.class, this.sandSnapper.getBoundingBox().inflate((double)this.horizontalRange, (double)this.verticalRange, (double)this.horizontalRange), entity -> entity.getItem().is((Item)ItemModule.PRICKLY_PEACH_ITEM.get()));
        if (itemsNearby.isEmpty()) {
            return false;
        }
        SandstormServerData sandstormServerData = ((ISandstormServerDataProvider)this.sandSnapper.level()).getSandstormServerData();
        Collections.shuffle(itemsNearby);
        if (!sandstormServerData.isSandstormActive()) {
            for (ItemEntity item : itemsNearby) {
                Player nearestPlayer = item.level().getNearestPlayer(item.getX(), item.getY(), item.getZ(), (double)this.playerDist, true);
                if (nearestPlayer != null) continue;
                this.peachItem = item;
                return true;
            }
        } else {
            this.peachItem = (ItemEntity)itemsNearby.get(0);
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        if (this.peachItem.isRemoved()) {
            return false;
        }
        SandstormServerData sandstormServerData = ((ISandstormServerDataProvider)this.sandSnapper.level()).getSandstormServerData();
        if (!sandstormServerData.isSandstormActive()) {
            Player nearestPlayer = this.peachItem.level().getNearestPlayer(this.peachItem.getX(), this.peachItem.getY(), this.peachItem.getZ(), (double)this.playerDist, true);
            return nearestPlayer == null;
        }
        return true;
    }
}

