/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config;

import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ConfigWithVariants;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.AbstractButtonListScreen;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class EnumConfig<E>
extends ConfigWithVariants<E> {
    public final NameMap<E> nameMap;

    public EnumConfig(NameMap<E> nm) {
        this.nameMap = nm;
        this.defaultValue = this.nameMap.defaultValue;
        this.value = this.nameMap.defaultValue;
    }

    @Override
    public Component getStringForGUI(E v) {
        return this.nameMap.getDisplayName(v);
    }

    @Override
    public Color4I getColor(E v) {
        Color4I col = this.nameMap.getColor(v);
        return col.isEmpty() ? Tristate.DEFAULT.color : col;
    }

    @Override
    public void addInfo(TooltipList list) {
        super.addInfo(list);
        if (this.nameMap.size() > 0) {
            list.blankLine();
            for (int i = 0; i < this.nameMap.size(); ++i) {
                if (i >= 10) {
                    list.add((Component)Component.literal((String)("... " + (this.nameMap.size() - i) + " more ...")).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                    break;
                }
                E v = this.nameMap.get(i);
                boolean e = this.isEqual(v, this.value);
                MutableComponent c = Component.literal((String)(e ? "+ " : "- "));
                c.withStyle(e ? ChatFormatting.AQUA : ChatFormatting.DARK_GRAY);
                c.append(this.nameMap.getDisplayName(v));
                list.add((Component)c);
            }
        }
    }

    @Override
    public void onClicked(Widget clickedWidget, MouseButton button, ConfigCallback callback) {
        if (this.nameMap.values.size() > 16 || BaseScreen.isCtrlKeyDown()) {
            EnumSelectScreen screen = new EnumSelectScreen(clickedWidget.getParent());
            screen.setHasSearchBox(true);
            screen.showBottomPanel(false);
            screen.showCloseButton(true);
            screen.openGui();
        } else {
            super.onClicked(clickedWidget, button, callback);
        }
    }

    @Override
    public E getIteration(E currentValue, boolean next) {
        return next ? this.nameMap.getNext(currentValue) : this.nameMap.getPrevious(currentValue);
    }

    @Override
    public Icon getIcon(@Nullable E v) {
        Icon icon;
        if (v != null && !(icon = this.nameMap.getIcon(v)).isEmpty()) {
            return icon;
        }
        return super.getIcon(v);
    }

    private class EnumSelectScreen
    extends AbstractButtonListScreen {
        private final Panel parent;
        private int maxWidth = 176;

        public EnumSelectScreen(Panel parent) {
            this.parent = parent;
            for (Object v : EnumConfig.this.nameMap) {
                this.maxWidth = Math.max(this.maxWidth, this.getTheme().getStringWidth((FormattedText)EnumConfig.this.nameMap.getDisplayName(v)));
            }
        }

        @Override
        public void addButtons(Panel panel) {
            for (final Object v : EnumConfig.this.nameMap) {
                panel.add(new SimpleTextButton(panel, EnumConfig.this.nameMap.getDisplayName(v), EnumConfig.this.nameMap.getIcon(v)){

                    @Override
                    public void onClicked(MouseButton button) {
                        this.playClickSound();
                        EnumConfig.this.setCurrentValue(v);
                        EnumSelectScreen.this.doAccept();
                    }
                });
            }
        }

        @Override
        public boolean onInit() {
            this.setSize(Mth.clamp((int)(this.maxWidth + 35), (int)176, (int)(this.getWindow().getGuiScaledWidth() * 3 / 4)), Mth.clamp((int)(EnumConfig.this.nameMap.size() * 20 + 50), (int)166, (int)(this.getWindow().getGuiScaledHeight() * 4 / 5)));
            return super.onInit();
        }

        @Override
        protected void doCancel() {
            this.parent.run();
        }

        @Override
        protected void doAccept() {
            this.parent.run();
        }
    }
}

