/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui.resource;

import com.mojang.serialization.DynamicOps;
import dev.architectury.fluid.FluidStack;
import dev.ftb.mods.ftblibrary.config.ui.resource.SelectableResource;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;

public final class FluidStackResource
extends Record
implements SelectableResource<FluidStack> {
    private final FluidStack resource;

    public FluidStackResource(FluidStack resource) {
        this.resource = resource;
    }

    @Override
    public long getCount() {
        return this.resource().getAmount();
    }

    @Override
    public void setCount(int count) {
        this.resource.setAmount((long)count);
    }

    @Override
    public Component getName() {
        return this.resource.getName();
    }

    @Override
    public Icon getIcon() {
        return Icon.getIcon(ClientUtils.getStillTexture(this.resource)).withTint(Color4I.rgb(ClientUtils.getFluidColor(this.resource)));
    }

    @Override
    public SelectableResource<FluidStack> copyWithCount(long count) {
        return SelectableResource.fluid(this.resource.copyWithAmount(count));
    }

    @Override
    public CompoundTag getComponentsTag() {
        CompoundTag t;
        Tag tag = (Tag)DataComponentMap.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.resource.getComponents()).result().orElse(new CompoundTag());
        return tag instanceof CompoundTag ? (t = (CompoundTag)tag) : null;
    }

    @Override
    public void applyComponentsTag(CompoundTag tag) {
        DataComponentMap.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag).result().ifPresent(arg_0 -> ((FluidStack)this.resource).applyComponents(arg_0));
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{FluidStackResource.class, "resource", "resource"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FluidStackResource.class, "resource", "resource"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FluidStackResource.class, "resource", "resource"}, this, o);
    }

    @Override
    public FluidStack resource() {
        return this.resource;
    }
}

