/*
 * Decompiled with CFR 0.152.
 */
package com.weido.create_bb.data.menu.Input;

import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.weido.create_bb.data.menu.Entry.StyleEntry;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ValveGearScrollInput
extends ScrollInput {
    private final MutableComponent scrollToSelect = Component.translatable((String)"create_bb.menu.scroll_selection");
    private final MutableComponent noOptionAvailable = Component.translatable((String)"create_bb.menu.no_options_available");
    public StyleEntry.ValveGear[] valveGears = StyleEntry.ValveGear.values();

    public ValveGearScrollInput(int xIn, int yIn, int widthIn, int heightIn) {
        super(xIn, yIn, widthIn, heightIn);
        this.withRange(0, this.valveGears.length).titled(Component.translatable((String)"create_bb.menu.valve_gear")).format(index -> index >= this.valveGears.length ? Component.empty() : this.valveGears[index].getDisplayText()).inverted().setState(0);
        this.updateTooltip();
    }

    public void updateOptions(Set<StyleEntry.ValveGear> validVariants) {
        LinkedList<StyleEntry.ValveGear> sortedList = new LinkedList<StyleEntry.ValveGear>(validVariants);
        List<StyleEntry.ValveGear> priorityOrder = List.of(StyleEntry.ValveGear.NONE, StyleEntry.ValveGear.WALSCHAERTS, StyleEntry.ValveGear.SCOTCH_YOKE, StyleEntry.ValveGear.ROTARY_POPPET);
        sortedList.sort(Comparator.comparingInt(priorityOrder::indexOf));
        this.valveGears = sortedList.toArray(new StyleEntry.ValveGear[0]);
        this.withRange(0, this.valveGears.length);
        if (this.state >= this.valveGears.length) {
            this.setState(0);
        }
        this.format(index -> index >= this.valveGears.length ? Component.empty() : this.valveGears[index].getDisplayText());
        this.updateTooltip();
    }

    protected void updateTooltip() {
        this.toolTip.clear();
        if (this.title != null) {
            this.toolTip.add(this.title.copy().withStyle(s -> s.withColor(HEADER_RGB.getRGB())));
        }
        for (int i = 0; i < this.valveGears.length; ++i) {
            MutableComponent valvegear = Component.empty().append(i == this.state ? "-> " : "> ").append(this.valveGears[i].getDisplayText());
            this.toolTip.add(valvegear.withStyle(i == this.state ? ChatFormatting.WHITE : ChatFormatting.GRAY));
        }
        if (this.valveGears.length == 1) {
            this.toolTip.add(this.noOptionAvailable.plainCopy().withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        } else {
            this.toolTip.add(this.scrollToSelect.plainCopy().withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        }
    }
}

