/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.miscellaneous;

import guideme.internal.shaded.lucene.analysis.TokenFilterFactory;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.miscellaneous.LimitTokenOffsetFilter;
import java.util.Map;

public class LimitTokenOffsetFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "limitTokenOffset";
    public static final String MAX_START_OFFSET = "maxStartOffset";
    public static final String CONSUME_ALL_TOKENS_KEY = "consumeAllTokens";
    private int maxStartOffset;
    private boolean consumeAllTokens;

    public LimitTokenOffsetFilterFactory(Map<String, String> args) {
        super(args);
        this.maxStartOffset = this.requireInt(args, MAX_START_OFFSET);
        this.consumeAllTokens = this.getBoolean(args, CONSUME_ALL_TOKENS_KEY, false);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + String.valueOf(args));
        }
    }

    public LimitTokenOffsetFilterFactory() {
        throw LimitTokenOffsetFilterFactory.defaultCtorException();
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new LimitTokenOffsetFilter(input, this.maxStartOffset, this.consumeAllTokens);
    }
}

