/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation;

import com.google.common.collect.HashMultimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.ApiStatus;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.SynchedAnimationVariableKey;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.api.utils.datastructure.ParameterizedHashMap;
import yesman.epicfight.api.utils.datastructure.ParameterizedMap;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.network.common.BiDirectionalAnimationVariable;

public class AnimationVariables {
    protected final Animator animator;
    protected final ParameterizedHashMap<AnimationVariableKey<?>> animationVariables = new ParameterizedHashMap();
    protected final HashMultimap<AssetAccessor<? extends StaticAnimation>, PendingData<?>> pendingIndependentVariables = HashMultimap.create();

    public AnimationVariables(Animator animator) {
        this.animator = animator;
    }

    public <T> Optional<T> getSharedVariable(SharedVariableKey<T> key) {
        return Optional.ofNullable(this.animationVariables.get(key));
    }

    public <T> T getOrDefaultSharedVariable(SharedVariableKey<T> key) {
        return (T)ParseUtil.orElse(this.animationVariables.get(key), () -> key.defaultValue(this.animator));
    }

    public <T> Optional<T> get(IndependentVariableKey<T> key, AssetAccessor<? extends StaticAnimation> animation) {
        if (animation == null) {
            return Optional.empty();
        }
        Map subMap = (Map)this.animationVariables.get(key);
        if (subMap == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(subMap.get(animation.registryName()));
    }

    public <T> T getOrDefault(IndependentVariableKey<T> key, AssetAccessor<? extends StaticAnimation> animation) {
        if (animation == null) {
            return Objects.requireNonNull(key.defaultValue(this.animator), "Null value returned by default provider.");
        }
        Map subMap = (Map)this.animationVariables.get(key);
        if (subMap == null) {
            return Objects.requireNonNull(key.defaultValue(this.animator), "Null value returned by default provider.");
        }
        return (T)ParseUtil.orElse(subMap.get(animation.registryName()), () -> key.defaultValue(this.animator));
    }

    public <T> void putSharedVariableWithDefault(SharedVariableKey<T> key) {
        Object value = key.defaultValue(this.animator);
        Objects.requireNonNull(value, "Null value returned by default provider.");
        this.putSharedVariable(key, value);
    }

    public <T> void putSharedVariable(SharedVariableKey<T> key, T value) {
        this.putSharedVariable(key, value, true);
    }

    @ApiStatus.Internal
    public <T> void putSharedVariable(SharedVariableKey<T> key, T value, boolean synchronize) {
        if (this.animationVariables.containsKey((AnimationVariableKey<?>)key) && !key.mutable()) {
            throw new UnsupportedOperationException("Can't modify a const variable");
        }
        this.animationVariables.put(key, value);
        if (synchronize && key.isSynched()) {
            SynchedAnimationVariableKey.synchronize((SynchedAnimationVariableKey)((Object)key), this.animator.entitypatch, null, value, BiDirectionalAnimationVariable.Action.PUT);
        }
    }

    public <T> void putDefaultValue(IndependentVariableKey<T> key, AssetAccessor<? extends StaticAnimation> animation) {
        Object value = key.defaultValue(this.animator);
        Objects.requireNonNull(value, "Null value returned by default provider.");
        this.put(key, animation, value);
    }

    public <T> void put(IndependentVariableKey<T> key, AssetAccessor<? extends StaticAnimation> animation, T value) {
        this.put(key, animation, value, true);
    }

    @ApiStatus.Internal
    public <T> void put(IndependentVariableKey<T> key, AssetAccessor<? extends StaticAnimation> animation, T value, boolean synchronize) {
        if (animation == Animations.EMPTY_ANIMATION) {
            return;
        }
        this.animationVariables.computeIfPresent(key, (k, v) -> {
            Map variablesByAnimations = (Map)v;
            if (!key.mutable() && variablesByAnimations.containsKey(animation.registryName())) {
                throw new UnsupportedOperationException("Can't modify a const variable");
            }
            variablesByAnimations.put(animation.registryName(), value);
            return v;
        });
        this.animationVariables.computeIfAbsent(key, k -> new HashMap<ResourceLocation, Object>(Map.of(animation.registryName(), value)));
        if (synchronize && key.isSynched()) {
            if (this.animator.isPlaying(animation)) {
                SynchedAnimationVariableKey.synchronize((SynchedAnimationVariableKey)((Object)key), this.animator.entitypatch, animation, value, BiDirectionalAnimationVariable.Action.PUT);
            } else {
                this.pendingIndependentVariables.put(animation, new PendingData<T>((SynchedAnimationVariableKey)((Object)key), value));
            }
        }
    }

    public <T> T removeSharedVariable(SharedVariableKey<T> key) {
        return this.removeSharedVariable(key, true);
    }

    @ApiStatus.Internal
    public <T> T removeSharedVariable(SharedVariableKey<T> key, boolean synchronize) {
        if (!key.mutable()) {
            throw new UnsupportedOperationException("Can't remove a const variable");
        }
        if (synchronize && key.isSynched()) {
            SynchedAnimationVariableKey.synchronize((SynchedAnimationVariableKey)((Object)key), this.animator.entitypatch, null, null, BiDirectionalAnimationVariable.Action.REMOVE);
        }
        return this.animationVariables.remove((AnimationVariableKey<?>)key);
    }

    @ApiStatus.Internal
    public void removeAll(AnimationManager.AnimationAccessor<? extends StaticAnimation> animation) {
        if (animation == Animations.EMPTY_ANIMATION) {
            return;
        }
        for (Map.Entry<AnimationVariableKey<?>, Object> entry : this.animationVariables.entrySet()) {
            Map map;
            if (entry.getKey().isSharedKey() || (map = (Map)entry.getValue()) == null) continue;
            map.remove(animation.registryName());
        }
        this.pendingIndependentVariables.removeAll(animation);
    }

    public void remove(IndependentVariableKey<?> key, AssetAccessor<? extends StaticAnimation> animation) {
        this.remove(key, animation, true);
    }

    @ApiStatus.Internal
    public void remove(IndependentVariableKey<?> key, AssetAccessor<? extends StaticAnimation> animation, boolean synchronize) {
        if (animation == Animations.EMPTY_ANIMATION) {
            return;
        }
        if (!key.mutable()) {
            throw new UnsupportedOperationException("Can't remove a const variable");
        }
        Map map = (Map)this.animationVariables.get(key);
        if (map != null) {
            map.remove(animation.registryName());
        }
        if (synchronize && key.isSynched()) {
            SynchedAnimationVariableKey.synchronize((SynchedAnimationVariableKey)((Object)key), this.animator.entitypatch, null, null, BiDirectionalAnimationVariable.Action.REMOVE);
            this.pendingIndependentVariables.remove(animation, key);
        }
    }

    public List<BiDirectionalAnimationVariable> createPendingVariablesPayloads(AssetAccessor<? extends StaticAnimation> animation) {
        Set pendingdata = this.pendingIndependentVariables.removeAll(animation);
        return pendingdata.stream().map(pair -> SynchedAnimationVariableKey.createPayload(pair.key(), this.animator.getEntityPatch(), animation, pair.value(), BiDirectionalAnimationVariable.Action.PUT)).toList();
    }

    public static <T> SharedVariableKey<T> unsynchShared(Function<Animator, T> defaultValueSupplier, boolean mutable) {
        return new UnsynchedSharedAnimationVariableKey<T>(defaultValueSupplier, mutable);
    }

    public static <T> IndependentVariableKey<T> unsyncIndependent(Function<Animator, T> defaultValueSupplier, boolean mutable) {
        return new UnsynchedIndependentAnimationVariableKey<T>(defaultValueSupplier, mutable);
    }

    public static interface SharedVariableKey<T>
    extends AnimationVariableKey<T> {
    }

    public static interface IndependentVariableKey<T>
    extends AnimationVariableKey<T> {
    }

    public record PendingData<T>(SynchedAnimationVariableKey<T> key, T value) {
        @Override
        public boolean equals(Object object) {
            if (object instanceof SynchedAnimationVariableKey) {
                SynchedAnimationVariableKey synchedDataKey = (SynchedAnimationVariableKey)object;
                return this.key.equals(synchedDataKey);
            }
            if (object instanceof PendingData) {
                PendingData pendingData = (PendingData)object;
                return this.key.equals(pendingData.key());
            }
            return false;
        }
    }

    public static interface AnimationVariableKey<T>
    extends ParameterizedMap.ParameterizedKey<T> {
        public boolean mutable();

        @Override
        default public T defaultValue() {
            throw new UnsupportedOperationException("Use defaultValue(Animator) to get default value of animation variable key");
        }

        public @NonNull T defaultValue(Animator var1);

        default public boolean isSharedKey() {
            return this instanceof SharedVariableKey;
        }

        default public boolean isSynched() {
            return this instanceof SynchedAnimationVariableKey;
        }
    }

    public static class UnsynchedSharedAnimationVariableKey<T>
    implements SharedVariableKey<T> {
        private final Function<Animator, T> initValueSupplier;
        private final boolean mutable;

        protected UnsynchedSharedAnimationVariableKey(Function<Animator, T> initValueSupplier, boolean mutable) {
            this.initValueSupplier = initValueSupplier;
            this.mutable = mutable;
        }

        @Override
        public boolean mutable() {
            return this.mutable;
        }

        @Override
        public @NonNull T defaultValue(Animator animator) {
            return this.initValueSupplier.apply(animator);
        }
    }

    public static class UnsynchedIndependentAnimationVariableKey<T>
    implements IndependentVariableKey<T> {
        private final Function<Animator, T> initValueSupplier;
        private final boolean mutable;

        protected UnsynchedIndependentAnimationVariableKey(Function<Animator, T> initValueSupplier, boolean mutable) {
            this.initValueSupplier = initValueSupplier;
            this.mutable = mutable;
        }

        @Override
        public boolean mutable() {
            return this.mutable;
        }

        @Override
        public @NonNull T defaultValue(Animator animator) {
            return this.initValueSupplier.apply(animator);
        }
    }
}

