/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationClip;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.DirectStaticAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.QuaternionUtils;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class AimAnimation
extends StaticAnimation {
    public DirectStaticAnimation lookForward;
    public DirectStaticAnimation lookUp;
    public DirectStaticAnimation lookDown;
    public DirectStaticAnimation lying;

    public AimAnimation(boolean repeatPlay, AnimationManager.AnimationAccessor<? extends AimAnimation> accessor, String path1, String path2, String path3, String path4, AssetAccessor<? extends Armature> armature) {
        this(0.15f, repeatPlay, accessor, path1, path2, path3, path4, armature);
    }

    public AimAnimation(float transitionTime, boolean repeatPlay, AnimationManager.AnimationAccessor<? extends AimAnimation> accessor, String path1, String path2, String path3, String path4, AssetAccessor<? extends Armature> armature) {
        super(transitionTime, repeatPlay, accessor, armature);
        this.lookForward = new DirectStaticAnimation(transitionTime, repeatPlay, ResourceLocation.fromNamespaceAndPath((String)accessor.registryName().getNamespace(), (String)path1), armature);
        this.lookUp = new DirectStaticAnimation(transitionTime, repeatPlay, ResourceLocation.fromNamespaceAndPath((String)accessor.registryName().getNamespace(), (String)path2), armature);
        this.lookDown = new DirectStaticAnimation(transitionTime, repeatPlay, ResourceLocation.fromNamespaceAndPath((String)accessor.registryName().getNamespace(), (String)path3), armature);
        this.lying = new DirectStaticAnimation(transitionTime, repeatPlay, ResourceLocation.fromNamespaceAndPath((String)accessor.registryName().getNamespace(), (String)path4), armature);
        this.addProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER, (animation, entitypatch, speed, prevElapsedTime, elapsedTime) -> {
            if (animation.isLinkAnimation()) {
                return 1.0f;
            }
            if (((LivingEntity)entitypatch.getOriginal()).isUsingItem()) {
                return (this.getTotalTime() - elapsedTime) / this.getTotalTime();
            }
            return 1.0f;
        });
        this.addProperty(AnimationProperty.StaticAnimationProperty.POSE_MODIFIER, (animation, pose, entitypatch, elapsedTime, partialTicks) -> {
            if (!entitypatch.isFirstPerson() && !animation.isLinkAnimation()) {
                JointTransform chest = pose.orElseEmpty("Chest");
                JointTransform head = pose.orElseEmpty("Head");
                float f = 90.0f;
                float ratio = (f - Math.abs(((LivingEntity)entitypatch.getOriginal()).getXRot())) / f;
                float yRotHead = Mth.lerp((float)partialTicks, (float)((LivingEntity)entitypatch.getOriginal()).yHeadRotO, (float)((LivingEntity)entitypatch.getOriginal()).yHeadRot);
                float yRot = ((LivingEntity)entitypatch.getOriginal()).getVehicle() != null ? yRotHead : Mth.lerp((float)partialTicks, (float)((LivingEntity)entitypatch.getOriginal()).yBodyRotO, (float)((LivingEntity)entitypatch.getOriginal()).yBodyRot);
                MathUtils.mulQuaternion(QuaternionUtils.YP.rotationDegrees(Mth.wrapDegrees((float)(yRot - yRotHead)) * ratio), head.rotation(), head.rotation());
                chest.frontResult(JointTransform.rotation(QuaternionUtils.YP.rotationDegrees(Mth.wrapDegrees((float)(yRotHead - yRot)) * ratio)), OpenMatrix4f::mulAsOriginInverse);
            }
        });
    }

    @Override
    public void loadAnimation() {
        this.lookForward.loadAnimation();
        this.lookUp.loadAnimation();
        this.lookDown.loadAnimation();
        this.lying.loadAnimation();
    }

    @Override
    public Pose getPoseByTime(LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
        if (!entitypatch.isFirstPerson()) {
            LivingMotion livingMotion = entitypatch.getCurrentLivingMotion();
            if (livingMotion == LivingMotions.SWIM || livingMotion == LivingMotions.FLY || livingMotion == LivingMotions.CREATIVE_FLY) {
                Pose pose = this.lying.getPoseByTime(entitypatch, time, partialTicks);
                this.modifyPose(this, pose, entitypatch, time, partialTicks);
                return pose;
            }
            float pitch = ((LivingEntity)entitypatch.getOriginal()).getViewXRot(partialTicks);
            DirectStaticAnimation interpolateAnimation = pitch > 0.0f ? this.lookDown : this.lookUp;
            Pose pose1 = super.getPoseByTime(entitypatch, time, partialTicks);
            Pose pose2 = interpolateAnimation.getPoseByTime(entitypatch, time, partialTicks);
            Pose interpolatedPose = Pose.interpolatePose(pose1, pose2, Math.abs(pitch) / 90.0f);
            return interpolatedPose;
        }
        return this.lookForward.getPoseByTime(entitypatch, time, partialTicks);
    }

    @Override
    public List<AssetAccessor<? extends StaticAnimation>> getSubAnimations() {
        return List.of(this.lookForward, this.lookUp, this.lookDown, this.lying);
    }

    @Override
    public <V> Optional<V> getProperty(AnimationProperty<V> propertyType) {
        return this.lookForward.getProperty(propertyType);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Layer.Priority getPriority() {
        return this.lookForward.getProperty(ClientAnimationProperties.PRIORITY).orElse(Layer.Priority.LOWEST);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Layer.LayerType getLayerType() {
        return this.lookForward.getProperty(ClientAnimationProperties.LAYER_TYPE).orElse(Layer.LayerType.BASE_LAYER);
    }

    @Override
    public AnimationClip getAnimationClip() {
        return this.lookForward.getAnimationClip();
    }

    @Override
    public boolean isClientAnimation() {
        return true;
    }
}

