/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types.datapack;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationClip;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.animation.types.datapack.DatapackAnimation;
import yesman.epicfight.api.animation.types.datapack.EditorAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.client.animation.property.JointMask;
import yesman.epicfight.api.client.animation.property.JointMaskReloadListener;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class DatapackStaticAnimation
extends StaticAnimation
implements DatapackAnimation<DatapackStaticAnimation> {
    protected EditorAnimation fakeAnimation;
    protected ResourceLocation registryName;

    public DatapackStaticAnimation(float convertTime, boolean isRepeat, String path, AssetAccessor<? extends Armature> armature) {
        super(convertTime, isRepeat, path, armature);
        this.setRegistryName(ResourceLocation.parse((String)path));
        this.accessor = this;
    }

    @Override
    public void setCreator(EditorAnimation fakeAnimation) {
        this.fakeAnimation = fakeAnimation;
    }

    @Override
    public EditorAnimation getCreator() {
        return this.fakeAnimation;
    }

    @Override
    public void setAnimationClip(AnimationClip clip) {
        this.animationClip = clip;
    }

    @Override
    public void putOnPlayer(AnimationPlayer animationPlayer, LivingEntityPatch<?> entitypatch) {
        animationPlayer.setPlayAnimation(this);
        animationPlayer.tick(entitypatch);
    }

    @Override
    public DatapackStaticAnimation get() {
        return this;
    }

    @Override
    public void setRegistryName(ResourceLocation registryName) {
        this.registryName = registryName;
    }

    @Override
    public ResourceLocation registryName() {
        return this.registryName;
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public EditorAnimation readAnimationFromJson(JsonArray rawAnimationJson) {
        EditorAnimation fakeAnimation = new EditorAnimation(this.registryName().toString(), this.armature, this.animationClip, rawAnimationJson);
        fakeAnimation.setAnimationClass(EditorAnimation.AnimationType.STATIC);
        fakeAnimation.setParameter("convertTime", Float.valueOf(this.transitionTime));
        fakeAnimation.setParameter("isRepeat", this.isRepeat());
        fakeAnimation.setParameter("path", this.registryName().toString());
        fakeAnimation.setParameter("armature", this.armature);
        JsonObject propertiesJson = fakeAnimation.getPropertiesJson();
        this.getProperty(ClientAnimationProperties.MULTILAYER_ANIMATION).ifPresentOrElse((? super T multilayer) -> {
            JsonObject multilayerJson = new JsonObject();
            JsonObject baseJson = new JsonObject();
            baseJson.addProperty("priority", multilayer.getPriority().toString());
            JsonArray baseMasks = new JsonArray();
            this.getProperty(ClientAnimationProperties.JOINT_MASK).ifPresent((? super T jointMaskEntry) -> {
                for (Map.Entry<LivingMotion, JointMask.JointMaskSet> entry : jointMaskEntry.getEntries()) {
                    JsonObject maskObj = new JsonObject();
                    maskObj.addProperty("livingmotion", entry.getKey().toString());
                    maskObj.addProperty("type", JointMaskReloadListener.getKey(entry.getValue()).toString());
                    baseMasks.add((JsonElement)maskObj);
                }
                JsonObject maskObj = new JsonObject();
                JointMask.JointMaskSet defaultMask = jointMaskEntry.getDefaultMask();
                maskObj.addProperty("livingmotion", LivingMotions.ALL.toString());
                maskObj.addProperty("type", JointMaskReloadListener.getKey(defaultMask).toString());
                baseMasks.add((JsonElement)maskObj);
            });
            baseJson.add("masks", (JsonElement)baseMasks);
            JsonObject compositeJson = new JsonObject();
            compositeJson.addProperty("priority", this.getPriority().toString());
            JsonArray compositeMasks = new JsonArray();
            multilayer.getProperty(ClientAnimationProperties.JOINT_MASK).ifPresent((? super T jointMaskEntry) -> {
                for (Map.Entry<LivingMotion, JointMask.JointMaskSet> entry : jointMaskEntry.getEntries()) {
                    JsonObject maskObj = new JsonObject();
                    maskObj.addProperty("livingmotion", entry.getKey().toString());
                    maskObj.addProperty("type", JointMaskReloadListener.getKey(entry.getValue()).toString());
                    compositeMasks.add((JsonElement)maskObj);
                }
                JsonObject maskObj = new JsonObject();
                JointMask.JointMaskSet defaultMask = jointMaskEntry.getDefaultMask();
                maskObj.addProperty("livingmotion", LivingMotions.ALL.toString());
                maskObj.addProperty("type", JointMaskReloadListener.getKey(defaultMask).toString());
                compositeMasks.add((JsonElement)maskObj);
            });
            baseJson.add("masks", (JsonElement)compositeMasks);
            multilayerJson.add("base", (JsonElement)baseJson);
            multilayerJson.add("composite", (JsonElement)compositeJson);
            propertiesJson.add("multilayer", (JsonElement)multilayerJson);
        }, () -> {
            JsonArray masks = new JsonArray();
            this.getProperty(ClientAnimationProperties.JOINT_MASK).ifPresent((? super T jointMaskEntry) -> {
                for (Map.Entry<LivingMotion, JointMask.JointMaskSet> entry : jointMaskEntry.getEntries()) {
                    JsonObject maskObj = new JsonObject();
                    maskObj.addProperty("livingmotion", entry.getKey().toString());
                    maskObj.addProperty("type", JointMaskReloadListener.getKey(entry.getValue()).toString());
                    masks.add((JsonElement)maskObj);
                }
                JsonObject maskObj = new JsonObject();
                JointMask.JointMaskSet defaultMask = jointMaskEntry.getDefaultMask();
                maskObj.addProperty("livingmotion", LivingMotions.ALL.toString());
                maskObj.addProperty("type", JointMaskReloadListener.getKey(defaultMask).toString());
                masks.add((JsonElement)maskObj);
            });
            if (!masks.isEmpty()) {
                propertiesJson.add("masks", (JsonElement)masks);
            }
            propertiesJson.addProperty("layer", this.getLayerType().toString());
            propertiesJson.addProperty("priority", this.getPriority().toString());
        });
        this.fakeAnimation = fakeAnimation;
        return fakeAnimation;
    }
}

